/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.fieldcomparator;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.FieldComparator;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.LongValues;
import org.elasticsearch.index.fielddata.fieldcomparator.NumberComparatorBase;
import org.elasticsearch.search.MultiValueMode;

abstract class LongValuesComparatorBase<T extends Number>
extends NumberComparatorBase<T> {
    protected final IndexNumericFieldData<?> indexFieldData;
    protected final long missingValue;
    protected long bottom;
    protected LongValues readerValues;
    protected final MultiValueMode sortMode;

    public LongValuesComparatorBase(IndexNumericFieldData<?> indexFieldData, long missingValue, MultiValueMode sortMode) {
        this.indexFieldData = indexFieldData;
        this.missingValue = missingValue;
        this.sortMode = sortMode;
    }

    @Override
    public final int compareBottom(int doc) throws IOException {
        long v2 = this.sortMode.getRelevantValue(this.readerValues, doc, this.missingValue);
        return Long.compare(this.bottom, v2);
    }

    @Override
    public int compareTop(int doc) throws IOException {
        return Long.compare(((Number)this.top).longValue(), this.sortMode.getRelevantValue(this.readerValues, doc, this.missingValue));
    }

    @Override
    public final FieldComparator<T> setNextReader(AtomicReaderContext context) throws IOException {
        this.readerValues = this.indexFieldData.load(context).getLongValues();
        return this;
    }

    @Override
    public int compareBottomMissing() {
        return Long.compare(this.bottom, this.missingValue);
    }

    @Override
    public int compareTopMissing() {
        return Long.compare(((Number)this.top).longValue(), this.missingValue);
    }
}

