/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.util.Arrays;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.base.Preconditions;
import org.elasticsearch.common.util.AbstractBigArray;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.DoubleArray;

final class BigDoubleArray
extends AbstractBigArray
implements DoubleArray {
    private double[][] pages;

    public BigDoubleArray(long size, BigArrays bigArrays, boolean clearOnResize) {
        super(2048, bigArrays, clearOnResize);
        this.size = size;
        this.pages = new double[this.numPages(size)][];
        for (int i = 0; i < this.pages.length; ++i) {
            this.pages[i] = this.newDoublePage(i);
        }
    }

    @Override
    public double get(long index) {
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        return this.pages[pageIndex][indexInPage];
    }

    @Override
    public double set(long index, double value) {
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        double[] page = this.pages[pageIndex];
        double ret = page[indexInPage];
        page[indexInPage] = value;
        return ret;
    }

    @Override
    public double increment(long index, double inc) {
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        double[] dArray = this.pages[pageIndex];
        int n = indexInPage;
        double d = dArray[n] + inc;
        dArray[n] = d;
        return d;
    }

    @Override
    protected int numBytesPerElement() {
        return 4;
    }

    @Override
    public void resize(long newSize) {
        int i;
        int numPages = this.numPages(newSize);
        if (numPages > this.pages.length) {
            this.pages = (double[][])Arrays.copyOf(this.pages, ArrayUtil.oversize(numPages, RamUsageEstimator.NUM_BYTES_OBJECT_REF));
        }
        for (i = numPages - 1; i >= 0 && this.pages[i] == null; --i) {
            this.pages[i] = this.newDoublePage(i);
        }
        for (i = numPages; i < this.pages.length && this.pages[i] != null; ++i) {
            this.pages[i] = null;
            this.releasePage(i);
        }
        this.size = newSize;
    }

    @Override
    public void fill(long fromIndex, long toIndex, double value) {
        Preconditions.checkArgument(fromIndex <= toIndex);
        int fromPage = this.pageIndex(fromIndex);
        int toPage = this.pageIndex(toIndex - 1L);
        if (fromPage == toPage) {
            Arrays.fill(this.pages[fromPage], this.indexInPage(fromIndex), this.indexInPage(toIndex - 1L) + 1, value);
        } else {
            Arrays.fill(this.pages[fromPage], this.indexInPage(fromIndex), this.pages[fromPage].length, value);
            for (int i = fromPage + 1; i < toPage; ++i) {
                Arrays.fill(this.pages[i], value);
            }
            Arrays.fill(this.pages[toPage], 0, this.indexInPage(toIndex - 1L) + 1, value);
        }
    }
}

