/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search.type;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.search.ScoreDoc;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.ReduceSearchPhaseException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.type.TransportSearchHelper;
import org.elasticsearch.action.search.type.TransportSearchTypeAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.hppc.IntArrayList;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.action.SearchServiceListener;
import org.elasticsearch.search.action.SearchServiceTransportAction;
import org.elasticsearch.search.controller.SearchPhaseController;
import org.elasticsearch.search.fetch.FetchSearchRequest;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.threadpool.ThreadPool;

public class TransportSearchQueryThenFetchAction
extends TransportSearchTypeAction {
    @Inject
    public TransportSearchQueryThenFetchAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, SearchServiceTransportAction searchService, SearchPhaseController searchPhaseController) {
        super(settings, threadPool, clusterService, searchService, searchPhaseController);
    }

    @Override
    protected void doExecute(SearchRequest searchRequest, ActionListener<SearchResponse> listener) {
        new AsyncAction(searchRequest, listener).start();
    }

    private class AsyncAction
    extends TransportSearchTypeAction.BaseAsyncAction<QuerySearchResult> {
        final AtomicArray<FetchSearchResult> fetchResults;
        final AtomicArray<IntArrayList> docIdsToLoad;

        private AsyncAction(SearchRequest request, ActionListener<SearchResponse> listener) {
            super(TransportSearchQueryThenFetchAction.this, request, listener);
            this.fetchResults = new AtomicArray(this.firstResults.length());
            this.docIdsToLoad = new AtomicArray(this.firstResults.length());
        }

        @Override
        protected String firstPhaseName() {
            return "query";
        }

        @Override
        protected void sendExecuteFirstPhase(DiscoveryNode node, ShardSearchRequest request, SearchServiceListener<QuerySearchResult> listener) {
            TransportSearchQueryThenFetchAction.this.searchService.sendExecuteQuery(node, request, listener);
        }

        @Override
        protected void moveToSecondPhase() throws Exception {
            this.sortedShardList = TransportSearchQueryThenFetchAction.this.searchPhaseController.sortDocs(this.request, this.useSlowScroll, this.firstResults);
            TransportSearchQueryThenFetchAction.this.searchPhaseController.fillDocIdsToLoad(this.docIdsToLoad, this.sortedShardList);
            if (this.docIdsToLoad.asList().isEmpty()) {
                this.finishHim();
                return;
            }
            ScoreDoc[] lastEmittedDocPerShard = TransportSearchQueryThenFetchAction.this.searchPhaseController.getLastEmittedDocPerShard(this.request, this.sortedShardList, this.firstResults.length());
            AtomicInteger counter = new AtomicInteger(this.docIdsToLoad.asList().size());
            for (AtomicArray.Entry<IntArrayList> entry : this.docIdsToLoad.asList()) {
                QuerySearchResult queryResult = (QuerySearchResult)this.firstResults.get(entry.index);
                DiscoveryNode node = this.nodes.get(queryResult.shardTarget().nodeId());
                FetchSearchRequest fetchSearchRequest = this.createFetchRequest(queryResult, entry, lastEmittedDocPerShard);
                this.executeFetch(entry.index, queryResult.shardTarget(), counter, fetchSearchRequest, node);
            }
        }

        void executeFetch(final int shardIndex, final SearchShardTarget shardTarget, final AtomicInteger counter, final FetchSearchRequest fetchSearchRequest, DiscoveryNode node) {
            TransportSearchQueryThenFetchAction.this.searchService.sendExecuteFetch(node, fetchSearchRequest, new SearchServiceListener<FetchSearchResult>(){

                @Override
                public void onResult(FetchSearchResult result) {
                    result.shardTarget(shardTarget);
                    AsyncAction.this.fetchResults.set(shardIndex, result);
                    if (counter.decrementAndGet() == 0) {
                        AsyncAction.this.finishHim();
                    }
                }

                @Override
                public void onFailure(Throwable t) {
                    AsyncAction.this.docIdsToLoad.set(shardIndex, null);
                    AsyncAction.this.onFetchFailure(t, fetchSearchRequest, shardIndex, shardTarget, counter);
                }
            });
        }

        void onFetchFailure(Throwable t, FetchSearchRequest fetchSearchRequest, int shardIndex, SearchShardTarget shardTarget, AtomicInteger counter) {
            if (TransportSearchQueryThenFetchAction.this.logger.isDebugEnabled()) {
                TransportSearchQueryThenFetchAction.this.logger.debug("[{}] Failed to execute fetch phase", t, fetchSearchRequest.id());
            }
            this.addShardFailure(shardIndex, shardTarget, t);
            this.successfulOps.decrementAndGet();
            if (counter.decrementAndGet() == 0) {
                this.finishHim();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void finishHim() {
            try {
                this.innerFinishHim();
            }
            catch (Throwable e) {
                ReduceSearchPhaseException failure = new ReduceSearchPhaseException("fetch", "", e, this.buildShardFailures());
                if (TransportSearchQueryThenFetchAction.this.logger.isDebugEnabled()) {
                    TransportSearchQueryThenFetchAction.this.logger.debug("failed to reduce search", failure, new Object[0]);
                }
                this.listener.onFailure(failure);
            }
            finally {
                this.releaseIrrelevantSearchContexts(this.firstResults, this.docIdsToLoad);
            }
        }

        void innerFinishHim() throws Exception {
            InternalSearchResponse internalResponse = TransportSearchQueryThenFetchAction.this.searchPhaseController.merge(this.sortedShardList, this.firstResults, this.fetchResults);
            String scrollId = null;
            if (this.request.scroll() != null) {
                scrollId = TransportSearchHelper.buildScrollId(this.request.searchType(), (AtomicArray<? extends SearchPhaseResult>)this.firstResults, null);
            }
            this.listener.onResponse(new SearchResponse(internalResponse, scrollId, this.expectedSuccessfulOps, this.successfulOps.get(), this.buildTookInMillis(), this.buildShardFailures()));
        }
    }
}

