/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.explain;

import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.RoutingMissingException;
import org.elasticsearch.action.explain.ExplainRequest;
import org.elasticsearch.action.explain.ExplainResponse;
import org.elasticsearch.action.support.single.shard.TransportShardSingleOperationAction;
import org.elasticsearch.cache.recycler.CacheRecycler;
import org.elasticsearch.cache.recycler.PageCacheRecycler;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.internal.DefaultSearchContext;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.search.rescore.RescoreSearchContext;
import org.elasticsearch.search.rescore.Rescorer;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportExplainAction
extends TransportShardSingleOperationAction<ExplainRequest, ExplainResponse> {
    private final IndicesService indicesService;
    private final ScriptService scriptService;
    private final CacheRecycler cacheRecycler;
    private final PageCacheRecycler pageCacheRecycler;
    private final BigArrays bigArrays;

    @Inject
    public TransportExplainAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, IndicesService indicesService, ScriptService scriptService, CacheRecycler cacheRecycler, PageCacheRecycler pageCacheRecycler, BigArrays bigArrays) {
        super(settings, threadPool, clusterService, transportService);
        this.indicesService = indicesService;
        this.scriptService = scriptService;
        this.cacheRecycler = cacheRecycler;
        this.pageCacheRecycler = pageCacheRecycler;
        this.bigArrays = bigArrays;
    }

    @Override
    protected void doExecute(ExplainRequest request, ActionListener<ExplainResponse> listener) {
        request.nowInMillis = System.currentTimeMillis();
        super.doExecute(request, listener);
    }

    @Override
    protected String transportAction() {
        return "explain";
    }

    @Override
    protected String executor() {
        return "get";
    }

    @Override
    protected void resolveRequest(ClusterState state, ExplainRequest request) {
        String concreteIndex = state.metaData().concreteSingleIndex(request.index());
        request.filteringAlias(state.metaData().filteringAliases(concreteIndex, request.index()));
        request.index(state.metaData().concreteSingleIndex(request.index()));
        if (request.routing() == null && state.getMetaData().routingRequired(request.index(), request.type())) {
            throw new RoutingMissingException(request.index(), request.type(), request.id());
        }
    }

    @Override
    protected ExplainResponse shardOperation(ExplainRequest request, int shardId) throws ElasticsearchException {
        Term uidTerm;
        IndexService indexService = this.indicesService.indexService(request.index());
        IndexShard indexShard = indexService.shardSafe(shardId);
        Engine.GetResult result = indexShard.get(new Engine.Get(false, uidTerm = new Term("_uid", Uid.createUidAsBytes(request.type(), request.id()))));
        if (!result.exists()) {
            return new ExplainResponse(false);
        }
        DefaultSearchContext context = new DefaultSearchContext(0L, new ShardSearchRequest().types(new String[]{request.type()}).filteringAliases(request.filteringAlias()).nowInMillis(request.nowInMillis), null, result.searcher(), indexService, indexShard, this.scriptService, this.cacheRecycler, this.pageCacheRecycler, this.bigArrays);
        SearchContext.setCurrent(context);
        try {
            ((SearchContext)context).parsedQuery(indexService.queryParserService().parseQuery(request.source()));
            ((SearchContext)context).preProcess();
            int topLevelDocId = result.docIdAndVersion().docId + result.docIdAndVersion().context.docBase;
            Explanation explanation = ((SearchContext)context).searcher().explain(((SearchContext)context).query(), topLevelDocId);
            for (RescoreSearchContext ctx : ((SearchContext)context).rescore()) {
                Rescorer rescorer = ctx.rescorer();
                explanation = rescorer.explain(topLevelDocId, context, ctx, explanation);
            }
            if (request.fields() != null || request.fetchSourceContext() != null && request.fetchSourceContext().fetchSource()) {
                GetResult getResult = indexShard.getService().get(result, request.id(), request.type(), request.fields(), request.fetchSourceContext());
                ExplainResponse explainResponse = new ExplainResponse(true, explanation, getResult);
                return explainResponse;
            }
            ExplainResponse explainResponse = new ExplainResponse(true, explanation);
            return explainResponse;
        }
        catch (IOException e) {
            throw new ElasticsearchException("Could not explain", e);
        }
        finally {
            context.close();
            SearchContext.removeCurrent();
        }
    }

    @Override
    protected ExplainRequest newRequest() {
        return new ExplainRequest();
    }

    @Override
    protected ExplainResponse newResponse() {
        return new ExplainResponse();
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, ExplainRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.READ);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, ExplainRequest request) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.READ, request.index());
    }

    @Override
    protected ShardIterator shards(ClusterState state, ExplainRequest request) throws ElasticsearchException {
        return this.clusterService.operationRouting().getShards(this.clusterService.state(), request.index(), request.type(), request.id(), request.routing(), request.preference());
    }
}

