/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.delete.index;

import java.io.IOException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.delete.index.ShardDeleteResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class IndexDeleteResponse
extends ActionResponse {
    private String index;
    private int successfulShards;
    private int failedShards;
    private ShardDeleteResponse[] deleteResponses;

    IndexDeleteResponse(String index, int failedShards, ShardDeleteResponse[] deleteResponses) {
        this.index = index;
        this.successfulShards = deleteResponses.length;
        this.failedShards = failedShards;
        this.deleteResponses = deleteResponses;
    }

    IndexDeleteResponse() {
    }

    public String getIndex() {
        return this.index;
    }

    public int getTotalShards() {
        return this.failedShards + this.successfulShards;
    }

    public int getSuccessfulShards() {
        return this.successfulShards;
    }

    public int getFailedShards() {
        return this.failedShards;
    }

    public ShardDeleteResponse[] getResponses() {
        return this.deleteResponses;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.index = in.readString();
        this.successfulShards = in.readVInt();
        this.failedShards = in.readVInt();
        this.deleteResponses = new ShardDeleteResponse[in.readVInt()];
        for (int i = 0; i < this.deleteResponses.length; ++i) {
            this.deleteResponses[i] = new ShardDeleteResponse();
            this.deleteResponses[i].readFrom(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.index);
        out.writeVInt(this.successfulShards);
        out.writeVInt(this.failedShards);
        out.writeVInt(this.deleteResponses.length);
        for (ShardDeleteResponse deleteResponse : this.deleteResponses) {
            deleteResponse.writeTo(out);
        }
    }
}

