/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.IOException;
import java.util.Comparator;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.PostingsConsumer;
import org.apache.lucene.codecs.TermStats;
import org.apache.lucene.codecs.TermsConsumer;
import org.apache.lucene.codecs.simpletext.SimpleTextPostingsFormat;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;

class SimpleTextFieldsWriter
extends FieldsConsumer {
    private IndexOutput out;
    private final BytesRef scratch = new BytesRef(10);
    static final BytesRef END = new BytesRef("END");
    static final BytesRef FIELD = new BytesRef("field ");
    static final BytesRef TERM = new BytesRef("  term ");
    static final BytesRef DOC = new BytesRef("    doc ");
    static final BytesRef FREQ = new BytesRef("      freq ");
    static final BytesRef POS = new BytesRef("      pos ");
    static final BytesRef START_OFFSET = new BytesRef("      startOffset ");
    static final BytesRef END_OFFSET = new BytesRef("      endOffset ");
    static final BytesRef PAYLOAD = new BytesRef("        payload ");

    public SimpleTextFieldsWriter(SegmentWriteState state) throws IOException {
        String fileName = SimpleTextPostingsFormat.getPostingsFileName(state.segmentInfo.name, state.segmentSuffix);
        this.out = state.directory.createOutput(fileName, state.context);
    }

    private void write(String s) throws IOException {
        SimpleTextUtil.write(this.out, s, this.scratch);
    }

    private void write(BytesRef b) throws IOException {
        SimpleTextUtil.write(this.out, b);
    }

    private void newline() throws IOException {
        SimpleTextUtil.writeNewline(this.out);
    }

    @Override
    public TermsConsumer addField(FieldInfo field) throws IOException {
        this.write(FIELD);
        this.write(field.name);
        this.newline();
        return new SimpleTextTermsWriter(field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.out != null) {
            try {
                this.write(END);
                this.newline();
                SimpleTextUtil.writeChecksum(this.out, this.scratch);
            }
            finally {
                this.out.close();
                this.out = null;
            }
        }
    }

    private class SimpleTextPostingsWriter
    extends PostingsConsumer {
        private BytesRef term;
        private boolean wroteTerm;
        private final FieldInfo.IndexOptions indexOptions;
        private final boolean writePositions;
        private final boolean writeOffsets;
        private int lastStartOffset = 0;

        public SimpleTextPostingsWriter(FieldInfo field) {
            this.indexOptions = field.getIndexOptions();
            this.writePositions = this.indexOptions.compareTo(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
            this.writeOffsets = this.indexOptions.compareTo(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
        }

        @Override
        public void startDoc(int docID, int termDocFreq) throws IOException {
            if (!this.wroteTerm) {
                SimpleTextFieldsWriter.this.write(TERM);
                SimpleTextFieldsWriter.this.write(this.term);
                SimpleTextFieldsWriter.this.newline();
                this.wroteTerm = true;
            }
            SimpleTextFieldsWriter.this.write(DOC);
            SimpleTextFieldsWriter.this.write(Integer.toString(docID));
            SimpleTextFieldsWriter.this.newline();
            if (this.indexOptions != FieldInfo.IndexOptions.DOCS_ONLY) {
                SimpleTextFieldsWriter.this.write(FREQ);
                SimpleTextFieldsWriter.this.write(Integer.toString(termDocFreq));
                SimpleTextFieldsWriter.this.newline();
            }
            this.lastStartOffset = 0;
        }

        public PostingsConsumer reset(BytesRef term) {
            this.term = term;
            this.wroteTerm = false;
            return this;
        }

        @Override
        public void addPosition(int position, BytesRef payload, int startOffset, int endOffset) throws IOException {
            if (this.writePositions) {
                SimpleTextFieldsWriter.this.write(POS);
                SimpleTextFieldsWriter.this.write(Integer.toString(position));
                SimpleTextFieldsWriter.this.newline();
            }
            if (this.writeOffsets) {
                assert (endOffset >= startOffset);
                assert (startOffset >= this.lastStartOffset) : "startOffset=" + startOffset + " lastStartOffset=" + this.lastStartOffset;
                this.lastStartOffset = startOffset;
                SimpleTextFieldsWriter.this.write(START_OFFSET);
                SimpleTextFieldsWriter.this.write(Integer.toString(startOffset));
                SimpleTextFieldsWriter.this.newline();
                SimpleTextFieldsWriter.this.write(END_OFFSET);
                SimpleTextFieldsWriter.this.write(Integer.toString(endOffset));
                SimpleTextFieldsWriter.this.newline();
            }
            if (payload != null && payload.length > 0) {
                assert (payload.length != 0);
                SimpleTextFieldsWriter.this.write(PAYLOAD);
                SimpleTextFieldsWriter.this.write(payload);
                SimpleTextFieldsWriter.this.newline();
            }
        }

        @Override
        public void finishDoc() {
        }
    }

    private class SimpleTextTermsWriter
    extends TermsConsumer {
        private final SimpleTextPostingsWriter postingsWriter;

        public SimpleTextTermsWriter(FieldInfo field) {
            this.postingsWriter = new SimpleTextPostingsWriter(field);
        }

        @Override
        public PostingsConsumer startTerm(BytesRef term) throws IOException {
            return this.postingsWriter.reset(term);
        }

        @Override
        public void finishTerm(BytesRef term, TermStats stats) throws IOException {
        }

        @Override
        public void finish(long sumTotalTermFreq, long sumDocFreq, int docCount) throws IOException {
        }

        @Override
        public Comparator<BytesRef> getComparator() {
            return BytesRef.getUTF8SortedAsUnicodeComparator();
        }
    }
}

