/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.insight.elasticsearch.indices;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.admin.cluster.repositories.put.PutRepositoryRequest;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.delete.DeleteSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsRequest;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsResponse;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.close.CloseIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.optimize.OptimizeRequest;
import org.elasticsearch.client.AdminClient;
import org.elasticsearch.client.ClusterAdminClient;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.RepositoriesMetaData;
import org.elasticsearch.cluster.metadata.RepositoryMetaData;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.hppc.cursors.ObjectObjectCursor;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Injector;
import org.elasticsearch.common.joda.time.Days;
import org.elasticsearch.common.joda.time.LocalDate;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.threadpool.ThreadPool;

public class IndicesManagementService
extends AbstractLifecycleComponent<IndicesManagementService> {
    protected final ThreadPool threadPool;
    protected final Injector injector;
    protected ScheduledFuture<?> future;

    @Inject
    public IndicesManagementService(Settings settings, ThreadPool threadPool, Injector injector) {
        super(settings);
        this.threadPool = threadPool;
        this.injector = injector;
    }

    @Override
    protected void doStart() throws ElasticsearchException {
        TimeValue interval = TimeValue.parseTimeValue(this.settings.get("initial"), TimeValue.timeValueHours(1L));
        this.future = this.threadPool.schedule(interval, "generic", new Task());
    }

    @Override
    protected void doStop() throws ElasticsearchException {
        if (this.future != null) {
            this.future.cancel(false);
        }
    }

    @Override
    protected void doClose() throws ElasticsearchException {
        if (this.future != null) {
            this.future.cancel(true);
        }
    }

    class Task
    implements Runnable {
        Task() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean reschedule = true;
            try {
                String[] indices;
                Settings settings = IndicesManagementService.this.settings.getByPrefix("insight.indices.management.");
                Set<String> repositories = settings.getByPrefix("repository.").getAsStructuredMap().keySet();
                int opened = settings.getAsInt("opened", (Integer)7);
                int closed = settings.getAsInt("closed", (Integer)14);
                int stored = settings.getAsInt("stored", (Integer)0);
                HashSet<String> toOptimize = new HashSet<String>();
                HashSet<String> toStore = new HashSet<String>();
                HashSet<String> toClose = new HashSet<String>();
                HashSet<String> toDelete = new HashSet<String>();
                AdminClient adminClient = IndicesManagementService.this.injector.getInstance(AdminClient.class);
                ClusterAdminClient clusterAdminClient = adminClient.cluster();
                IndicesAdminClient indicesAdminClient = adminClient.indices();
                ClusterStateResponse state = clusterAdminClient.state((ClusterStateRequest)clusterAdminClient.prepareState().request()).actionGet();
                String masterNodeId = state.getState().nodes().masterNodeId();
                String localNodeId = state.getState().nodes().getLocalNodeId();
                if (localNodeId == null || !localNodeId.equals(masterNodeId)) {
                    return;
                }
                LocalDate now = new LocalDate();
                Pattern pattern = Pattern.compile(".*-([0-9]{4})\\.([0-9]{2})\\.([0-9]{2})");
                for (ObjectObjectCursor<String, IndexMetaData> objectObjectCursor : state.getState().metaData().indices()) {
                    String index = ((IndexMetaData)objectObjectCursor.value).getIndex();
                    Matcher matcher = pattern.matcher(index);
                    if (matcher.find()) {
                        LocalDate date = new LocalDate(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)));
                        int days = Days.daysBetween(date, now).getDays();
                        if (days <= 0) continue;
                        toOptimize.add(index);
                        if (stored < 0 || days <= stored) {
                            toStore.add(index);
                        }
                        if (opened < 0 || days <= opened) continue;
                        if (closed < 0 || days <= closed) {
                            toClose.add(index);
                            continue;
                        }
                        toDelete.add(index);
                        continue;
                    }
                    IndicesManagementService.this.logger.warn("Index name {} does not match the supported pattern", new Object[0]);
                }
                if (!toOptimize.isEmpty()) {
                    IndicesManagementService.this.logger.info("Optimizing indices " + toOptimize, new Object[0]);
                    indices = toOptimize.toArray(new String[toOptimize.size()]);
                    OptimizeRequest optimizeRequest = (OptimizeRequest)indicesAdminClient.prepareOptimize(indices).setMaxNumSegments(1).request();
                    indicesAdminClient.optimize(optimizeRequest).actionGet();
                }
                if (!toStore.isEmpty()) {
                    if (repositories.isEmpty()) {
                        IndicesManagementService.this.logger.error("No repository defined for storing indices", new Object[0]);
                        return;
                    }
                    RepositoriesMetaData repositoriesMetaData = (RepositoriesMetaData)state.getState().getMetaData().getCustoms().get("repositories");
                    IndicesManagementService.this.logger.info("Storing indices " + toStore, new Object[0]);
                    for (String repository : repositories) {
                        RepositoryMetaData repositoryMetaData = null;
                        for (RepositoryMetaData rmd : repositoriesMetaData.repositories()) {
                            if (!repository.equals(rmd.name())) continue;
                            repositoryMetaData = rmd;
                            break;
                        }
                        Settings repoSettings = settings.getByPrefix("repository." + repository + ".");
                        String type = repoSettings.get("type");
                        Settings set = repoSettings.getByPrefix("settings.");
                        if (type != null && set != null) {
                            if (repositoryMetaData == null || !type.equals(repositoryMetaData.type()) || !set.getAsMap().equals(repositoryMetaData.settings().getAsMap())) {
                                IndicesManagementService.this.logger.info("Updating repository definition for " + repository, new Object[0]);
                                PutRepositoryRequest req2 = (PutRepositoryRequest)clusterAdminClient.preparePutRepository(repository).setType(type).setSettings(repoSettings.getByPrefix("settings.")).request();
                                clusterAdminClient.putRepository(req2).actionGet();
                            }
                        } else if (repositoryMetaData == null) {
                            IndicesManagementService.this.logger.warn("Repository " + repository + " is not defined", new Object[0]);
                            continue;
                        }
                        GetSnapshotsResponse snapshots = clusterAdminClient.getSnapshots((GetSnapshotsRequest)clusterAdminClient.prepareGetSnapshots(repository).request()).actionGet();
                        HashMap<String, SnapshotInfo> infos = new HashMap<String, SnapshotInfo>();
                        for (SnapshotInfo info : snapshots.getSnapshots()) {
                            infos.put(info.name(), info);
                        }
                        for (String index : toStore) {
                            SnapshotInfo info = (SnapshotInfo)infos.get(index);
                            if (info != null) {
                                if (info.endTime() == 0L) continue;
                                if (info.failedShards() > 0) {
                                    DeleteSnapshotRequest req3 = (DeleteSnapshotRequest)clusterAdminClient.prepareDeleteSnapshot(repository, index).request();
                                    clusterAdminClient.deleteSnapshot(req3).actionGet();
                                    info = null;
                                }
                            }
                            if (info != null) continue;
                            CreateSnapshotRequest req = (CreateSnapshotRequest)clusterAdminClient.prepareCreateSnapshot(repository, index).setIncludeGlobalState(false).setIndices(index).setWaitForCompletion(true).request();
                            clusterAdminClient.createSnapshot(req).actionGet();
                        }
                    }
                }
                if (!toClose.isEmpty()) {
                    IndicesManagementService.this.logger.info("Closing indices " + toClose, new Object[0]);
                    indices = toClose.toArray(new String[toClose.size()]);
                    CloseIndexRequest closeIndexRequest = (CloseIndexRequest)indicesAdminClient.prepareClose(indices).request();
                    indicesAdminClient.close(closeIndexRequest).actionGet();
                }
                if (!toDelete.isEmpty()) {
                    IndicesManagementService.this.logger.info("Deleting indices " + toDelete, new Object[0]);
                    indices = toDelete.toArray(new String[toDelete.size()]);
                    DeleteIndexRequest deleteIndexRequest = (DeleteIndexRequest)indicesAdminClient.prepareDelete(indices).request();
                    indicesAdminClient.delete(deleteIndexRequest).actionGet();
                }
            }
            catch (ElasticsearchException e) {
                if (e.getCause() instanceof InterruptedException) {
                    reschedule = true;
                } else {
                    IndicesManagementService.this.logger.error("Error performing indices management", e, new Object[0]);
                }
            }
            finally {
                if (reschedule) {
                    TimeValue interval = TimeValue.parseTimeValue(IndicesManagementService.this.settings.get("interval"), TimeValue.timeValueHours(8L));
                    IndicesManagementService.this.future = IndicesManagementService.this.threadPool.schedule(interval, "generic", this);
                }
            }
        }
    }
}

