/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.lookup;

import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;
import org.elasticsearch.search.lookup.IndexFieldTerm;
import org.elasticsearch.search.lookup.PositionIterator;
import org.elasticsearch.search.lookup.TermPosition;

public class CachedPositionIterator
extends PositionIterator {
    final BytesRef payloads = new BytesRef();
    final IntsRef payloadsLengths = new IntsRef(0);
    final IntsRef payloadsStarts = new IntsRef(0);
    final IntsRef positions = new IntsRef(0);
    final IntsRef startOffsets = new IntsRef(0);
    final IntsRef endOffsets = new IntsRef(0);

    public CachedPositionIterator(IndexFieldTerm indexFieldTerm) {
        super(indexFieldTerm);
    }

    @Override
    public Iterator<TermPosition> reset() {
        return new Iterator<TermPosition>(){
            private int pos = 0;
            private final TermPosition termPosition = new TermPosition();

            @Override
            public boolean hasNext() {
                return this.pos < CachedPositionIterator.this.freq;
            }

            @Override
            public TermPosition next() {
                this.termPosition.position = CachedPositionIterator.this.positions.ints[this.pos];
                this.termPosition.startOffset = CachedPositionIterator.this.startOffsets.ints[this.pos];
                this.termPosition.endOffset = CachedPositionIterator.this.endOffsets.ints[this.pos];
                this.termPosition.payload = CachedPositionIterator.this.payloads;
                CachedPositionIterator.this.payloads.offset = CachedPositionIterator.this.payloadsStarts.ints[this.pos];
                CachedPositionIterator.this.payloads.length = CachedPositionIterator.this.payloadsLengths.ints[this.pos];
                ++this.pos;
                return this.termPosition;
            }

            @Override
            public void remove() {
            }
        };
    }

    private void record() throws IOException {
        for (int i = 0; i < this.freq; ++i) {
            TermPosition termPosition = super.next();
            this.positions.ints[i] = termPosition.position;
            this.addPayload(i, termPosition.payload);
            this.startOffsets.ints[i] = termPosition.startOffset;
            this.endOffsets.ints[i] = termPosition.endOffset;
        }
    }

    private void ensureSize(int freq) {
        if (freq == 0) {
            return;
        }
        if (this.startOffsets.ints.length < freq) {
            this.startOffsets.grow(freq);
            this.endOffsets.grow(freq);
            this.positions.grow(freq);
            this.payloadsLengths.grow(freq);
            this.payloadsStarts.grow(freq);
        }
        this.payloads.offset = 0;
        this.payloadsLengths.offset = 0;
        this.payloadsStarts.offset = 0;
        this.payloads.grow(freq * 8);
    }

    private void addPayload(int i, BytesRef currPayload) {
        if (currPayload != null) {
            this.payloadsLengths.ints[i] = currPayload.length;
            int n = this.payloadsStarts.ints[i] = i == 0 ? 0 : this.payloadsStarts.ints[i - 1] + this.payloadsLengths.ints[i - 1];
            if (this.payloads.bytes.length < this.payloadsStarts.ints[i] + this.payloadsLengths.ints[i]) {
                this.payloads.offset = 0;
                this.payloads.grow(this.payloads.bytes.length * 2);
            }
            System.arraycopy(currPayload.bytes, currPayload.offset, this.payloads.bytes, this.payloadsStarts.ints[i], currPayload.length);
        } else {
            this.payloadsLengths.ints[i] = 0;
            this.payloadsStarts.ints[i] = i == 0 ? 0 : this.payloadsStarts.ints[i - 1] + this.payloadsLengths.ints[i - 1];
        }
    }

    @Override
    public void nextDoc() throws IOException {
        super.nextDoc();
        this.ensureSize(this.freq);
        this.record();
    }

    @Override
    public TermPosition next() {
        throw new UnsupportedOperationException();
    }
}

