/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.highlight.vectorhighlight;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.document.XStringField;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.vectorhighlight.BoundaryScanner;
import org.apache.lucene.search.vectorhighlight.FieldFragList;
import org.apache.lucene.search.vectorhighlight.ScoreOrderFragmentsBuilder;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.search.highlight.vectorhighlight.FragmentBuilderHelper;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.lookup.SearchLookup;

public class SourceScoreOrderFragmentsBuilder
extends ScoreOrderFragmentsBuilder {
    private final FieldMapper<?> mapper;
    private final SearchContext searchContext;

    public SourceScoreOrderFragmentsBuilder(FieldMapper<?> mapper, SearchContext searchContext, String[] preTags, String[] postTags, BoundaryScanner boundaryScanner) {
        super(preTags, postTags, boundaryScanner);
        this.mapper = mapper;
        this.searchContext = searchContext;
    }

    @Override
    protected Field[] getFields(IndexReader reader, int docId, String fieldName) throws IOException {
        SearchLookup lookup = this.searchContext.lookup();
        lookup.setNextReader((AtomicReaderContext)reader.getContext());
        lookup.setNextDocId(docId);
        List<Object> values = lookup.source().extractRawValues(this.mapper.names().sourcePath());
        Field[] fields = new Field[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            fields[i] = new XStringField(this.mapper.names().indexName(), values.get(i).toString(), TextField.TYPE_NOT_STORED);
        }
        return fields;
    }

    @Override
    protected String makeFragment(StringBuilder buffer, int[] index, Field[] values, FieldFragList.WeightedFragInfo fragInfo, String[] preTags, String[] postTags, Encoder encoder) {
        return super.makeFragment(buffer, index, values, FragmentBuilderHelper.fixWeightedFragInfo(this.mapper, values, fragInfo), preTags, postTags, encoder);
    }
}

