/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.terms.InternalOrder;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.UnmappedTerms;
import org.elasticsearch.search.aggregations.bucket.terms.support.BucketPriorityQueue;

public abstract class InternalTerms
extends InternalAggregation
implements Terms,
ToXContent,
Streamable {
    protected InternalOrder order;
    protected int requiredSize;
    protected long minDocCount;
    protected Collection<Bucket> buckets;
    protected Map<String, Bucket> bucketMap;

    protected InternalTerms() {
    }

    protected InternalTerms(String name, InternalOrder order, int requiredSize, long minDocCount, Collection<Bucket> buckets) {
        super(name);
        this.order = order;
        this.requiredSize = requiredSize;
        this.minDocCount = minDocCount;
        this.buckets = buckets;
    }

    @Override
    public Collection<Terms.Bucket> getBuckets() {
        Collection<Terms.Bucket> o = this.buckets;
        return o;
    }

    @Override
    public Terms.Bucket getBucketByKey(String term) {
        if (this.bucketMap == null) {
            this.bucketMap = Maps.newHashMapWithExpectedSize(this.buckets.size());
            for (Bucket bucket : this.buckets) {
                this.bucketMap.put(bucket.getKey(), bucket);
            }
        }
        return this.bucketMap.get(term);
    }

    @Override
    public InternalTerms reduce(InternalAggregation.ReduceContext reduceContext) {
        List<InternalAggregation> aggregations = reduceContext.aggregations();
        if (aggregations.size() == 1) {
            InternalTerms terms = (InternalTerms)aggregations.get(0);
            terms.trimExcessEntries(reduceContext.bigArrays());
            return terms;
        }
        InternalTerms reduced = null;
        HashMap<Text, ArrayList<Bucket>> buckets = null;
        for (InternalAggregation aggregation : aggregations) {
            InternalTerms terms = (InternalTerms)aggregation;
            if (terms instanceof UnmappedTerms) continue;
            if (reduced == null) {
                reduced = terms;
            }
            if (buckets == null) {
                buckets = new HashMap<Text, ArrayList<Bucket>>(terms.buckets.size());
            }
            for (Bucket bucket : terms.buckets) {
                ArrayList<Bucket> existingBuckets = (ArrayList<Bucket>)buckets.get(bucket.getKeyAsText());
                if (existingBuckets == null) {
                    existingBuckets = new ArrayList<Bucket>(aggregations.size());
                    buckets.put(bucket.getKeyAsText(), existingBuckets);
                }
                existingBuckets.add(bucket);
            }
        }
        if (reduced == null) {
            return (UnmappedTerms)aggregations.get(0);
        }
        int size = Math.min(this.requiredSize, buckets.size());
        BucketPriorityQueue ordered = new BucketPriorityQueue(size, this.order.comparator(null));
        for (Map.Entry entry : buckets.entrySet()) {
            List sameTermBuckets = (List)entry.getValue();
            Bucket b = ((Bucket)sameTermBuckets.get(0)).reduce(sameTermBuckets, reduceContext.bigArrays());
            if (b.docCount < this.minDocCount) continue;
            ordered.insertWithOverflow(b);
        }
        Bucket[] list = new Bucket[ordered.size()];
        for (int i = ordered.size() - 1; i >= 0; --i) {
            list[i] = (Bucket)ordered.pop();
        }
        reduced.buckets = Arrays.asList(list);
        return reduced;
    }

    final void trimExcessEntries(BigArrays bigArrays) {
        ArrayList<Bucket> newBuckets = Lists.newArrayList();
        for (Bucket b : this.buckets) {
            if (newBuckets.size() >= this.requiredSize) break;
            if (b.docCount < this.minDocCount) continue;
            newBuckets.add(b);
            b.aggregations.reduce(bigArrays);
        }
        this.buckets = newBuckets;
    }

    public static abstract class Bucket
    extends Terms.Bucket {
        long bucketOrd;
        protected long docCount;
        protected InternalAggregations aggregations;

        protected Bucket(long docCount, InternalAggregations aggregations) {
            this.docCount = docCount;
            this.aggregations = aggregations;
        }

        @Override
        public long getDocCount() {
            return this.docCount;
        }

        @Override
        public Aggregations getAggregations() {
            return this.aggregations;
        }

        public Bucket reduce(List<? extends Bucket> buckets, BigArrays bigArrays) {
            if (buckets.size() == 1) {
                Bucket bucket = buckets.get(0);
                bucket.aggregations.reduce(bigArrays);
                return bucket;
            }
            Bucket reduced = null;
            ArrayList<InternalAggregations> aggregationsList = new ArrayList<InternalAggregations>(buckets.size());
            for (Bucket bucket : buckets) {
                if (reduced == null) {
                    reduced = bucket;
                } else {
                    reduced.docCount += bucket.docCount;
                }
                aggregationsList.add(bucket.aggregations);
            }
            reduced.aggregations = InternalAggregations.reduce(aggregationsList, bigArrays);
            return reduced;
        }
    }
}

