/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.termvector;

import org.elasticsearch.action.termvector.MultiTermVectorsRequest;
import org.elasticsearch.action.termvector.MultiTermVectorsResponse;
import org.elasticsearch.action.termvector.TermVectorRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestToXContentListener;
import org.elasticsearch.rest.action.termvector.RestTermVectorAction;

public class RestMultiTermVectorsAction
extends BaseRestHandler {
    @Inject
    public RestMultiTermVectorsAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.GET, "/_mtermvectors", this);
        controller.registerHandler(RestRequest.Method.POST, "/_mtermvectors", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_mtermvectors", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_mtermvectors", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_mtermvectors", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_mtermvectors", this);
    }

    @Override
    public void handleRequest(RestRequest request, RestChannel channel) throws Exception {
        MultiTermVectorsRequest multiTermVectorsRequest = new MultiTermVectorsRequest();
        multiTermVectorsRequest.listenerThreaded(false);
        TermVectorRequest template = new TermVectorRequest();
        template.index(request.param("index"));
        template.type(request.param("type"));
        RestTermVectorAction.readURIParameters(template, request);
        multiTermVectorsRequest.ids(Strings.commaDelimitedListToStringArray(request.param("ids")));
        multiTermVectorsRequest.add(template, RestActions.getRestContent(request));
        this.client.multiTermVectors(multiTermVectorsRequest, new RestToXContentListener<MultiTermVectorsResponse>(channel));
    }
}

