/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.cat;

import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Table;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.joda.time.format.DateTimeFormat;
import org.elasticsearch.common.joda.time.format.DateTimeFormatter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.action.cat.AbstractCatAction;
import org.elasticsearch.rest.action.support.RestResponseListener;
import org.elasticsearch.rest.action.support.RestTable;

public class RestHealthAction
extends AbstractCatAction {
    private DateTimeFormatter dateFormat = DateTimeFormat.forPattern("HH:mm:ss");

    @Inject
    public RestHealthAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.GET, "/_cat/health", this);
    }

    @Override
    void documentation(StringBuilder sb) {
        sb.append("/_cat/health\n");
    }

    @Override
    public void doRequest(final RestRequest request, RestChannel channel) {
        ClusterHealthRequest clusterHealthRequest = new ClusterHealthRequest(new String[0]);
        this.client.admin().cluster().health(clusterHealthRequest, (ActionListener<ClusterHealthResponse>)new RestResponseListener<ClusterHealthResponse>(channel){

            @Override
            public RestResponse buildResponse(ClusterHealthResponse health) throws Exception {
                return RestTable.buildResponse(RestHealthAction.this.buildTable(health, request), this.channel);
            }
        });
    }

    @Override
    Table getTableWithHeader(RestRequest request) {
        Table t = new Table();
        t.startHeaders();
        t.addCell("epoch", "alias:t,time;desc:seconds since 1970-01-01 00:00:00");
        t.addCell("timestamp", "alias:ts,hms,hhmmss;desc:time in HH:MM:SS");
        t.addCell("cluster", "alias:cl;desc:cluster name");
        t.addCell("status", "alias:st;desc:health status");
        t.addCell("node.total", "alias:nt,nodeTotal;text-align:right;desc:total number of nodes");
        t.addCell("node.data", "alias:nd,nodeData;text-align:right;desc:number of nodes that can store data");
        t.addCell("shards", "alias:t,sh,shards.total,shardsTotal;text-align:right;desc:total number of shards");
        t.addCell("pri", "alias:p,shards.primary,shardsPrimary;text-align:right;desc:number of primary shards");
        t.addCell("relo", "alias:r,shards.relocating,shardsRelocating;text-align:right;desc:number of relocating nodes");
        t.addCell("init", "alias:i,shards.initializing,shardsInitializing;text-align:right;desc:number of initializing nodes");
        t.addCell("unassign", "alias:u,shards.unassigned,shardsUnassigned;text-align:right;desc:number of unassigned shards");
        t.endHeaders();
        return t;
    }

    private Table buildTable(ClusterHealthResponse health, RestRequest request) {
        long time = System.currentTimeMillis();
        Table t = this.getTableWithHeader(request);
        t.startRow();
        t.addCell(TimeUnit.SECONDS.convert(time, TimeUnit.MILLISECONDS));
        t.addCell(this.dateFormat.print(time));
        t.addCell(health.getClusterName());
        t.addCell(health.getStatus().name().toLowerCase(Locale.ROOT));
        t.addCell(health.getNumberOfNodes());
        t.addCell(health.getNumberOfDataNodes());
        t.addCell(health.getActiveShards());
        t.addCell(health.getActivePrimaryShards());
        t.addCell(health.getRelocatingShards());
        t.addCell(health.getInitializingShards());
        t.addCell(health.getUnassignedShards());
        t.endRow();
        return t;
    }
}

