/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.pojo;

import io.fabric8.common.util.JMXUtils;
import io.fabric8.insight.elasticsearch.ElasticRest;
import io.fabric8.insight.elasticsearch.impl.ElasticSearchServlet;
import io.fabric8.insight.elasticsearch.impl.ElasticStorageImpl;
import io.fabric8.insight.metrics.model.MetricsStorageService;
import io.fabric8.insight.metrics.model.QueryResult;
import io.fabric8.insight.storage.StorageService;
import java.io.IOException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.internal.InternalNode;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ExtendedInternalNode
implements Node,
ElasticRest,
StorageService,
MetricsStorageService {
    private final BundleContext bundleContext;
    private final ServiceTracker<HttpService, HttpService> httpServiceTracker;
    private final ServiceTracker<MBeanServer, MBeanServer> mbeanServerTracker;
    private final InternalNode node;
    private final io.fabric8.insight.elasticsearch.impl.ElasticRest rest;
    private final ElasticStorageImpl storage;
    private final ElasticSearchServlet servlet;
    private static ObjectName OBJECT_NAME;

    public ExtendedInternalNode(final BundleContext bundleContext, InternalNode node) {
        this.bundleContext = bundleContext;
        this.httpServiceTracker = new ServiceTracker(bundleContext, HttpService.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<HttpService, HttpService>(){

            public HttpService addingService(ServiceReference<HttpService> reference) {
                HttpService service = (HttpService)ExtendedInternalNode.this.bundleContext.getService(reference);
                try {
                    service.registerServlet("/elasticsearch", (Servlet)ExtendedInternalNode.this.servlet, null, null);
                }
                catch (ServletException e) {
                    e.printStackTrace();
                }
                catch (NamespaceException e) {
                    e.printStackTrace();
                }
                return service;
            }

            public void modifiedService(ServiceReference<HttpService> reference, HttpService service) {
            }

            public void removedService(ServiceReference<HttpService> reference, HttpService service) {
                service.unregister("/elasticsearch");
            }
        });
        this.mbeanServerTracker = new ServiceTracker(bundleContext, MBeanServer.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<MBeanServer, MBeanServer>(){

            public MBeanServer addingService(ServiceReference<MBeanServer> reference) {
                MBeanServer mBeanServer = (MBeanServer)bundleContext.getService(reference);
                try {
                    JMXUtils.registerMBean((Object)ExtendedInternalNode.this.rest, (MBeanServer)mBeanServer, (ObjectName)OBJECT_NAME);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return mBeanServer;
            }

            public void modifiedService(ServiceReference<MBeanServer> reference, MBeanServer service) {
            }

            public void removedService(ServiceReference<MBeanServer> reference, MBeanServer service) {
                try {
                    JMXUtils.unregisterMBean((MBeanServer)service, (ObjectName)OBJECT_NAME);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.node = node;
        this.rest = new io.fabric8.insight.elasticsearch.impl.ElasticRest(node);
        this.storage = new ElasticStorageImpl(node);
        this.servlet = new ElasticSearchServlet(this);
    }

    @Override
    public Node start() {
        Node n = this.node.start();
        this.storage.init();
        this.httpServiceTracker.open();
        this.mbeanServerTracker.open();
        return n;
    }

    @Override
    public Node stop() {
        this.mbeanServerTracker.close();
        this.httpServiceTracker.close();
        this.storage.destroy();
        return this.node.stop();
    }

    @Override
    public void close() {
        this.stop();
        this.node.close();
    }

    @Override
    public Settings settings() {
        return this.node.settings();
    }

    @Override
    public Client client() {
        return this.node.client();
    }

    @Override
    public boolean isClosed() {
        return this.node.isClosed();
    }

    @Override
    public String get(String uri) throws IOException {
        return this.rest.get(uri);
    }

    @Override
    public String post(String uri, String content) throws IOException {
        return this.rest.post(uri, content);
    }

    @Override
    public String put(String uri, String content) throws IOException {
        return this.rest.put(uri, content);
    }

    @Override
    public String delete(String uri) throws IOException {
        return this.rest.delete(uri);
    }

    @Override
    public String head(String uri) throws IOException {
        return this.rest.head(uri);
    }

    public void store(String type, long timestamp, String jsonData) {
        this.storage.store(type, timestamp, jsonData);
    }

    public void store(String type, long timestamp, QueryResult queryResult) {
        this.storage.store(type, timestamp, queryResult);
    }

    static {
        try {
            OBJECT_NAME = new ObjectName("org.elasticsearch:service=restjmx");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
    }
}

