/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.FlushNotAllowedEngineException;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.IllegalIndexShardStateException;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.threadpool.ThreadPool;

public class TranslogService
extends AbstractIndexShardComponent {
    private static final String FLUSH_THRESHOLD_OPS_KEY = "flush_threshold_ops";
    private static final String FLUSH_THRESHOLD_SIZE_KEY = "flush_threshold_size";
    private static final String FLUSH_THRESHOLD_PERIOD_KEY = "flush_threshold_period";
    private static final String FLUSH_THRESHOLD_DISABLE_FLUSH_KEY = "disable_flush";
    private static final String FLUSH_THRESHOLD_INTERVAL_KEY = "interval";
    public static final String INDEX_TRANSLOG_FLUSH_INTERVAL = "index.translog.interval";
    public static final String INDEX_TRANSLOG_FLUSH_THRESHOLD_OPS = "index.translog.flush_threshold_ops";
    public static final String INDEX_TRANSLOG_FLUSH_THRESHOLD_SIZE = "index.translog.flush_threshold_size";
    public static final String INDEX_TRANSLOG_FLUSH_THRESHOLD_PERIOD = "index.translog.flush_threshold_period";
    public static final String INDEX_TRANSLOG_DISABLE_FLUSH = "index.translog.disable_flush";
    private final ThreadPool threadPool;
    private final IndexSettingsService indexSettingsService;
    private final IndexShard indexShard;
    private final Translog translog;
    private volatile TimeValue interval;
    private volatile int flushThresholdOperations;
    private volatile ByteSizeValue flushThresholdSize;
    private volatile TimeValue flushThresholdPeriod;
    private volatile boolean disableFlush;
    private volatile ScheduledFuture future;
    private final ApplySettings applySettings = new ApplySettings();

    @Inject
    public TranslogService(ShardId shardId, @IndexSettings Settings indexSettings, IndexSettingsService indexSettingsService, ThreadPool threadPool, IndexShard indexShard, Translog translog) {
        super(shardId, indexSettings);
        this.threadPool = threadPool;
        this.indexSettingsService = indexSettingsService;
        this.indexShard = indexShard;
        this.translog = translog;
        this.flushThresholdOperations = this.componentSettings.getAsInt(FLUSH_THRESHOLD_OPS_KEY, this.componentSettings.getAsInt("flush_threshold", (Integer)5000));
        this.flushThresholdSize = this.componentSettings.getAsBytesSize(FLUSH_THRESHOLD_SIZE_KEY, new ByteSizeValue(200L, ByteSizeUnit.MB));
        this.flushThresholdPeriod = this.componentSettings.getAsTime(FLUSH_THRESHOLD_PERIOD_KEY, TimeValue.timeValueMinutes(30L));
        this.interval = this.componentSettings.getAsTime(FLUSH_THRESHOLD_INTERVAL_KEY, TimeValue.timeValueMillis(5000L));
        this.disableFlush = this.componentSettings.getAsBoolean(FLUSH_THRESHOLD_DISABLE_FLUSH_KEY, (Boolean)false);
        this.logger.debug("interval [{}], flush_threshold_ops [{}], flush_threshold_size [{}], flush_threshold_period [{}]", this.interval, this.flushThresholdOperations, this.flushThresholdSize, this.flushThresholdPeriod);
        this.future = threadPool.schedule(this.interval, "same", new TranslogBasedFlush());
        indexSettingsService.addListener(this.applySettings);
    }

    public void close() {
        this.indexSettingsService.removeListener(this.applySettings);
        this.future.cancel(true);
    }

    private TimeValue computeNextInterval() {
        return new TimeValue(this.interval.millis() + ThreadLocalRandom.current().nextLong(this.interval.millis()));
    }

    private class TranslogBasedFlush
    implements Runnable {
        private volatile long lastFlushTime = System.currentTimeMillis();

        private TranslogBasedFlush() {
        }

        @Override
        public void run() {
            long sizeInBytes;
            if (TranslogService.this.indexShard.state() == IndexShardState.CLOSED) {
                return;
            }
            if (TranslogService.this.disableFlush) {
                this.reschedule();
                return;
            }
            if (TranslogService.this.indexShard.state() == IndexShardState.CREATED) {
                this.reschedule();
                return;
            }
            int currentNumberOfOperations = TranslogService.this.translog.estimatedNumberOfOperations();
            if (currentNumberOfOperations == 0) {
                this.reschedule();
                return;
            }
            if (TranslogService.this.flushThresholdOperations > 0 && currentNumberOfOperations > TranslogService.this.flushThresholdOperations) {
                TranslogService.this.logger.trace("flushing translog, operations [{}], breached [{}]", currentNumberOfOperations, TranslogService.this.flushThresholdOperations);
                this.asyncFlushAndReschedule();
                return;
            }
            if (TranslogService.this.flushThresholdSize.bytes() > 0L && (sizeInBytes = TranslogService.this.translog.translogSizeInBytes()) > TranslogService.this.flushThresholdSize.bytes()) {
                TranslogService.this.logger.trace("flushing translog, size [{}], breached [{}]", new ByteSizeValue(sizeInBytes), TranslogService.this.flushThresholdSize);
                this.asyncFlushAndReschedule();
                return;
            }
            if (TranslogService.this.flushThresholdPeriod.millis() > 0L && TranslogService.this.threadPool.estimatedTimeInMillis() - this.lastFlushTime > TranslogService.this.flushThresholdPeriod.millis()) {
                TranslogService.this.logger.trace("flushing translog, last_flush_time [{}], breached [{}]", this.lastFlushTime, TranslogService.this.flushThresholdPeriod);
                this.asyncFlushAndReschedule();
                return;
            }
            this.reschedule();
        }

        private void reschedule() {
            TranslogService.this.future = TranslogService.this.threadPool.schedule(TranslogService.this.computeNextInterval(), "same", this);
        }

        private void asyncFlushAndReschedule() {
            TranslogService.this.threadPool.executor("flush").execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        TranslogService.this.indexShard.flush(new Engine.Flush());
                    }
                    catch (IllegalIndexShardStateException e) {
                    }
                    catch (FlushNotAllowedEngineException e) {
                    }
                    catch (Throwable e) {
                        TranslogService.this.logger.warn("failed to flush shard on translog threshold", e, new Object[0]);
                    }
                    TranslogBasedFlush.this.lastFlushTime = TranslogService.this.threadPool.estimatedTimeInMillis();
                    if (TranslogService.this.indexShard.state() != IndexShardState.CLOSED) {
                        TranslogService.this.future = TranslogService.this.threadPool.schedule(TranslogService.this.computeNextInterval(), "same", TranslogBasedFlush.this);
                    }
                }
            });
        }
    }

    class ApplySettings
    implements IndexSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            boolean disableFlush;
            TimeValue interval;
            TimeValue flushThresholdPeriod;
            ByteSizeValue flushThresholdSize;
            int flushThresholdOperations = settings.getAsInt(TranslogService.INDEX_TRANSLOG_FLUSH_THRESHOLD_OPS, (Integer)TranslogService.this.flushThresholdOperations);
            if (flushThresholdOperations != TranslogService.this.flushThresholdOperations) {
                TranslogService.this.logger.info("updating flush_threshold_ops from [{}] to [{}]", TranslogService.this.flushThresholdOperations, flushThresholdOperations);
                TranslogService.this.flushThresholdOperations = flushThresholdOperations;
            }
            if (!(flushThresholdSize = settings.getAsBytesSize(TranslogService.INDEX_TRANSLOG_FLUSH_THRESHOLD_SIZE, TranslogService.this.flushThresholdSize)).equals(TranslogService.this.flushThresholdSize)) {
                TranslogService.this.logger.info("updating flush_threshold_size from [{}] to [{}]", TranslogService.this.flushThresholdSize, flushThresholdSize);
                TranslogService.this.flushThresholdSize = flushThresholdSize;
            }
            if (!(flushThresholdPeriod = settings.getAsTime(TranslogService.INDEX_TRANSLOG_FLUSH_THRESHOLD_PERIOD, TranslogService.this.flushThresholdPeriod)).equals(TranslogService.this.flushThresholdPeriod)) {
                TranslogService.this.logger.info("updating flush_threshold_period from [{}] to [{}]", TranslogService.this.flushThresholdPeriod, flushThresholdPeriod);
                TranslogService.this.flushThresholdPeriod = flushThresholdPeriod;
            }
            if (!(interval = settings.getAsTime(TranslogService.INDEX_TRANSLOG_FLUSH_INTERVAL, TranslogService.this.interval)).equals(TranslogService.this.interval)) {
                TranslogService.this.logger.info("updating interval from [{}] to [{}]", TranslogService.this.interval, interval);
                TranslogService.this.interval = interval;
            }
            if ((disableFlush = settings.getAsBoolean(TranslogService.INDEX_TRANSLOG_DISABLE_FLUSH, (Boolean)TranslogService.this.disableFlush).booleanValue()) != TranslogService.this.disableFlush) {
                TranslogService.this.logger.info("updating disable_flush from [{}] to [{}]", TranslogService.this.disableFlush, disableFlush);
                TranslogService.this.disableFlush = disableFlush;
            }
        }
    }
}

