/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard.service;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.channels.ClosedByInterruptException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.ThreadInterruptedException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.base.Charsets;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.XFilteredQuery;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.aliases.IndexAliasesService;
import org.elasticsearch.index.cache.IndexCache;
import org.elasticsearch.index.cache.filter.FilterCacheStats;
import org.elasticsearch.index.cache.filter.ShardFilterCache;
import org.elasticsearch.index.cache.id.IdCacheStats;
import org.elasticsearch.index.codec.CodecService;
import org.elasticsearch.index.deletionpolicy.SnapshotIndexCommit;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineClosedException;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.engine.IgnoreOnRecoveryEngineException;
import org.elasticsearch.index.engine.OptimizeFailedEngineException;
import org.elasticsearch.index.engine.RefreshFailedEngineException;
import org.elasticsearch.index.engine.SegmentsStats;
import org.elasticsearch.index.fielddata.FieldDataStats;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.fielddata.ShardFieldData;
import org.elasticsearch.index.flush.FlushStats;
import org.elasticsearch.index.get.GetStats;
import org.elasticsearch.index.get.ShardGetService;
import org.elasticsearch.index.indexing.IndexingStats;
import org.elasticsearch.index.indexing.ShardIndexingService;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.merge.MergeStats;
import org.elasticsearch.index.merge.scheduler.MergeSchedulerProvider;
import org.elasticsearch.index.percolator.PercolatorQueriesRegistry;
import org.elasticsearch.index.percolator.stats.ShardPercolateService;
import org.elasticsearch.index.query.IndexQueryParserService;
import org.elasticsearch.index.refresh.RefreshStats;
import org.elasticsearch.index.search.nested.NonNestedDocsFilter;
import org.elasticsearch.index.search.stats.SearchStats;
import org.elasticsearch.index.search.stats.ShardSearchService;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.DocsStats;
import org.elasticsearch.index.shard.IllegalIndexShardStateException;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.index.shard.IndexShardException;
import org.elasticsearch.index.shard.IndexShardNotRecoveringException;
import org.elasticsearch.index.shard.IndexShardNotStartedException;
import org.elasticsearch.index.shard.IndexShardRecoveringException;
import org.elasticsearch.index.shard.IndexShardRelocatedException;
import org.elasticsearch.index.shard.IndexShardStartedException;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreStats;
import org.elasticsearch.index.suggest.stats.ShardSuggestService;
import org.elasticsearch.index.suggest.stats.SuggestStats;
import org.elasticsearch.index.termvectors.ShardTermVectorService;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogStats;
import org.elasticsearch.index.warmer.ShardIndexWarmerService;
import org.elasticsearch.index.warmer.WarmerStats;
import org.elasticsearch.indices.IndicesLifecycle;
import org.elasticsearch.indices.InternalIndicesLifecycle;
import org.elasticsearch.indices.recovery.RecoveryStatus;
import org.elasticsearch.search.suggest.completion.Completion090PostingsFormat;
import org.elasticsearch.search.suggest.completion.CompletionStats;
import org.elasticsearch.threadpool.ThreadPool;

public class InternalIndexShard
extends AbstractIndexShardComponent
implements IndexShard {
    private final ThreadPool threadPool;
    private final IndexSettingsService indexSettingsService;
    private final MapperService mapperService;
    private final IndexQueryParserService queryParserService;
    private final IndexCache indexCache;
    private final InternalIndicesLifecycle indicesLifecycle;
    private final Store store;
    private final MergeSchedulerProvider mergeScheduler;
    private final Engine engine;
    private final Translog translog;
    private final IndexAliasesService indexAliasesService;
    private final ShardIndexingService indexingService;
    private final ShardSearchService searchService;
    private final ShardGetService getService;
    private final ShardIndexWarmerService shardWarmerService;
    private final ShardFilterCache shardFilterCache;
    private final ShardFieldData shardFieldData;
    private final PercolatorQueriesRegistry percolatorQueriesRegistry;
    private final ShardPercolateService shardPercolateService;
    private final CodecService codecService;
    private final ShardTermVectorService termVectorService;
    private final IndexFieldDataService indexFieldDataService;
    private final IndexService indexService;
    private final ShardSuggestService shardSuggestService;
    private final Object mutex = new Object();
    private final String checkIndexOnStartup;
    private long checkIndexTook = 0L;
    private volatile IndexShardState state;
    private TimeValue refreshInterval;
    private final TimeValue mergeInterval;
    private volatile ScheduledFuture refreshScheduledFuture;
    private volatile ScheduledFuture mergeScheduleFuture;
    private volatile ShardRouting shardRouting;
    private RecoveryStatus recoveryStatus;
    private ApplyRefreshSettings applyRefreshSettings = new ApplyRefreshSettings();
    private final MeanMetric refreshMetric = new MeanMetric();
    private final MeanMetric flushMetric = new MeanMetric();
    public static final String INDEX_REFRESH_INTERVAL = "index.refresh_interval";

    @Inject
    public InternalIndexShard(ShardId shardId, @IndexSettings Settings indexSettings, IndexSettingsService indexSettingsService, IndicesLifecycle indicesLifecycle, Store store, Engine engine, MergeSchedulerProvider mergeScheduler, Translog translog, ThreadPool threadPool, MapperService mapperService, IndexQueryParserService queryParserService, IndexCache indexCache, IndexAliasesService indexAliasesService, ShardIndexingService indexingService, ShardGetService getService, ShardSearchService searchService, ShardIndexWarmerService shardWarmerService, ShardFilterCache shardFilterCache, ShardFieldData shardFieldData, PercolatorQueriesRegistry percolatorQueriesRegistry, ShardPercolateService shardPercolateService, CodecService codecService, ShardTermVectorService termVectorService, IndexFieldDataService indexFieldDataService, IndexService indexService, ShardSuggestService shardSuggestService) {
        super(shardId, indexSettings);
        this.indicesLifecycle = (InternalIndicesLifecycle)indicesLifecycle;
        this.indexSettingsService = indexSettingsService;
        this.store = store;
        this.engine = engine;
        this.mergeScheduler = mergeScheduler;
        this.translog = translog;
        this.threadPool = threadPool;
        this.mapperService = mapperService;
        this.queryParserService = queryParserService;
        this.indexCache = indexCache;
        this.indexAliasesService = indexAliasesService;
        this.indexingService = indexingService;
        this.getService = getService.setIndexShard(this);
        this.termVectorService = termVectorService.setIndexShard(this);
        this.searchService = searchService;
        this.shardWarmerService = shardWarmerService;
        this.shardFilterCache = shardFilterCache;
        this.shardFieldData = shardFieldData;
        this.percolatorQueriesRegistry = percolatorQueriesRegistry;
        this.shardPercolateService = shardPercolateService;
        this.indexFieldDataService = indexFieldDataService;
        this.indexService = indexService;
        this.codecService = codecService;
        this.shardSuggestService = shardSuggestService;
        this.state = IndexShardState.CREATED;
        this.refreshInterval = indexSettings.getAsTime(INDEX_REFRESH_INTERVAL, engine.defaultRefreshInterval());
        this.mergeInterval = indexSettings.getAsTime("index.merge.async_interval", TimeValue.timeValueSeconds(1L));
        indexSettingsService.addListener(this.applyRefreshSettings);
        this.logger.debug("state: [CREATED]", new Object[0]);
        this.checkIndexOnStartup = indexSettings.get("index.shard.check_on_startup", "false");
    }

    public MergeSchedulerProvider mergeScheduler() {
        return this.mergeScheduler;
    }

    public Store store() {
        return this.store;
    }

    public Engine engine() {
        return this.engine;
    }

    public Translog translog() {
        return this.translog;
    }

    @Override
    public ShardIndexingService indexingService() {
        return this.indexingService;
    }

    @Override
    public ShardGetService getService() {
        return this.getService;
    }

    @Override
    public ShardTermVectorService termVectorService() {
        return this.termVectorService;
    }

    @Override
    public ShardSuggestService shardSuggestService() {
        return this.shardSuggestService;
    }

    @Override
    public IndexFieldDataService indexFieldDataService() {
        return this.indexFieldDataService;
    }

    @Override
    public MapperService mapperService() {
        return this.mapperService;
    }

    @Override
    public IndexService indexService() {
        return this.indexService;
    }

    @Override
    public ShardSearchService searchService() {
        return this.searchService;
    }

    @Override
    public ShardIndexWarmerService warmerService() {
        return this.shardWarmerService;
    }

    @Override
    public ShardFilterCache filterCache() {
        return this.shardFilterCache;
    }

    @Override
    public ShardFieldData fieldData() {
        return this.shardFieldData;
    }

    @Override
    public ShardRouting routingEntry() {
        return this.shardRouting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalIndexShard routingEntry(ShardRouting newRouting) {
        ShardRouting currentRouting = this.shardRouting;
        if (!newRouting.shardId().equals(this.shardId())) {
            throw new ElasticsearchIllegalArgumentException("Trying to set a routing entry with shardId [" + newRouting.shardId() + "] on a shard with shardId [" + this.shardId() + "]");
        }
        if (currentRouting != null) {
            if (!newRouting.primary() && currentRouting.primary()) {
                this.logger.warn("suspect illegal state: trying to move shard from primary mode to replica mode", new Object[0]);
            }
            if (currentRouting.equals(newRouting)) {
                return this;
            }
        }
        if (this.state == IndexShardState.POST_RECOVERY && (newRouting.state() == ShardRoutingState.STARTED || newRouting.state() == ShardRoutingState.RELOCATING)) {
            try {
                this.engine.refresh(new Engine.Refresh("cluster_state_started").force(true));
            }
            catch (Throwable t) {
                this.logger.debug("failed to refresh due to move to cluster wide started", t, new Object[0]);
            }
            boolean movedToStarted = false;
            Object object = this.mutex;
            synchronized (object) {
                if (this.state == IndexShardState.POST_RECOVERY) {
                    this.changeState(IndexShardState.STARTED, "global state is [" + (Object)((Object)newRouting.state()) + "]");
                    movedToStarted = true;
                } else {
                    this.logger.debug("state [{}] not changed, not in POST_RECOVERY, global state is [{}]", new Object[]{this.state, newRouting.state()});
                }
            }
            if (movedToStarted) {
                this.indicesLifecycle.afterIndexShardStarted(this);
            }
        }
        this.shardRouting = newRouting;
        this.indicesLifecycle.shardRoutingChanged(this, currentRouting, newRouting);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexShardState recovering(String reason) throws IndexShardStartedException, IndexShardRelocatedException, IndexShardRecoveringException, IndexShardClosedException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.state == IndexShardState.CLOSED) {
                throw new IndexShardClosedException(this.shardId);
            }
            if (this.state == IndexShardState.STARTED) {
                throw new IndexShardStartedException(this.shardId);
            }
            if (this.state == IndexShardState.RELOCATED) {
                throw new IndexShardRelocatedException(this.shardId);
            }
            if (this.state == IndexShardState.RECOVERING) {
                throw new IndexShardRecoveringException(this.shardId);
            }
            if (this.state == IndexShardState.POST_RECOVERY) {
                throw new IndexShardRecoveringException(this.shardId);
            }
            return this.changeState(IndexShardState.RECOVERING, reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalIndexShard relocated(String reason) throws IndexShardNotStartedException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.state != IndexShardState.STARTED) {
                throw new IndexShardNotStartedException(this.shardId, this.state);
            }
            this.changeState(IndexShardState.RELOCATED, reason);
        }
        return this;
    }

    @Override
    public IndexShardState state() {
        return this.state;
    }

    private IndexShardState changeState(IndexShardState newState, String reason) {
        this.logger.debug("state: [{}]->[{}], reason [{}]", new Object[]{this.state, newState, reason});
        IndexShardState previousState = this.state;
        this.state = newState;
        this.indicesLifecycle.indexShardStateChanged(this, previousState, reason);
        return previousState;
    }

    @Override
    public Engine.Create prepareCreate(SourceToParse source, long version, VersionType versionType, Engine.Operation.Origin origin, boolean canHaveDuplicates, boolean autoGeneratedId) throws ElasticsearchException {
        long startTime = System.nanoTime();
        DocumentMapper docMapper = this.mapperService.documentMapperWithAutoCreate(source.type());
        ParsedDocument doc = docMapper.parse(source);
        return new Engine.Create(docMapper, docMapper.uidMapper().term(doc.uid().stringValue()), doc, version, versionType, origin, startTime, this.state != IndexShardState.STARTED || canHaveDuplicates, autoGeneratedId);
    }

    @Override
    public ParsedDocument create(Engine.Create create) throws ElasticsearchException {
        this.writeAllowed(create.origin());
        create = this.indexingService.preCreate(create);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("index [{}][{}]{}", create.type(), create.id(), create.docs());
        }
        this.engine.create(create);
        create.endTime(System.nanoTime());
        this.indexingService.postCreate(create);
        return create.parsedDoc();
    }

    @Override
    public Engine.Index prepareIndex(SourceToParse source, long version, VersionType versionType, Engine.Operation.Origin origin, boolean canHaveDuplicates) throws ElasticsearchException {
        long startTime = System.nanoTime();
        DocumentMapper docMapper = this.mapperService.documentMapperWithAutoCreate(source.type());
        ParsedDocument doc = docMapper.parse(source);
        return new Engine.Index(docMapper, docMapper.uidMapper().term(doc.uid().stringValue()), doc, version, versionType, origin, startTime, this.state != IndexShardState.STARTED || canHaveDuplicates);
    }

    @Override
    public ParsedDocument index(Engine.Index index) throws ElasticsearchException {
        this.writeAllowed(index.origin());
        index = this.indexingService.preIndex(index);
        try {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("index [{}][{}]{}", index.type(), index.id(), index.docs());
            }
            this.engine.index(index);
            index.endTime(System.nanoTime());
        }
        catch (RuntimeException ex) {
            this.indexingService.failedIndex(index);
            throw ex;
        }
        this.indexingService.postIndex(index);
        return index.parsedDoc();
    }

    @Override
    public Engine.Delete prepareDelete(String type, String id, long version, VersionType versionType, Engine.Operation.Origin origin) throws ElasticsearchException {
        long startTime = System.nanoTime();
        DocumentMapper docMapper = this.mapperService.documentMapperWithAutoCreate(type);
        return new Engine.Delete(type, id, docMapper.uidMapper().term(type, id), version, versionType, origin, startTime, false);
    }

    @Override
    public void delete(Engine.Delete delete) throws ElasticsearchException {
        this.writeAllowed(delete.origin());
        delete = this.indexingService.preDelete(delete);
        try {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("delete [{}]", delete.uid().text());
            }
            this.engine.delete(delete);
            delete.endTime(System.nanoTime());
        }
        catch (RuntimeException ex) {
            this.indexingService.failedDelete(delete);
            throw ex;
        }
        this.indexingService.postDelete(delete);
    }

    @Override
    public Engine.DeleteByQuery prepareDeleteByQuery(BytesReference source, @Nullable String[] filteringAliases, Engine.Operation.Origin origin, String ... types) throws ElasticsearchException {
        long startTime = System.nanoTime();
        if (types == null) {
            types = Strings.EMPTY_ARRAY;
        }
        Query query = this.queryParserService.parseQuery(source).query();
        query = this.filterQueryIfNeeded(query, types);
        Filter aliasFilter = this.indexAliasesService.aliasFilter(filteringAliases);
        Filter parentFilter = this.mapperService.hasNested() ? this.indexCache.filter().cache(NonNestedDocsFilter.INSTANCE) : null;
        return new Engine.DeleteByQuery(query, source, filteringAliases, aliasFilter, parentFilter, origin, startTime, types);
    }

    @Override
    public void deleteByQuery(Engine.DeleteByQuery deleteByQuery) throws ElasticsearchException {
        this.writeAllowed(deleteByQuery.origin());
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("delete_by_query [{}]", deleteByQuery.query());
        }
        deleteByQuery = this.indexingService.preDeleteByQuery(deleteByQuery);
        this.engine.delete(deleteByQuery);
        deleteByQuery.endTime(System.nanoTime());
        this.indexingService.postDeleteByQuery(deleteByQuery);
    }

    @Override
    public Engine.GetResult get(Engine.Get get) throws ElasticsearchException {
        this.readAllowed();
        return this.engine.get(get);
    }

    @Override
    public void refresh(Engine.Refresh refresh) throws ElasticsearchException {
        this.verifyNotClosed();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("refresh with {}", refresh);
        }
        long time = System.nanoTime();
        this.engine.refresh(refresh);
        this.refreshMetric.inc(System.nanoTime() - time);
    }

    @Override
    public RefreshStats refreshStats() {
        return new RefreshStats(this.refreshMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.refreshMetric.sum()));
    }

    @Override
    public FlushStats flushStats() {
        return new FlushStats(this.flushMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.flushMetric.sum()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocsStats docStats() {
        try (Engine.Searcher searcher = this.acquireSearcher("doc_stats");){
            DocsStats docsStats = new DocsStats(searcher.reader().numDocs(), searcher.reader().numDeletedDocs());
            return docsStats;
        }
    }

    @Override
    public IndexingStats indexingStats(String ... types) {
        return this.indexingService.stats(types);
    }

    @Override
    public SearchStats searchStats(String ... groups) {
        return this.searchService.stats(groups);
    }

    @Override
    public GetStats getStats() {
        return this.getService.stats();
    }

    @Override
    public StoreStats storeStats() {
        try {
            return this.store.stats();
        }
        catch (IOException e) {
            throw new ElasticsearchException("io exception while building 'store stats'", e);
        }
    }

    @Override
    public MergeStats mergeStats() {
        return this.mergeScheduler.stats();
    }

    @Override
    public SegmentsStats segmentStats() {
        return this.engine.segmentsStats();
    }

    @Override
    public WarmerStats warmerStats() {
        return this.shardWarmerService.stats();
    }

    @Override
    public FilterCacheStats filterCacheStats() {
        return this.shardFilterCache.stats();
    }

    @Override
    public FieldDataStats fieldDataStats(String ... fields) {
        return this.shardFieldData.stats(fields);
    }

    @Override
    public PercolatorQueriesRegistry percolateRegistry() {
        return this.percolatorQueriesRegistry;
    }

    @Override
    public ShardPercolateService shardPercolateService() {
        return this.shardPercolateService;
    }

    @Override
    public IdCacheStats idCacheStats() {
        long memorySizeInBytes = this.shardFieldData.stats("_parent").getFields().get("_parent");
        return new IdCacheStats(memorySizeInBytes);
    }

    @Override
    public TranslogStats translogStats() {
        return this.translog.stats();
    }

    @Override
    public SuggestStats suggestStats() {
        return this.shardSuggestService.stats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStats completionStats(String ... fields) {
        CompletionStats completionStats = new CompletionStats();
        try (Engine.Searcher currentSearcher = this.acquireSearcher("completion_stats");){
            PostingsFormat postingsFormat = this.codecService.postingsFormatService().get("completion090").get();
            if (postingsFormat instanceof Completion090PostingsFormat) {
                Completion090PostingsFormat completionPostingsFormat = (Completion090PostingsFormat)postingsFormat;
                completionStats.add(completionPostingsFormat.completionStats(currentSearcher.reader(), fields));
            }
        }
        return completionStats;
    }

    @Override
    public void flush(Engine.Flush flush) throws ElasticsearchException {
        this.verifyStartedOrRecovering();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("flush with {}", flush);
        }
        long time = System.nanoTime();
        this.engine.flush(flush);
        this.flushMetric.inc(System.nanoTime() - time);
    }

    @Override
    public void optimize(Engine.Optimize optimize) throws ElasticsearchException {
        this.verifyStarted();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("optimize with {}", optimize);
        }
        this.engine.optimize(optimize);
    }

    @Override
    public SnapshotIndexCommit snapshotIndex() throws EngineException {
        IndexShardState state = this.state;
        if (state == IndexShardState.STARTED || state == IndexShardState.RELOCATED || state == IndexShardState.CLOSED) {
            return this.engine.snapshotIndex();
        }
        throw new IllegalIndexShardStateException(this.shardId, state, "snapshot is not allowed");
    }

    @Override
    public void recover(Engine.RecoveryHandler recoveryHandler) throws EngineException {
        this.verifyStarted();
        this.engine.recover(recoveryHandler);
    }

    @Override
    public void failShard(String reason, @Nullable Throwable e) {
        this.engine.failEngine(reason, e);
    }

    @Override
    public Engine.Searcher acquireSearcher(String source) {
        return this.acquireSearcher(source, IndexShard.Mode.READ);
    }

    @Override
    public Engine.Searcher acquireSearcher(String source, IndexShard.Mode mode) {
        this.readAllowed(mode);
        return this.engine.acquireSearcher(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(String reason) {
        Object object = this.mutex;
        synchronized (object) {
            this.indexSettingsService.removeListener(this.applyRefreshSettings);
            if (this.state != IndexShardState.CLOSED) {
                if (this.refreshScheduledFuture != null) {
                    this.refreshScheduledFuture.cancel(true);
                    this.refreshScheduledFuture = null;
                }
                if (this.mergeScheduleFuture != null) {
                    this.mergeScheduleFuture.cancel(true);
                    this.mergeScheduleFuture = null;
                }
            }
            this.changeState(IndexShardState.CLOSED, reason);
        }
    }

    public long checkIndexTook() {
        return this.checkIndexTook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalIndexShard postRecovery(String reason) throws IndexShardStartedException, IndexShardRelocatedException, IndexShardClosedException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.state == IndexShardState.CLOSED) {
                throw new IndexShardClosedException(this.shardId);
            }
            if (this.state == IndexShardState.STARTED) {
                throw new IndexShardStartedException(this.shardId);
            }
            if (this.state == IndexShardState.RELOCATED) {
                throw new IndexShardRelocatedException(this.shardId);
            }
            if (Booleans.parseBoolean(this.checkIndexOnStartup, false)) {
                this.checkIndex(true);
            }
            this.engine.start();
            this.startScheduledTasksIfNeeded();
            this.changeState(IndexShardState.POST_RECOVERY, reason);
        }
        this.indicesLifecycle.afterIndexShardPostRecovery(this);
        return this;
    }

    public void performRecoveryPrepareForTranslog() throws ElasticsearchException {
        if (this.state != IndexShardState.RECOVERING) {
            throw new IndexShardNotRecoveringException(this.shardId, this.state);
        }
        if (Booleans.parseBoolean(this.checkIndexOnStartup, false)) {
            this.checkIndex(true);
        }
        this.engine.enableGcDeletes(false);
        this.engine.start();
    }

    public RecoveryStatus recoveryStatus() {
        return this.recoveryStatus;
    }

    public void performRecoveryFinalization(boolean withFlush, RecoveryStatus recoveryStatus) throws ElasticsearchException {
        this.performRecoveryFinalization(withFlush);
        this.recoveryStatus = recoveryStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performRecoveryFinalization(boolean withFlush) throws ElasticsearchException {
        if (withFlush) {
            this.engine.flush(new Engine.Flush());
        }
        this.translog.clearUnreferenced();
        this.engine.refresh(new Engine.Refresh("recovery_finalization").force(true));
        Object object = this.mutex;
        synchronized (object) {
            this.changeState(IndexShardState.POST_RECOVERY, "post recovery");
        }
        this.indicesLifecycle.afterIndexShardPostRecovery(this);
        this.startScheduledTasksIfNeeded();
        this.engine.enableGcDeletes(true);
    }

    public void performRecoveryOperation(Translog.Operation operation) throws ElasticsearchException {
        block11: {
            if (this.state != IndexShardState.RECOVERING) {
                throw new IndexShardNotRecoveringException(this.shardId, this.state);
            }
            try {
                switch (operation.opType()) {
                    case CREATE: {
                        Translog.Create create = (Translog.Create)operation;
                        this.engine.create(this.prepareCreate(SourceToParse.source(create.source()).type(create.type()).id(create.id()).routing(create.routing()).parent(create.parent()).timestamp(create.timestamp()).ttl(create.ttl()), create.version(), create.versionType().versionTypeForReplicationAndRecovery(), Engine.Operation.Origin.RECOVERY, true, false));
                        break;
                    }
                    case SAVE: {
                        Translog.Index index = (Translog.Index)operation;
                        this.engine.index(this.prepareIndex(SourceToParse.source(index.source()).type(index.type()).id(index.id()).routing(index.routing()).parent(index.parent()).timestamp(index.timestamp()).ttl(index.ttl()), index.version(), index.versionType().versionTypeForReplicationAndRecovery(), Engine.Operation.Origin.RECOVERY, true));
                        break;
                    }
                    case DELETE: {
                        Translog.Delete delete = (Translog.Delete)operation;
                        Uid uid = Uid.createUid(delete.uid().text());
                        this.engine.delete(new Engine.Delete(uid.type(), uid.id(), delete.uid(), delete.version(), delete.versionType().versionTypeForReplicationAndRecovery(), Engine.Operation.Origin.RECOVERY, System.nanoTime(), false));
                        break;
                    }
                    case DELETE_BY_QUERY: {
                        Translog.DeleteByQuery deleteByQuery = (Translog.DeleteByQuery)operation;
                        this.engine.delete(this.prepareDeleteByQuery(deleteByQuery.source(), deleteByQuery.filteringAliases(), Engine.Operation.Origin.RECOVERY, deleteByQuery.types()));
                        break;
                    }
                    default: {
                        throw new ElasticsearchIllegalStateException("No operation defined for [" + operation + "]");
                    }
                }
            }
            catch (ElasticsearchException e) {
                boolean hasIgnoreOnRecoveryException = false;
                ElasticsearchException current = e;
                while (true) {
                    if (current instanceof IgnoreOnRecoveryEngineException) {
                        hasIgnoreOnRecoveryException = true;
                        break;
                    }
                    if (!(current.getCause() instanceof ElasticsearchException)) break;
                    current = (ElasticsearchException)current.getCause();
                }
                if (hasIgnoreOnRecoveryException) break block11;
                throw e;
            }
        }
    }

    @Override
    public boolean ignoreRecoveryAttempt() {
        IndexShardState state = this.state();
        return state == IndexShardState.POST_RECOVERY || state == IndexShardState.RECOVERING || state == IndexShardState.STARTED || state == IndexShardState.RELOCATED || state == IndexShardState.CLOSED;
    }

    @Override
    public void readAllowed() throws IllegalIndexShardStateException {
        this.readAllowed(IndexShard.Mode.READ);
    }

    @Override
    public void readAllowed(IndexShard.Mode mode) throws IllegalIndexShardStateException {
        IndexShardState state = this.state;
        switch (mode) {
            case READ: {
                if (state == IndexShardState.STARTED || state == IndexShardState.RELOCATED) break;
                throw new IllegalIndexShardStateException(this.shardId, state, "operations only allowed when started/relocated");
            }
            case WRITE: {
                if (state == IndexShardState.STARTED || state == IndexShardState.RELOCATED || state == IndexShardState.RECOVERING || state == IndexShardState.POST_RECOVERY) break;
                throw new IllegalIndexShardStateException(this.shardId, state, "operations only allowed when started/relocated");
            }
        }
    }

    private void writeAllowed(Engine.Operation.Origin origin) throws IllegalIndexShardStateException {
        IndexShardState state = this.state;
        if (origin == Engine.Operation.Origin.PRIMARY ? state != IndexShardState.STARTED && state != IndexShardState.RELOCATED : state != IndexShardState.STARTED && state != IndexShardState.RELOCATED && state != IndexShardState.RECOVERING && state != IndexShardState.POST_RECOVERY) {
            throw new IllegalIndexShardStateException(this.shardId, state, "operation only allowed when started/recovering, origin [" + (Object)((Object)origin) + "]");
        }
    }

    private void verifyStartedOrRecovering() throws IllegalIndexShardStateException {
        IndexShardState state = this.state;
        if (state != IndexShardState.STARTED && state != IndexShardState.RECOVERING && state != IndexShardState.POST_RECOVERY) {
            throw new IllegalIndexShardStateException(this.shardId, state, "operation only allowed when started/recovering");
        }
    }

    private void verifyNotClosed() throws IllegalIndexShardStateException {
        IndexShardState state = this.state;
        if (state == IndexShardState.CLOSED) {
            throw new IllegalIndexShardStateException(this.shardId, state, "operation only allowed when not closed");
        }
    }

    private void verifyStarted() throws IllegalIndexShardStateException {
        IndexShardState state = this.state;
        if (state != IndexShardState.STARTED) {
            throw new IndexShardNotStartedException(this.shardId, state);
        }
    }

    private void startScheduledTasksIfNeeded() {
        if (this.refreshInterval.millis() > 0L) {
            this.refreshScheduledFuture = this.threadPool.schedule(this.refreshInterval, "same", new EngineRefresher());
            this.logger.debug("scheduling refresher every {}", this.refreshInterval);
        } else {
            this.logger.debug("scheduled refresher disabled", new Object[0]);
        }
        if (this.mergeInterval.millis() > 0L) {
            this.mergeScheduleFuture = this.threadPool.schedule(this.mergeInterval, "same", new EngineMerger());
            this.logger.debug("scheduling optimizer / merger every {}", this.mergeInterval);
        } else {
            this.logger.debug("scheduled optimizer / merger disabled", new Object[0]);
        }
    }

    private Query filterQueryIfNeeded(Query query, String[] types) {
        Filter searchFilter = this.mapperService.searchFilter(types);
        if (searchFilter != null) {
            query = new XFilteredQuery(query, this.indexCache.filter().cache(searchFilter));
        }
        return query;
    }

    private void checkIndex(boolean throwException) throws IndexShardException {
        try {
            this.checkIndexTook = 0L;
            long time = System.currentTimeMillis();
            if (!Lucene.indexExists(this.store.directory())) {
                return;
            }
            CheckIndex checkIndex = new CheckIndex(this.store.directory());
            BytesStreamOutput os = new BytesStreamOutput();
            PrintStream out = new PrintStream((OutputStream)os, false, Charsets.UTF_8.name());
            checkIndex.setInfoStream(out);
            out.flush();
            CheckIndex.Status status = checkIndex.checkIndex();
            if (!status.clean) {
                if (this.state == IndexShardState.CLOSED) {
                    return;
                }
                this.logger.warn("check index [failure]\n{}", new String(os.bytes().toBytes(), Charsets.UTF_8));
                if ("fix".equalsIgnoreCase(this.checkIndexOnStartup)) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("fixing index, writing new segments file ...", new Object[0]);
                    }
                    checkIndex.fixIndex(status);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("index fixed, wrote new segments file \"{}\"", status.segmentsFileName);
                    }
                } else if (throwException) {
                    throw new IndexShardException(this.shardId, "index check failure");
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("check index [success]\n{}", new String(os.bytes().toBytes(), Charsets.UTF_8));
            }
            this.checkIndexTook = System.currentTimeMillis() - time;
        }
        catch (Exception e) {
            this.logger.warn("failed to check index", e, new Object[0]);
        }
    }

    class EngineMerger
    implements Runnable {
        EngineMerger() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!InternalIndexShard.this.engine().possibleMergeNeeded()) {
                Object object = InternalIndexShard.this.mutex;
                synchronized (object) {
                    if (InternalIndexShard.this.state != IndexShardState.CLOSED) {
                        InternalIndexShard.this.mergeScheduleFuture = InternalIndexShard.this.threadPool.schedule(InternalIndexShard.this.mergeInterval, "same", this);
                    }
                }
                return;
            }
            InternalIndexShard.this.threadPool.executor("merge").execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block9: {
                        try {
                            InternalIndexShard.this.engine.maybeMerge();
                        }
                        catch (EngineClosedException e) {
                        }
                        catch (OptimizeFailedEngineException e) {
                            if (!(e.getCause() instanceof EngineClosedException || e.getCause() instanceof InterruptedException || e.getCause() instanceof ClosedByInterruptException || e.getCause() instanceof ThreadInterruptedException || InternalIndexShard.this.state == IndexShardState.CLOSED)) {
                                InternalIndexShard.this.logger.warn("Failed to perform scheduled engine optimize/merge", e, new Object[0]);
                            }
                        }
                        catch (Exception e) {
                            if (InternalIndexShard.this.state == IndexShardState.CLOSED) break block9;
                            InternalIndexShard.this.logger.warn("Failed to perform scheduled engine optimize/merge", e, new Object[0]);
                        }
                    }
                    Object object = InternalIndexShard.this.mutex;
                    synchronized (object) {
                        if (InternalIndexShard.this.state != IndexShardState.CLOSED) {
                            InternalIndexShard.this.mergeScheduleFuture = InternalIndexShard.this.threadPool.schedule(InternalIndexShard.this.mergeInterval, "same", EngineMerger.this);
                        }
                    }
                }
            });
        }
    }

    class EngineRefresher
    implements Runnable {
        EngineRefresher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!InternalIndexShard.this.engine().refreshNeeded()) {
                Object object = InternalIndexShard.this.mutex;
                synchronized (object) {
                    if (InternalIndexShard.this.state != IndexShardState.CLOSED) {
                        InternalIndexShard.this.refreshScheduledFuture = InternalIndexShard.this.threadPool.schedule(InternalIndexShard.this.refreshInterval, "same", this);
                    }
                }
                return;
            }
            InternalIndexShard.this.threadPool.executor("refresh").execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block10: {
                        try {
                            if (InternalIndexShard.this.engine.refreshNeeded()) {
                                InternalIndexShard.this.refresh(new Engine.Refresh("scheduled").force(false));
                            }
                        }
                        catch (EngineClosedException e) {
                        }
                        catch (RefreshFailedEngineException e) {
                            if (!(e.getCause() instanceof InterruptedException || e.getCause() instanceof ClosedByInterruptException || e.getCause() instanceof ThreadInterruptedException || InternalIndexShard.this.state == IndexShardState.CLOSED)) {
                                InternalIndexShard.this.logger.warn("Failed to perform scheduled engine refresh", e, new Object[0]);
                            }
                        }
                        catch (Exception e) {
                            if (InternalIndexShard.this.state == IndexShardState.CLOSED) break block10;
                            InternalIndexShard.this.logger.warn("Failed to perform scheduled engine refresh", e, new Object[0]);
                        }
                    }
                    Object object = InternalIndexShard.this.mutex;
                    synchronized (object) {
                        if (InternalIndexShard.this.state != IndexShardState.CLOSED) {
                            InternalIndexShard.this.refreshScheduledFuture = InternalIndexShard.this.threadPool.schedule(InternalIndexShard.this.refreshInterval, "same", EngineRefresher.this);
                        }
                    }
                }
            });
        }
    }

    private class ApplyRefreshSettings
    implements IndexSettingsService.Listener {
        private ApplyRefreshSettings() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRefreshSettings(Settings settings) {
            Object object = InternalIndexShard.this.mutex;
            synchronized (object) {
                if (InternalIndexShard.this.state == IndexShardState.CLOSED) {
                    return;
                }
                TimeValue refreshInterval = settings.getAsTime(InternalIndexShard.INDEX_REFRESH_INTERVAL, InternalIndexShard.this.refreshInterval);
                if (!refreshInterval.equals(InternalIndexShard.this.refreshInterval)) {
                    InternalIndexShard.this.logger.info("updating refresh_interval from [{}] to [{}]", InternalIndexShard.this.refreshInterval, refreshInterval);
                    if (InternalIndexShard.this.refreshScheduledFuture != null) {
                        InternalIndexShard.this.refreshScheduledFuture.cancel(false);
                        InternalIndexShard.this.refreshScheduledFuture = null;
                    }
                    InternalIndexShard.this.refreshInterval = refreshInterval;
                    if (refreshInterval.millis() > 0L) {
                        InternalIndexShard.this.refreshScheduledFuture = InternalIndexShard.this.threadPool.schedule(refreshInterval, "same", new EngineRefresher());
                    }
                }
            }
        }
    }
}

