/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.nested;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.PrefixFilter;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.common.lucene.docset.DocIdSets;

public class NonNestedDocsFilter
extends Filter {
    public static final NonNestedDocsFilter INSTANCE = new NonNestedDocsFilter();
    private final PrefixFilter filter = new PrefixFilter(new Term("_type", new BytesRef("__")));
    private final int hashCode = this.filter.hashCode();

    private NonNestedDocsFilter() {
    }

    @Override
    public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
        DocIdSet docSet = this.filter.getDocIdSet(context, acceptDocs);
        if (DocIdSets.isEmpty(docSet)) {
            docSet = new FixedBitSet(context.reader().maxDoc());
        }
        ((FixedBitSet)docSet).flip(0, context.reader().maxDoc());
        return docSet;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        return obj == INSTANCE;
    }
}

