/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.query.BaseQueryBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;
import org.elasticsearch.index.query.MoreLikeThisQueryParser;
import org.elasticsearch.search.fetch.source.FetchSourceContext;

public class MoreLikeThisQueryBuilder
extends BaseQueryBuilder
implements BoostableQueryBuilder<MoreLikeThisQueryBuilder> {
    private final String[] fields;
    private String likeText;
    private List<String> ids = new ArrayList<String>();
    private List<Item> docs = new ArrayList<Item>();
    private Boolean exclude = null;
    private float percentTermsToMatch = -1.0f;
    private int minTermFreq = -1;
    private int maxQueryTerms = -1;
    private String[] stopWords = null;
    private int minDocFreq = -1;
    private int maxDocFreq = -1;
    private int minWordLength = -1;
    private int maxWordLength = -1;
    private float boostTerms = -1.0f;
    private float boost = -1.0f;
    private String analyzer;
    private Boolean failOnUnsupportedField;
    private String queryName;

    public MoreLikeThisQueryBuilder() {
        this.fields = null;
    }

    public MoreLikeThisQueryBuilder(String ... fields) {
        this.fields = fields;
    }

    public MoreLikeThisQueryBuilder likeText(String likeText) {
        this.likeText = likeText;
        return this;
    }

    public MoreLikeThisQueryBuilder ids(String ... ids) {
        this.ids = Arrays.asList(ids);
        return this;
    }

    public MoreLikeThisQueryBuilder docs(Item ... docs) {
        this.docs = Arrays.asList(docs);
        return this;
    }

    public MoreLikeThisQueryBuilder addItem(Item item) {
        this.docs.add(item);
        return this;
    }

    public MoreLikeThisQueryBuilder exclude(boolean exclude) {
        this.exclude = exclude;
        return this;
    }

    public MoreLikeThisQueryBuilder percentTermsToMatch(float percentTermsToMatch) {
        this.percentTermsToMatch = percentTermsToMatch;
        return this;
    }

    public MoreLikeThisQueryBuilder minTermFreq(int minTermFreq) {
        this.minTermFreq = minTermFreq;
        return this;
    }

    public MoreLikeThisQueryBuilder maxQueryTerms(int maxQueryTerms) {
        this.maxQueryTerms = maxQueryTerms;
        return this;
    }

    public MoreLikeThisQueryBuilder stopWords(String ... stopWords) {
        this.stopWords = stopWords;
        return this;
    }

    public MoreLikeThisQueryBuilder minDocFreq(int minDocFreq) {
        this.minDocFreq = minDocFreq;
        return this;
    }

    public MoreLikeThisQueryBuilder maxDocFreq(int maxDocFreq) {
        this.maxDocFreq = maxDocFreq;
        return this;
    }

    public MoreLikeThisQueryBuilder minWordLength(int minWordLength) {
        this.minWordLength = minWordLength;
        return this;
    }

    public MoreLikeThisQueryBuilder maxWordLength(int maxWordLength) {
        this.maxWordLength = maxWordLength;
        return this;
    }

    public MoreLikeThisQueryBuilder boostTerms(float boostTerms) {
        this.boostTerms = boostTerms;
        return this;
    }

    public MoreLikeThisQueryBuilder analyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    @Override
    public MoreLikeThisQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    public MoreLikeThisQueryBuilder failOnUnsupportedField(boolean fail) {
        this.failOnUnsupportedField = fail;
        return this;
    }

    public MoreLikeThisQueryBuilder queryName(String queryName) {
        this.queryName = queryName;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("mlt");
        if (this.fields != null) {
            builder.startArray("fields");
            for (String field : this.fields) {
                builder.value(field);
            }
            builder.endArray();
        }
        if (this.likeText == null && this.docs.isEmpty() && this.ids.isEmpty()) {
            throw new ElasticsearchIllegalArgumentException("more_like_this requires either '" + MoreLikeThisQueryParser.Fields.LIKE_TEXT.getPreferredName() + "' or 'docs/ids' to be provided");
        }
        builder.field(MoreLikeThisQueryParser.Fields.LIKE_TEXT.getPreferredName(), this.likeText);
        if (this.percentTermsToMatch != -1.0f) {
            builder.field(MoreLikeThisQueryParser.Fields.PERCENT_TERMS_TO_MATCH.getPreferredName(), this.percentTermsToMatch);
        }
        if (this.minTermFreq != -1) {
            builder.field(MoreLikeThisQueryParser.Fields.MIN_TERM_FREQ.getPreferredName(), this.minTermFreq);
        }
        if (this.maxQueryTerms != -1) {
            builder.field(MoreLikeThisQueryParser.Fields.MAX_QUERY_TERMS.getPreferredName(), this.maxQueryTerms);
        }
        if (this.stopWords != null && this.stopWords.length > 0) {
            builder.startArray(MoreLikeThisQueryParser.Fields.STOP_WORDS.getPreferredName());
            for (String stopWord : this.stopWords) {
                builder.value(stopWord);
            }
            builder.endArray();
        }
        if (this.minDocFreq != -1) {
            builder.field(MoreLikeThisQueryParser.Fields.MIN_DOC_FREQ.getPreferredName(), this.minDocFreq);
        }
        if (this.maxDocFreq != -1) {
            builder.field(MoreLikeThisQueryParser.Fields.MAX_DOC_FREQ.getPreferredName(), this.maxDocFreq);
        }
        if (this.minWordLength != -1) {
            builder.field(MoreLikeThisQueryParser.Fields.MIN_WORD_LENGTH.getPreferredName(), this.minWordLength);
        }
        if (this.maxWordLength != -1) {
            builder.field(MoreLikeThisQueryParser.Fields.MAX_WORD_LENGTH.getPreferredName(), this.maxWordLength);
        }
        if (this.boostTerms != -1.0f) {
            builder.field(MoreLikeThisQueryParser.Fields.BOOST_TERMS.getPreferredName(), this.boostTerms);
        }
        if (this.boost != -1.0f) {
            builder.field("boost", this.boost);
        }
        if (this.analyzer != null) {
            builder.field("analyzer", this.analyzer);
        }
        if (this.failOnUnsupportedField != null) {
            builder.field(MoreLikeThisQueryParser.Fields.FAIL_ON_UNSUPPORTED_FIELD.getPreferredName(), (Object)this.failOnUnsupportedField);
        }
        if (this.queryName != null) {
            builder.field("_name", this.queryName);
        }
        if (!this.ids.isEmpty()) {
            builder.array("ids", this.ids.toArray());
        }
        if (!this.docs.isEmpty()) {
            builder.array("docs", this.docs.toArray());
        }
        if (this.exclude != null) {
            builder.field("exclude", (Object)this.exclude);
        }
        builder.endObject();
    }

    public static final class Item
    extends MultiGetRequest.Item
    implements ToXContent {
        public Item() {
        }

        public Item(String index, @Nullable String type, String id) {
            super(index, type, id);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.index() != null) {
                builder.field("_index", this.index());
            }
            if (this.id() != null) {
                builder.field("_id", this.id());
            }
            if (this.type() != null) {
                builder.field("_type", this.type());
            }
            if (this.fields() != null) {
                builder.array("fields", this.fields());
            }
            if (this.routing() != null) {
                builder.field("_routing", this.routing());
            }
            if (this.fetchSourceContext() != null) {
                FetchSourceContext source = this.fetchSourceContext();
                String[] includes = source.includes();
                String[] excludes = source.excludes();
                if (includes.length == 0 && excludes.length == 0) {
                    builder.field("_source", source.fetchSource());
                } else if (includes.length > 0 && excludes.length == 0) {
                    builder.array("_source", source.includes());
                } else if (excludes.length > 0) {
                    builder.startObject("_source");
                    if (includes.length > 0) {
                        builder.array("includes", source.includes());
                    }
                    builder.array("excludes", source.excludes());
                    builder.endObject();
                }
            }
            if (this.version() != -3L) {
                builder.field("_version", this.version());
            }
            if (this.versionType() != VersionType.INTERNAL) {
                builder.field("_version_type", this.versionType().toString().toLowerCase(Locale.ROOT));
            }
            return builder.endObject();
        }
    }
}

