/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.ScriptDocValues;

public class BinaryDVAtomicFieldData
implements AtomicFieldData<ScriptDocValues.Strings> {
    private final AtomicReader reader;
    private final String field;

    public BinaryDVAtomicFieldData(AtomicReader reader, String field) {
        this.reader = reader;
        this.field = field;
    }

    @Override
    public boolean isMultiValued() {
        return false;
    }

    @Override
    public long getNumberUniqueValues() {
        return this.reader.maxDoc();
    }

    @Override
    public long getMemorySizeInBytes() {
        return -1L;
    }

    @Override
    public BytesValues getBytesValues(boolean needsHashes) {
        Bits docsWithField;
        BinaryDocValues values;
        try {
            BinaryDocValues v = this.reader.getBinaryDocValues(this.field);
            if (v == null) {
                values = DocValues.EMPTY_BINARY;
                docsWithField = new Bits.MatchNoBits(this.reader.maxDoc());
            } else {
                values = v;
                Bits b = this.reader.getDocsWithField(this.field);
                docsWithField = b == null ? new Bits.MatchAllBits(this.reader.maxDoc()) : b;
            }
        }
        catch (IOException e) {
            throw new ElasticsearchIllegalStateException("Cannot load doc values", e);
        }
        return new BytesValues(false){

            @Override
            public int setDocument(int docId) {
                this.docId = docId;
                return docsWithField.get(docId) ? 1 : 0;
            }

            @Override
            public BytesRef nextValue() {
                values.get(this.docId, this.scratch);
                return this.scratch;
            }
        };
    }

    @Override
    public ScriptDocValues.Strings getScriptValues() {
        return new ScriptDocValues.Strings(this.getBytesValues(false));
    }

    @Override
    public void close() {
    }
}

