/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import java.util.Comparator;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;

public class AtomicFieldDataWithOrdinalsTermsEnum
extends TermsEnum {
    private final BytesValues.WithOrdinals bytesValues;
    private final Ordinals.Docs ordinals;
    private final long maxOrd;
    private long currentOrd = -1L;
    private BytesRef currentTerm;

    public AtomicFieldDataWithOrdinalsTermsEnum(AtomicFieldData.WithOrdinals afd) {
        this.bytesValues = afd.getBytesValues(false);
        this.ordinals = this.bytesValues.ordinals();
        this.maxOrd = this.ordinals.getMaxOrd();
    }

    @Override
    public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
        long ord = AtomicFieldDataWithOrdinalsTermsEnum.binarySearch(this.bytesValues, text);
        if (ord >= 0L) {
            this.currentOrd = ord;
            this.currentTerm = this.bytesValues.getValueByOrd(this.currentOrd);
            return TermsEnum.SeekStatus.FOUND;
        }
        this.currentOrd = -ord - 1L;
        if (ord >= this.maxOrd) {
            return TermsEnum.SeekStatus.END;
        }
        this.currentTerm = this.bytesValues.getValueByOrd(this.currentOrd);
        return TermsEnum.SeekStatus.NOT_FOUND;
    }

    @Override
    public void seekExact(long ord) throws IOException {
        assert (ord >= 0L && ord < this.ordinals.getMaxOrd());
        this.currentOrd = ord;
        this.currentTerm = this.currentOrd == -1L ? null : this.bytesValues.getValueByOrd(this.currentOrd);
    }

    @Override
    public BytesRef term() throws IOException {
        return this.currentTerm;
    }

    @Override
    public long ord() throws IOException {
        return this.currentOrd;
    }

    @Override
    public int docFreq() throws IOException {
        throw new UnsupportedOperationException("docFreq not supported");
    }

    @Override
    public long totalTermFreq() throws IOException {
        return -1L;
    }

    @Override
    public DocsEnum docs(Bits liveDocs, DocsEnum reuse, int flags) throws IOException {
        throw new UnsupportedOperationException("docs not supported");
    }

    @Override
    public DocsAndPositionsEnum docsAndPositions(Bits liveDocs, DocsAndPositionsEnum reuse, int flags) throws IOException {
        throw new UnsupportedOperationException("docsAndPositions not supported");
    }

    @Override
    public BytesRef next() throws IOException {
        if (++this.currentOrd < this.maxOrd) {
            this.currentTerm = this.bytesValues.getValueByOrd(this.currentOrd);
            return this.currentTerm;
        }
        return null;
    }

    @Override
    public Comparator<BytesRef> getComparator() {
        return BytesRef.getUTF8SortedAsUnicodeComparator();
    }

    private static final long binarySearch(BytesValues.WithOrdinals a, BytesRef key) {
        long low = 1L;
        long high = a.ordinals().getMaxOrd();
        while (low <= high) {
            long mid = low + high >>> 1;
            BytesRef midVal = a.getValueByOrd(mid);
            int cmp = midVal != null ? midVal.compareTo(key) : -1;
            if (cmp < 0) {
                low = mid + 1L;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1L;
                continue;
            }
            return mid;
        }
        return -(low + 1L);
    }
}

