/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.ordinals;

import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedInts;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.ordinals.OrdinalsBuilder;

public class SinglePackedOrdinals
implements Ordinals {
    private final PackedInts.Reader reader;
    private final long maxOrd;
    private long size = -1L;

    public SinglePackedOrdinals(OrdinalsBuilder builder, float acceptableOverheadRatio) {
        assert (builder.getNumMultiValuesDocs() == 0);
        this.maxOrd = builder.getMaxOrd();
        PackedInts.Mutable reader = PackedInts.getMutable(builder.maxDoc(), PackedInts.bitsRequired(this.getMaxOrd()), acceptableOverheadRatio);
        PackedInts.copy(builder.getFirstOrdinals(), 0, reader, 0, builder.maxDoc(), 8192);
        this.reader = reader;
    }

    @Override
    public long getMemorySizeInBytes() {
        if (this.size == -1L) {
            this.size = (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF + this.reader.ramBytesUsed();
        }
        return this.size;
    }

    @Override
    public boolean isMultiValued() {
        return false;
    }

    @Override
    public long getMaxOrd() {
        return this.maxOrd;
    }

    @Override
    public Docs ordinals() {
        return new Docs(this, this.reader);
    }

    public static class Docs
    extends Ordinals.AbstractDocs {
        private final PackedInts.Reader reader;
        private long currentOrdinal;

        public Docs(SinglePackedOrdinals parent, PackedInts.Reader reader) {
            super(parent);
            this.reader = reader;
        }

        @Override
        public long getOrd(int docId) {
            this.currentOrdinal = this.reader.get(docId) - 1L;
            return this.currentOrdinal;
        }

        @Override
        public long nextOrd() {
            assert (this.currentOrdinal >= 0L);
            return this.currentOrdinal;
        }

        @Override
        public int setDocument(int docId) {
            this.currentOrdinal = this.reader.get(docId) - 1L;
            return 1 + (int)Math.min(this.currentOrdinal, 0L);
        }

        @Override
        public long currentOrd() {
            return this.currentOrdinal;
        }
    }
}

