/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.ordinals.OrdinalsBuilder;

public interface IndexNumericFieldData<FD extends AtomicNumericFieldData>
extends IndexFieldData<FD> {
    public NumericType getNumericType();

    @Override
    public FD load(AtomicReaderContext var1);

    @Override
    public FD loadDirect(AtomicReaderContext var1) throws Exception;

    public static enum NumericType {
        BYTE(8, false, SortField.Type.INT, (byte)-128, (byte)127){

            @Override
            public long toLong(BytesRef indexForm) {
                return INT.toLong(indexForm);
            }

            @Override
            public void toIndexForm(Number number, BytesRef bytes) {
                INT.toIndexForm(number, bytes);
            }

            @Override
            public Number toNumber(BytesRef indexForm) {
                return INT.toNumber(indexForm);
            }
        }
        ,
        SHORT(16, false, SortField.Type.INT, (short)Short.MIN_VALUE, (short)Short.MAX_VALUE){

            @Override
            public long toLong(BytesRef indexForm) {
                return INT.toLong(indexForm);
            }

            @Override
            public void toIndexForm(Number number, BytesRef bytes) {
                INT.toIndexForm(number, bytes);
            }

            @Override
            public Number toNumber(BytesRef indexForm) {
                return INT.toNumber(indexForm);
            }
        }
        ,
        INT(32, false, SortField.Type.INT, Integer.MIN_VALUE, Integer.MAX_VALUE){

            @Override
            public long toLong(BytesRef indexForm) {
                return NumericUtils.prefixCodedToInt(indexForm);
            }

            @Override
            public void toIndexForm(Number number, BytesRef bytes) {
                NumericUtils.intToPrefixCodedBytes(number.intValue(), 0, bytes);
            }

            @Override
            public Number toNumber(BytesRef indexForm) {
                return NumericUtils.prefixCodedToInt(indexForm);
            }
        }
        ,
        LONG(64, false, SortField.Type.LONG, Long.MIN_VALUE, Long.MAX_VALUE){

            @Override
            public long toLong(BytesRef indexForm) {
                return NumericUtils.prefixCodedToLong(indexForm);
            }

            @Override
            public void toIndexForm(Number number, BytesRef bytes) {
                NumericUtils.longToPrefixCodedBytes(number.longValue(), 0, bytes);
            }

            @Override
            public Number toNumber(BytesRef indexForm) {
                return NumericUtils.prefixCodedToLong(indexForm);
            }
        }
        ,
        FLOAT(32, true, SortField.Type.FLOAT, Float.valueOf(Float.NEGATIVE_INFINITY), Float.valueOf(Float.POSITIVE_INFINITY)){

            @Override
            public double toDouble(BytesRef indexForm) {
                return NumericUtils.sortableIntToFloat(NumericUtils.prefixCodedToInt(indexForm));
            }

            @Override
            public void toIndexForm(Number number, BytesRef bytes) {
                NumericUtils.intToPrefixCodedBytes(NumericUtils.floatToSortableInt(number.floatValue()), 0, bytes);
            }

            @Override
            public Number toNumber(BytesRef indexForm) {
                return Float.valueOf(NumericUtils.sortableIntToFloat(NumericUtils.prefixCodedToInt(indexForm)));
            }
        }
        ,
        DOUBLE(64, true, SortField.Type.DOUBLE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY){

            @Override
            public double toDouble(BytesRef indexForm) {
                return NumericUtils.sortableLongToDouble(NumericUtils.prefixCodedToLong(indexForm));
            }

            @Override
            public void toIndexForm(Number number, BytesRef bytes) {
                NumericUtils.longToPrefixCodedBytes(NumericUtils.doubleToSortableLong(number.doubleValue()), 0, bytes);
            }

            @Override
            public Number toNumber(BytesRef indexForm) {
                return NumericUtils.sortableLongToDouble(NumericUtils.prefixCodedToLong(indexForm));
            }
        };

        private final int requiredBits;
        private final boolean floatingPoint;
        private final SortField.Type type;
        private final Number minValue;
        private final Number maxValue;

        private NumericType(int requiredBits, boolean floatingPoint, SortField.Type type, Number minValue, Number maxValue) {
            this.requiredBits = requiredBits;
            this.floatingPoint = floatingPoint;
            this.type = type;
            this.minValue = minValue;
            this.maxValue = maxValue;
        }

        public final SortField.Type sortFieldType() {
            return this.type;
        }

        public final Number minValue() {
            return this.minValue;
        }

        public final Number maxValue() {
            return this.maxValue;
        }

        public final boolean isFloatingPoint() {
            return this.floatingPoint;
        }

        public final int requiredBits() {
            return this.requiredBits;
        }

        public abstract void toIndexForm(Number var1, BytesRef var2);

        public long toLong(BytesRef indexForm) {
            return (long)this.toDouble(indexForm);
        }

        public double toDouble(BytesRef indexForm) {
            return this.toLong(indexForm);
        }

        public abstract Number toNumber(BytesRef var1);

        public final TermsEnum wrapTermsEnum(TermsEnum termsEnum) {
            if (this.requiredBits() > 32) {
                return OrdinalsBuilder.wrapNumeric64Bit(termsEnum);
            }
            return OrdinalsBuilder.wrapNumeric32Bit(termsEnum);
        }
    }
}

