/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis.compound;

import java.net.URL;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.compound.HyphenationCompoundWordTokenFilter;
import org.apache.lucene.analysis.compound.hyphenation.HyphenationTree;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AnalysisSettingsRequired;
import org.elasticsearch.index.analysis.compound.AbstractCompoundWordTokenFilterFactory;
import org.elasticsearch.index.settings.IndexSettings;
import org.xml.sax.InputSource;

@AnalysisSettingsRequired
public class HyphenationCompoundWordTokenFilterFactory
extends AbstractCompoundWordTokenFilterFactory {
    private final HyphenationTree hyphenationTree;

    @Inject
    public HyphenationCompoundWordTokenFilterFactory(Index index, @IndexSettings Settings indexSettings, Environment env, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, env, name, settings);
        String hyphenationPatternsPath = settings.get("hyphenation_patterns_path", null);
        if (hyphenationPatternsPath == null) {
            throw new ElasticsearchIllegalArgumentException("hyphenation_patterns_path is a required setting.");
        }
        URL hyphenationPatternsFile = env.resolveConfig(hyphenationPatternsPath);
        try {
            this.hyphenationTree = HyphenationCompoundWordTokenFilter.getHyphenationTree(new InputSource(hyphenationPatternsFile.toExternalForm()));
        }
        catch (Exception e) {
            throw new ElasticsearchIllegalArgumentException("Exception while reading hyphenation_patterns_path: " + e.getMessage());
        }
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        return new HyphenationCompoundWordTokenFilter(this.version, tokenStream, this.hyphenationTree, this.wordList, this.minWordSize, this.minSubwordSize, this.maxSubwordSize, this.onlyLongestMatch);
    }
}

