/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.uid;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class Versions {
    public static final long MATCH_ANY = -3L;
    public static final long MATCH_ANY_PRE_1_2_0 = 0L;
    public static final long NOT_FOUND = -1L;
    public static final long NOT_SET = -2L;

    public static void writeVersion(long version, StreamOutput out) throws IOException {
        if (out.getVersion().before(Version.V_1_2_0) && version == -3L) {
            version = 0L;
        }
        out.writeLong(version);
    }

    public static long readVersion(StreamInput in) throws IOException {
        long version = in.readLong();
        if (in.getVersion().before(Version.V_1_2_0) && version == 0L) {
            version = -3L;
        }
        return version;
    }

    public static void writeVersionWithVLongForBW(long version, StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(Version.V_1_2_0)) {
            out.writeLong(version);
            return;
        }
        if (version == -3L) {
            version = 0L;
        }
        out.writeVLong(version);
    }

    public static long readVersionWithVLongForBW(StreamInput in) throws IOException {
        if (in.getVersion().onOrAfter(Version.V_1_2_0)) {
            return in.readLong();
        }
        long version = in.readVLong();
        if (version == 0L) {
            return -3L;
        }
        return version;
    }

    private Versions() {
    }

    public static DocIdAndVersion loadDocIdAndVersion(IndexReader reader, Term term) throws IOException {
        List<AtomicReaderContext> leaves = reader.leaves();
        for (int i = leaves.size() - 1; i >= 0; --i) {
            DocIdAndVersion docIdAndVersion = Versions.loadDocIdAndVersion(leaves.get(i), term);
            if (docIdAndVersion == null) continue;
            assert (docIdAndVersion.version != -1L);
            return docIdAndVersion;
        }
        return null;
    }

    public static long loadVersion(IndexReader reader, Term term) throws IOException {
        DocIdAndVersion docIdAndVersion = Versions.loadDocIdAndVersion(reader, term);
        return docIdAndVersion == null ? -1L : docIdAndVersion.version;
    }

    public static DocIdAndVersion loadDocIdAndVersion(AtomicReaderContext readerContext, Term term) throws IOException {
        assert (term.field().equals("_uid"));
        AtomicReader reader = readerContext.reader();
        Bits liveDocs = reader.getLiveDocs();
        Terms terms = reader.terms("_uid");
        assert (terms != null) : "All segments must have a _uid field, but " + reader + " doesn't";
        TermsEnum termsEnum = terms.iterator(null);
        if (!termsEnum.seekExact(term.bytes())) {
            return null;
        }
        NumericDocValues versions = reader.getNumericDocValues("_version");
        if (versions != null || !terms.hasPayloads()) {
            DocsEnum docs = termsEnum.docs(null, null);
            int docID = Integer.MAX_VALUE;
            int d = docs.nextDoc();
            while (d != Integer.MAX_VALUE) {
                docID = d;
                d = docs.nextDoc();
            }
            assert (docID != Integer.MAX_VALUE);
            if (liveDocs != null && !liveDocs.get(docID)) {
                return null;
            }
            if (versions != null) {
                return new DocIdAndVersion(docID, versions.get(docID), readerContext);
            }
            return new DocIdAndVersion(docID, -2L, readerContext);
        }
        DocsAndPositionsEnum dpe = termsEnum.docsAndPositions(liveDocs, null, 2);
        assert (dpe != null);
        int docID = Integer.MAX_VALUE;
        int d = dpe.nextDoc();
        while (d != Integer.MAX_VALUE) {
            docID = d;
            dpe.nextPosition();
            BytesRef payload = dpe.getPayload();
            if (payload != null && payload.length == 8) {
                return new DocIdAndVersion(d, Numbers.bytesToLong(payload), readerContext);
            }
            d = dpe.nextDoc();
        }
        if (docID == Integer.MAX_VALUE) {
            return null;
        }
        return new DocIdAndVersion(docID, -2L, readerContext);
    }

    public static class DocIdAndVersion {
        public final int docId;
        public final long version;
        public final AtomicReaderContext context;

        public DocIdAndVersion(int docId, long version, AtomicReaderContext context) {
            this.docId = docId;
            this.version = version;
            this.context = context;
        }
    }
}

