/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.MultiTermQueryWrapperFilter;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.util.Bits;

public class RegexpFilter
extends Filter {
    private final Term term;
    private final int flags;
    private final InternalFilter filter;

    public RegexpFilter(Term term) {
        this(term, 65535);
    }

    public RegexpFilter(Term term, int flags) {
        this.filter = new InternalFilter(term, flags);
        this.term = term;
        this.flags = flags;
    }

    public String field() {
        return this.term.field();
    }

    public String regexp() {
        return this.term.text();
    }

    public int flags() {
        return this.flags;
    }

    @Override
    public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
        return this.filter.getDocIdSet(context, acceptDocs);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegexpFilter that = (RegexpFilter)o;
        if (this.flags != that.flags) {
            return false;
        }
        return !(this.term != null ? !this.term.equals(that.term) : that.term != null);
    }

    public int hashCode() {
        int result = this.term != null ? this.term.hashCode() : 0;
        result = 31 * result + this.flags;
        return result;
    }

    public String toString() {
        return this.term.field() + ":" + this.term.text();
    }

    static class InternalFilter
    extends MultiTermQueryWrapperFilter<RegexpQuery> {
        public InternalFilter(Term term) {
            super(new RegexpQuery(term));
        }

        public InternalFilter(Term term, int flags) {
            super(new RegexpQuery(term, flags));
        }
    }
}

