/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.docset;

import java.io.IOException;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.Bits;

public class AllDocIdSet
extends DocIdSet {
    private final int maxDoc;

    public AllDocIdSet(int maxDoc) {
        this.maxDoc = maxDoc;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    @Override
    public DocIdSetIterator iterator() throws IOException {
        return new Iterator(this.maxDoc);
    }

    @Override
    public Bits bits() throws IOException {
        return new Bits.MatchAllBits(this.maxDoc);
    }

    public static final class Iterator
    extends DocIdSetIterator {
        private final int maxDoc;
        private int doc = -1;

        public Iterator(int maxDoc) {
            this.maxDoc = maxDoc;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() throws IOException {
            if (++this.doc < this.maxDoc) {
                return this.doc;
            }
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }

        @Override
        public int advance(int target) throws IOException {
            this.doc = target;
            if (this.doc < this.maxDoc) {
                return this.doc;
            }
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }

        @Override
        public long cost() {
            return this.maxDoc;
        }
    }
}

