/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.common.logging.ESLogger;

public class FileSystemUtils {
    public static boolean mkdirs(File dir) {
        return dir.mkdirs();
    }

    public static boolean hasExtensions(File root, String ... extensions) {
        File[] children;
        if (root != null && root.exists() && root.isDirectory() && (children = root.listFiles()) != null) {
            for (File child : children) {
                if (child.isDirectory()) {
                    boolean has = FileSystemUtils.hasExtensions(child, extensions);
                    if (!has) continue;
                    return true;
                }
                for (String extension : extensions) {
                    if (!child.getName().endsWith(extension)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean exists(File ... files) {
        for (File file : files) {
            if (!file.exists()) continue;
            return true;
        }
        return false;
    }

    public static boolean deleteRecursively(File[] roots, boolean deleteRoots) {
        boolean deleted = true;
        for (File root : roots) {
            deleted &= FileSystemUtils.deleteRecursively(root, deleteRoots);
        }
        return deleted;
    }

    public static boolean deleteSubDirectories(File[] roots) {
        boolean deleted = true;
        for (File root : roots) {
            if (!root.isDirectory()) continue;
            File[] files = root.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
            });
            deleted &= FileSystemUtils.deleteRecursively(files, true);
        }
        return deleted;
    }

    public static boolean deleteRecursively(File ... roots) {
        return FileSystemUtils.deleteRecursively(roots, true);
    }

    public static boolean deleteRecursively(File root, boolean deleteRoot) {
        if (root != null && root.exists()) {
            File[] children;
            if (root.isDirectory() && (children = root.listFiles()) != null) {
                for (File aChildren : children) {
                    FileSystemUtils.deleteRecursively(aChildren, true);
                }
            }
            if (deleteRoot) {
                return root.delete();
            }
            return true;
        }
        return false;
    }

    public static void syncFile(File fileToSync, boolean isDir) throws IOException {
        IOUtils.fsync(fileToSync, isDir);
    }

    public static boolean isAccessibleDirectory(File directory, ESLogger logger) {
        assert (directory != null && logger != null);
        if (!directory.exists()) {
            logger.debug("[{}] directory does not exist.", directory.getAbsolutePath());
            return false;
        }
        if (!directory.isDirectory()) {
            logger.debug("[{}] should be a directory but is not.", directory.getAbsolutePath());
            return false;
        }
        if (!directory.canRead()) {
            logger.debug("[{}] directory is not readable.", directory.getAbsolutePath());
            return false;
        }
        return true;
    }

    private FileSystemUtils() {
    }

    public static void tryDeleteFile(File file) {
        try {
            file.delete();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

