/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeohashPathIterator;

public class GeoHashUtils {
    private static final char[] BASE_32 = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    public static final int PRECISION = 12;
    private static final int[] BITS = new int[]{16, 8, 4, 2, 1};

    private GeoHashUtils() {
    }

    public static String encode(double latitude, double longitude) {
        return GeoHashUtils.encode(latitude, longitude, 12);
    }

    public static String encode(double latitude, double longitude, int precision) {
        double latInterval0 = -90.0;
        double latInterval1 = 90.0;
        double lngInterval0 = -180.0;
        double lngInterval1 = 180.0;
        StringBuilder geohash = new StringBuilder();
        boolean isEven = true;
        int bit = 0;
        int ch = 0;
        while (geohash.length() < precision) {
            double mid = 0.0;
            if (isEven) {
                mid = (lngInterval0 + lngInterval1) / 2.0;
                if (longitude > mid) {
                    ch |= BITS[bit];
                    lngInterval0 = mid;
                } else {
                    lngInterval1 = mid;
                }
            } else {
                mid = (latInterval0 + latInterval1) / 2.0;
                if (latitude > mid) {
                    ch |= BITS[bit];
                    latInterval0 = mid;
                } else {
                    latInterval1 = mid;
                }
            }
            boolean bl = isEven = !isEven;
            if (bit < 4) {
                ++bit;
                continue;
            }
            geohash.append(BASE_32[ch]);
            bit = 0;
            ch = 0;
        }
        return geohash.toString();
    }

    private static final char encode(int x, int y) {
        return BASE_32[((x & 1) + (y & 1) * 2 + (x & 2) * 2 + (y & 2) * 4 + (x & 4) * 4) % 32];
    }

    public static Collection<? extends CharSequence> neighbors(String geohash) {
        return GeoHashUtils.addNeighbors(geohash, geohash.length(), new ArrayList(8));
    }

    public static Iterable<String> path(final String geohash) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new GeohashPathIterator(geohash);
            }
        };
    }

    private static final String neighbor(String geohash, int level, int dx, int dy) {
        int yLimit;
        int cell = GeoHashUtils.decode(geohash.charAt(level - 1));
        int x0 = cell & 1;
        int y0 = cell & 2;
        int x1 = cell & 4;
        int y1 = cell & 8;
        int x2 = cell & 0x10;
        int x = x0 + x1 / 2 + x2 / 4;
        int y = y0 / 2 + y1 / 4;
        if (level == 1) {
            if (dy < 0 && y == 0 || dy > 0 && y == 3) {
                return null;
            }
            return Character.toString(GeoHashUtils.encode(x + dx, y + dy));
        }
        int nx = level % 2 == 1 ? x + dx : x + dy;
        int ny = level % 2 == 1 ? y + dy : y + dx;
        int xLimit = level % 2 == 0 ? 7 : 3;
        int n = yLimit = level % 2 == 0 ? 3 : 7;
        if (nx >= 0 && nx <= xLimit && ny >= 0 && ny < yLimit) {
            return geohash.substring(0, level - 1) + GeoHashUtils.encode(nx, ny);
        }
        String neighbor = GeoHashUtils.neighbor(geohash, level - 1, dx, dy);
        if (neighbor != null) {
            return neighbor + GeoHashUtils.encode(nx, ny);
        }
        return null;
    }

    public static final <E extends Collection<? super String>> E addNeighbors(String geohash, E neighbors) {
        return GeoHashUtils.addNeighbors(geohash, geohash.length(), neighbors);
    }

    public static final <E extends Collection<? super String>> E addNeighbors(String geohash, int length, E neighbors) {
        String south = GeoHashUtils.neighbor(geohash, length, 0, -1);
        String north = GeoHashUtils.neighbor(geohash, length, 0, 1);
        if (north != null) {
            neighbors.add((String)GeoHashUtils.neighbor(north, length, -1, 0));
            neighbors.add((String)north);
            neighbors.add((String)GeoHashUtils.neighbor(north, length, 1, 0));
        }
        neighbors.add((String)GeoHashUtils.neighbor(geohash, length, -1, 0));
        neighbors.add((String)GeoHashUtils.neighbor(geohash, length, 1, 0));
        if (south != null) {
            neighbors.add((String)GeoHashUtils.neighbor(south, length, -1, 0));
            neighbors.add((String)south);
            neighbors.add((String)GeoHashUtils.neighbor(south, length, 1, 0));
        }
        return (E)neighbors;
    }

    private static final int decode(char geo) {
        switch (geo) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'b': {
                return 10;
            }
            case 'c': {
                return 11;
            }
            case 'd': {
                return 12;
            }
            case 'e': {
                return 13;
            }
            case 'f': {
                return 14;
            }
            case 'g': {
                return 15;
            }
            case 'h': {
                return 16;
            }
            case 'j': {
                return 17;
            }
            case 'k': {
                return 18;
            }
            case 'm': {
                return 19;
            }
            case 'n': {
                return 20;
            }
            case 'p': {
                return 21;
            }
            case 'q': {
                return 22;
            }
            case 'r': {
                return 23;
            }
            case 's': {
                return 24;
            }
            case 't': {
                return 25;
            }
            case 'u': {
                return 26;
            }
            case 'v': {
                return 27;
            }
            case 'w': {
                return 28;
            }
            case 'x': {
                return 29;
            }
            case 'y': {
                return 30;
            }
            case 'z': {
                return 31;
            }
        }
        throw new ElasticsearchIllegalArgumentException("the character '" + geo + "' is not a valid geohash character");
    }

    public static GeoPoint decode(String geohash) {
        return GeoHashUtils.decode(geohash, new GeoPoint());
    }

    public static GeoPoint decode(String geohash, GeoPoint ret) {
        double[] interval = GeoHashUtils.decodeCell(geohash);
        return ret.reset((interval[0] + interval[1]) / 2.0, (interval[2] + interval[3]) / 2.0);
    }

    public static void decodeCell(String geohash, GeoPoint northWest, GeoPoint southEast) {
        double[] interval = GeoHashUtils.decodeCell(geohash);
        northWest.reset(interval[1], interval[2]);
        southEast.reset(interval[0], interval[3]);
    }

    private static double[] decodeCell(String geohash) {
        double[] interval = new double[]{-90.0, 90.0, -180.0, 180.0};
        boolean isEven = true;
        for (int i = 0; i < geohash.length(); ++i) {
            int cd = GeoHashUtils.decode(geohash.charAt(i));
            for (int mask : BITS) {
                if (isEven) {
                    if ((cd & mask) != 0) {
                        interval[2] = (interval[2] + interval[3]) / 2.0;
                    } else {
                        interval[3] = (interval[2] + interval[3]) / 2.0;
                    }
                } else if ((cd & mask) != 0) {
                    interval[0] = (interval[0] + interval[1]) / 2.0;
                } else {
                    interval[1] = (interval[0] + interval[1]) / 2.0;
                }
                isEven = !isEven;
            }
        }
        return interval;
    }

    public static long encodeAsLong(double latitude, double longitude, int precision) {
        if (precision > 12 || precision < 1) {
            throw new ElasticsearchIllegalArgumentException("Illegal precision length of " + precision + ". Long-based geohashes only support precisions between 1 and 12");
        }
        double latInterval0 = -90.0;
        double latInterval1 = 90.0;
        double lngInterval0 = -180.0;
        double lngInterval1 = 180.0;
        long geohash = 0L;
        boolean isEven = true;
        int bit = 0;
        int ch = 0;
        int geohashLength = 0;
        while (geohashLength < precision) {
            double mid = 0.0;
            if (isEven) {
                mid = (lngInterval0 + lngInterval1) / 2.0;
                if (longitude > mid) {
                    ch |= BITS[bit];
                    lngInterval0 = mid;
                } else {
                    lngInterval1 = mid;
                }
            } else {
                mid = (latInterval0 + latInterval1) / 2.0;
                if (latitude > mid) {
                    ch |= BITS[bit];
                    latInterval0 = mid;
                } else {
                    latInterval1 = mid;
                }
            }
            boolean bl = isEven = !isEven;
            if (bit < 4) {
                ++bit;
                continue;
            }
            geohash |= (long)ch;
            if (++geohashLength < precision) {
                geohash <<= 5;
            }
            bit = 0;
            ch = 0;
        }
        geohash <<= 4;
        return geohash |= (long)precision;
    }

    public static String toString(long geohashAsLong) {
        int precision = (int)(geohashAsLong & 0xFL);
        char[] chars = new char[precision];
        geohashAsLong >>= 4;
        for (int i = precision - 1; i >= 0; --i) {
            chars[i] = BASE_32[(int)(geohashAsLong & 0x1FL)];
            geohashAsLong >>= 5;
        }
        return new String(chars);
    }

    public static GeoPoint decode(long geohash) {
        GeoPoint point = new GeoPoint();
        GeoHashUtils.decode(geohash, point);
        return point;
    }

    public static void decode(long geohash, GeoPoint ret) {
        double[] interval = GeoHashUtils.decodeCell(geohash);
        ret.reset((interval[0] + interval[1]) / 2.0, (interval[2] + interval[3]) / 2.0);
    }

    private static double[] decodeCell(long geohash) {
        int i;
        double[] interval = new double[]{-90.0, 90.0, -180.0, 180.0};
        boolean isEven = true;
        int precision = (int)(geohash & 0xFL);
        geohash >>= 4;
        int[] cds = new int[precision];
        for (i = precision - 1; i >= 0; --i) {
            cds[i] = (int)(geohash & 0x1FL);
            geohash >>= 5;
        }
        for (i = 0; i < cds.length; ++i) {
            int cd = cds[i];
            for (int mask : BITS) {
                if (isEven) {
                    if ((cd & mask) != 0) {
                        interval[2] = (interval[2] + interval[3]) / 2.0;
                    } else {
                        interval[3] = (interval[2] + interval[3]) / 2.0;
                    }
                } else if ((cd & mask) != 0) {
                    interval[0] = (interval[0] + interval[1]) / 2.0;
                } else {
                    interval[1] = (interval[0] + interval[1]) / 2.0;
                }
                isEven = !isEven;
            }
        }
        return interval;
    }
}

