/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.percolate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.UnavailableShardsException;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.get.TransportMultiGetAction;
import org.elasticsearch.action.percolate.MultiPercolateRequest;
import org.elasticsearch.action.percolate.MultiPercolateResponse;
import org.elasticsearch.action.percolate.PercolateRequest;
import org.elasticsearch.action.percolate.PercolateResponse;
import org.elasticsearch.action.percolate.PercolateShardRequest;
import org.elasticsearch.action.percolate.TransportPercolateAction;
import org.elasticsearch.action.percolate.TransportShardMultiPercolateAction;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationFailedException;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.common.hppc.IntArrayList;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.index.engine.DocumentMissingException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.percolator.PercolatorService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportService;

public class TransportMultiPercolateAction
extends TransportAction<MultiPercolateRequest, MultiPercolateResponse> {
    private final ClusterService clusterService;
    private final PercolatorService percolatorService;
    private final TransportMultiGetAction multiGetAction;
    private final TransportShardMultiPercolateAction shardMultiPercolateAction;

    @Inject
    public TransportMultiPercolateAction(Settings settings, ThreadPool threadPool, TransportShardMultiPercolateAction shardMultiPercolateAction, ClusterService clusterService, TransportService transportService, PercolatorService percolatorService, TransportMultiGetAction multiGetAction) {
        super(settings, threadPool);
        this.shardMultiPercolateAction = shardMultiPercolateAction;
        this.clusterService = clusterService;
        this.percolatorService = percolatorService;
        this.multiGetAction = multiGetAction;
        transportService.registerHandler("mpercolate", new TransportHandler());
    }

    @Override
    protected void doExecute(MultiPercolateRequest request, final ActionListener<MultiPercolateResponse> listener) {
        final ClusterState clusterState = this.clusterService.state();
        clusterState.blocks().globalBlockedRaiseException(ClusterBlockLevel.READ);
        final ArrayList<Object> percolateRequests = new ArrayList<Object>(request.requests().size());
        final IntArrayList getRequestSlots = new IntArrayList();
        ArrayList<GetRequest> existingDocsRequests = new ArrayList<GetRequest>();
        for (int slot = 0; slot < request.requests().size(); ++slot) {
            PercolateRequest percolateRequest = request.requests().get(slot);
            percolateRequest.startTime = System.currentTimeMillis();
            percolateRequests.add(percolateRequest);
            if (percolateRequest.getRequest() == null) continue;
            existingDocsRequests.add(percolateRequest.getRequest());
            getRequestSlots.add(slot);
        }
        if (!existingDocsRequests.isEmpty()) {
            MultiGetRequest multiGetRequest = new MultiGetRequest();
            for (GetRequest getRequest : existingDocsRequests) {
                multiGetRequest.add(new MultiGetRequest.Item(getRequest.index(), getRequest.type(), getRequest.id()).routing(getRequest.routing()));
            }
            this.multiGetAction.execute(multiGetRequest, new ActionListener<MultiGetResponse>(){

                @Override
                public void onResponse(MultiGetResponse multiGetItemResponses) {
                    for (int i = 0; i < multiGetItemResponses.getResponses().length; ++i) {
                        MultiGetItemResponse itemResponse = multiGetItemResponses.getResponses()[i];
                        int slot = getRequestSlots.get(i);
                        if (!itemResponse.isFailed()) {
                            GetResponse getResponse = itemResponse.getResponse();
                            if (getResponse.isExists()) {
                                PercolateRequest originalRequest = (PercolateRequest)percolateRequests.get(slot);
                                percolateRequests.set(slot, new PercolateRequest(originalRequest, getResponse.getSourceAsBytesRef()));
                                continue;
                            }
                            TransportMultiPercolateAction.this.logger.trace("mpercolate existing doc, item[{}] doesn't exist", slot);
                            percolateRequests.set(slot, new DocumentMissingException(null, getResponse.getType(), getResponse.getId()));
                            continue;
                        }
                        TransportMultiPercolateAction.this.logger.trace("mpercolate existing doc, item[{}] failure {}", slot, itemResponse.getFailure());
                        percolateRequests.set(slot, itemResponse.getFailure());
                    }
                    new ASyncAction(percolateRequests, listener, clusterState).run();
                }

                @Override
                public void onFailure(Throwable e) {
                    listener.onFailure(e);
                }
            });
        } else {
            new ASyncAction(percolateRequests, listener, clusterState).run();
        }
    }

    class TransportHandler
    extends BaseTransportRequestHandler<MultiPercolateRequest> {
        TransportHandler() {
        }

        @Override
        public MultiPercolateRequest newInstance() {
            return new MultiPercolateRequest();
        }

        @Override
        public void messageReceived(final MultiPercolateRequest request, final TransportChannel channel) throws Exception {
            request.listenerThreaded(false);
            TransportMultiPercolateAction.this.execute(request, new ActionListener<MultiPercolateResponse>(){

                @Override
                public void onResponse(MultiPercolateResponse response) {
                    try {
                        channel.sendResponse(response);
                    }
                    catch (Throwable e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception e1) {
                        TransportMultiPercolateAction.this.logger.warn("Failed to send error response for action [mpercolate] and request [" + request + "]", e1, new Object[0]);
                    }
                }
            });
        }

        @Override
        public String executor() {
            return "same";
        }
    }

    private class ASyncAction {
        final ActionListener<MultiPercolateResponse> finalListener;
        final Map<ShardId, TransportShardMultiPercolateAction.Request> requestsByShard;
        final List<Object> percolateRequests;
        final Map<ShardId, IntArrayList> shardToSlots;
        final AtomicInteger expectedOperations;
        final AtomicArray<Object> reducedResponses;
        final AtomicReferenceArray<AtomicInteger> expectedOperationsPerItem;
        final AtomicReferenceArray<AtomicReferenceArray> responsesByItemAndShard;

        ASyncAction(List<Object> percolateRequests, ActionListener<MultiPercolateResponse> finalListener, ClusterState clusterState) {
            this.finalListener = finalListener;
            this.percolateRequests = percolateRequests;
            this.responsesByItemAndShard = new AtomicReferenceArray(percolateRequests.size());
            this.expectedOperationsPerItem = new AtomicReferenceArray(percolateRequests.size());
            this.reducedResponses = new AtomicArray(percolateRequests.size());
            this.requestsByShard = new HashMap<ShardId, TransportShardMultiPercolateAction.Request>();
            this.shardToSlots = new HashMap<ShardId, IntArrayList>();
            int expectedResults = 0;
            for (int slot = 0; slot < percolateRequests.size(); ++slot) {
                Object element = percolateRequests.get(slot);
                assert (element != null);
                if (element instanceof PercolateRequest) {
                    String[] concreteIndices;
                    PercolateRequest percolateRequest = (PercolateRequest)element;
                    try {
                        concreteIndices = clusterState.metaData().concreteIndices(percolateRequest.indicesOptions(), percolateRequest.indices());
                    }
                    catch (IndexMissingException e) {
                        this.reducedResponses.set(slot, e);
                        this.responsesByItemAndShard.set(slot, new AtomicReferenceArray(0));
                        this.expectedOperationsPerItem.set(slot, new AtomicInteger(0));
                        continue;
                    }
                    Map<String, Set<String>> routing = clusterState.metaData().resolveSearchRouting(percolateRequest.routing(), percolateRequest.indices());
                    GroupShardsIterator shards = TransportMultiPercolateAction.this.clusterService.operationRouting().searchShards(clusterState, percolateRequest.indices(), concreteIndices, routing, percolateRequest.preference());
                    if (shards.size() == 0) {
                        this.reducedResponses.set(slot, new UnavailableShardsException(null, "No shards available"));
                        this.responsesByItemAndShard.set(slot, new AtomicReferenceArray(0));
                        this.expectedOperationsPerItem.set(slot, new AtomicInteger(0));
                        continue;
                    }
                    this.responsesByItemAndShard.set(slot, new AtomicReferenceArray(shards.size()));
                    this.expectedOperationsPerItem.set(slot, new AtomicInteger(shards.size()));
                    for (ShardIterator shard : shards) {
                        ShardId shardId = shard.shardId();
                        TransportShardMultiPercolateAction.Request requests = this.requestsByShard.get(shardId);
                        if (requests == null) {
                            requests = new TransportShardMultiPercolateAction.Request(shard.shardId().getIndex(), shardId.id(), percolateRequest.preference());
                            this.requestsByShard.put(shardId, requests);
                        }
                        TransportMultiPercolateAction.this.logger.trace("Adding shard[{}] percolate request for item[{}]", shardId, slot);
                        requests.add(new TransportShardMultiPercolateAction.Request.Item(slot, new PercolateShardRequest(shardId, percolateRequest)));
                        IntArrayList items = this.shardToSlots.get(shardId);
                        if (items == null) {
                            items = new IntArrayList();
                            this.shardToSlots.put(shardId, items);
                        }
                        items.add(slot);
                    }
                    ++expectedResults;
                    continue;
                }
                if (!(element instanceof Throwable) && !(element instanceof MultiGetResponse.Failure)) continue;
                TransportMultiPercolateAction.this.logger.trace("item[{}] won't be executed, reason: {}", slot, element);
                this.reducedResponses.set(slot, element);
                this.responsesByItemAndShard.set(slot, new AtomicReferenceArray(0));
                this.expectedOperationsPerItem.set(slot, new AtomicInteger(0));
            }
            this.expectedOperations = new AtomicInteger(expectedResults);
        }

        void run() {
            if (this.expectedOperations.get() == 0) {
                this.finish();
                return;
            }
            TransportMultiPercolateAction.this.logger.trace("mpercolate executing for shards {}", this.requestsByShard.keySet());
            for (Map.Entry<ShardId, TransportShardMultiPercolateAction.Request> entry : this.requestsByShard.entrySet()) {
                final ShardId shardId = entry.getKey();
                TransportShardMultiPercolateAction.Request shardRequest = entry.getValue();
                TransportMultiPercolateAction.this.shardMultiPercolateAction.execute(shardRequest, new ActionListener<TransportShardMultiPercolateAction.Response>(){

                    @Override
                    public void onResponse(TransportShardMultiPercolateAction.Response response) {
                        ASyncAction.this.onShardResponse(shardId, response);
                    }

                    @Override
                    public void onFailure(Throwable e) {
                        ASyncAction.this.onShardFailure(shardId, e);
                    }
                });
            }
        }

        void onShardResponse(ShardId shardId, TransportShardMultiPercolateAction.Response response) {
            TransportMultiPercolateAction.this.logger.debug("{} Percolate shard response", shardId);
            try {
                for (TransportShardMultiPercolateAction.Response.Item item : response.items()) {
                    AtomicReferenceArray shardResults = this.responsesByItemAndShard.get(item.slot());
                    if (shardResults == null) {
                        assert (false) : "shardResults can't be null";
                        continue;
                    }
                    if (item.failed()) {
                        shardResults.set(shardId.id(), new BroadcastShardOperationFailedException(shardId, item.error().string()));
                    } else {
                        shardResults.set(shardId.id(), item.response());
                    }
                    assert (this.expectedOperationsPerItem.get(item.slot()).get() >= 1) : "slot[" + item.slot() + "] can't be lower than one";
                    if (this.expectedOperationsPerItem.get(item.slot()).decrementAndGet() != 0) continue;
                    this.reduce(item.slot());
                }
            }
            catch (Throwable e) {
                TransportMultiPercolateAction.this.logger.error("{} Percolate original reduce error", e, shardId);
                this.finalListener.onFailure(e);
            }
        }

        void onShardFailure(ShardId shardId, Throwable e) {
            TransportMultiPercolateAction.this.logger.debug("{} Shard multi percolate failure", e, shardId);
            try {
                IntArrayList slots = this.shardToSlots.get(shardId);
                for (int i = 0; i < slots.size(); ++i) {
                    int slot = slots.get(i);
                    AtomicReferenceArray shardResults = this.responsesByItemAndShard.get(slot);
                    if (shardResults == null) continue;
                    shardResults.set(shardId.id(), new BroadcastShardOperationFailedException(shardId, e));
                    assert (this.expectedOperationsPerItem.get(slot).get() >= 1) : "slot[" + slot + "] can't be lower than one. Caused by: " + e.getMessage();
                    if (this.expectedOperationsPerItem.get(slot).decrementAndGet() != 0) continue;
                    this.reduce(slot);
                }
            }
            catch (Throwable t) {
                TransportMultiPercolateAction.this.logger.error("{} Percolate original reduce error, original error {}", t, shardId, e);
                this.finalListener.onFailure(t);
            }
        }

        void reduce(int slot) {
            AtomicReferenceArray shardResponses = this.responsesByItemAndShard.get(slot);
            PercolateResponse reducedResponse = TransportPercolateAction.reduce((PercolateRequest)this.percolateRequests.get(slot), shardResponses, TransportMultiPercolateAction.this.percolatorService);
            this.reducedResponses.set(slot, reducedResponse);
            assert (this.expectedOperations.get() >= 1) : "slot[" + slot + "] expected options should be >= 1 but is " + this.expectedOperations.get();
            if (this.expectedOperations.decrementAndGet() == 0) {
                this.finish();
            }
        }

        void finish() {
            MultiPercolateResponse.Item[] finalResponse = new MultiPercolateResponse.Item[this.reducedResponses.length()];
            for (int slot = 0; slot < this.reducedResponses.length(); ++slot) {
                Object element = this.reducedResponses.get(slot);
                assert (element != null) : "Element[" + slot + "] shouldn't be null";
                if (element instanceof PercolateResponse) {
                    finalResponse[slot] = new MultiPercolateResponse.Item((PercolateResponse)element);
                    continue;
                }
                if (element instanceof Throwable) {
                    finalResponse[slot] = new MultiPercolateResponse.Item(ExceptionsHelper.detailedMessage((Throwable)element));
                    continue;
                }
                if (!(element instanceof MultiGetResponse.Failure)) continue;
                finalResponse[slot] = new MultiPercolateResponse.Item(((MultiGetResponse.Failure)element).getMessage());
            }
            this.finalListener.onResponse(new MultiPercolateResponse(finalResponse));
        }
    }
}

