/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.alias.get;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.MasterNodeReadOperationRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class GetAliasesRequest
extends MasterNodeReadOperationRequest<GetAliasesRequest> {
    private String[] indices = Strings.EMPTY_ARRAY;
    private String[] aliases = Strings.EMPTY_ARRAY;
    private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpen();

    public GetAliasesRequest(String[] aliases) {
        this.aliases = aliases;
    }

    public GetAliasesRequest(String alias) {
        this.aliases = new String[]{alias};
    }

    public GetAliasesRequest() {
    }

    public GetAliasesRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    public GetAliasesRequest aliases(String ... aliases) {
        this.aliases = aliases;
        return this;
    }

    public GetAliasesRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    public String[] indices() {
        return this.indices;
    }

    public String[] aliases() {
        return this.aliases;
    }

    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.indices = in.readStringArray();
        this.aliases = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        this.readLocal(in, Version.V_1_0_0_RC2);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.indices);
        out.writeStringArray(this.aliases);
        this.indicesOptions.writeIndicesOptions(out);
        this.writeLocal(out, Version.V_1_0_0_RC2);
    }
}

