/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import org.apache.lucene.store.BufferedIndexOutput;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RateLimiter;
import org.apache.lucene.store.StoreRateLimiting;
import org.apache.lucene.store.StoreUtils;

public final class RateLimitedFSDirectory
extends FilterDirectory {
    private final StoreRateLimiting.Provider rateLimitingProvider;
    private final StoreRateLimiting.Listener rateListener;

    public RateLimitedFSDirectory(FSDirectory wrapped, StoreRateLimiting.Provider rateLimitingProvider, StoreRateLimiting.Listener rateListener) {
        super(wrapped);
        this.rateLimitingProvider = rateLimitingProvider;
        this.rateListener = rateListener;
    }

    @Override
    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        IndexOutput output = this.in.createOutput(name, context);
        StoreRateLimiting rateLimiting = this.rateLimitingProvider.rateLimiting();
        StoreRateLimiting.Type type = rateLimiting.getType();
        RateLimiter limiter = rateLimiting.getRateLimiter();
        if (type == StoreRateLimiting.Type.NONE || limiter == null) {
            return output;
        }
        if (context.context == IOContext.Context.MERGE) {
            return new RateLimitedIndexOutput(limiter, this.rateListener, output);
        }
        if (type == StoreRateLimiting.Type.ALL) {
            return new RateLimitedIndexOutput(limiter, this.rateListener, output);
        }
        return output;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public String toString() {
        StoreRateLimiting rateLimiting = this.rateLimitingProvider.rateLimiting();
        StoreRateLimiting.Type type = rateLimiting.getType();
        RateLimiter limiter = rateLimiting.getRateLimiter();
        if (type == StoreRateLimiting.Type.NONE || limiter == null) {
            return StoreUtils.toString(this.in);
        }
        return "rate_limited(" + StoreUtils.toString(this.in) + ", type=" + type.name() + ", rate=" + limiter.getMbPerSec() + ")";
    }

    static final class RateLimitedIndexOutput
    extends BufferedIndexOutput {
        private final IndexOutput delegate;
        private final BufferedIndexOutput bufferedDelegate;
        private final RateLimiter rateLimiter;
        private final StoreRateLimiting.Listener rateListener;
        private long bytesSinceLastRateLimit;

        RateLimitedIndexOutput(RateLimiter rateLimiter, StoreRateLimiting.Listener rateListener, IndexOutput delegate) {
            super(delegate instanceof BufferedIndexOutput ? ((BufferedIndexOutput)delegate).getBufferSize() : 16384);
            if (delegate instanceof BufferedIndexOutput) {
                this.bufferedDelegate = (BufferedIndexOutput)delegate;
                this.delegate = delegate;
            } else {
                this.delegate = delegate;
                this.bufferedDelegate = null;
            }
            this.rateLimiter = rateLimiter;
            this.rateListener = rateListener;
        }

        @Override
        protected void flushBuffer(byte[] b, int offset, int len) throws IOException {
            this.bytesSinceLastRateLimit += (long)len;
            if (this.bytesSinceLastRateLimit >= this.rateLimiter.getMinPauseCheckBytes()) {
                long pause = this.rateLimiter.pause(this.bytesSinceLastRateLimit);
                this.bytesSinceLastRateLimit = 0L;
                this.rateListener.onPause(pause);
            }
            if (this.bufferedDelegate != null) {
                this.bufferedDelegate.flushBuffer(b, offset, len);
            } else {
                this.delegate.writeBytes(b, offset, len);
            }
        }

        @Override
        public long length() throws IOException {
            return this.delegate.length();
        }

        @Override
        public void seek(long pos) throws IOException {
            this.flush();
            this.delegate.seek(pos);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() throws IOException {
            try {
                super.flush();
            }
            finally {
                this.delegate.flush();
            }
        }

        @Override
        public void setLength(long length) throws IOException {
            this.delegate.setLength(length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                this.delegate.close();
            }
        }
    }
}

