/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.util.zip.Checksum;
import org.apache.lucene.store.BufferedIndexOutput;
import org.apache.lucene.store.IndexOutput;

public class BufferedChecksumIndexOutput
extends BufferedIndexOutput {
    private final IndexOutput delegate;
    private final BufferedIndexOutput bufferedDelegate;
    private final Checksum digest;

    public BufferedChecksumIndexOutput(IndexOutput delegate, Checksum digest) {
        super(delegate instanceof BufferedIndexOutput ? ((BufferedIndexOutput)delegate).getBufferSize() : 16384);
        if (delegate instanceof BufferedIndexOutput) {
            this.bufferedDelegate = (BufferedIndexOutput)delegate;
            this.delegate = delegate;
        } else {
            this.delegate = delegate;
            this.bufferedDelegate = null;
        }
        this.digest = digest;
    }

    public Checksum digest() {
        return this.digest;
    }

    public IndexOutput underlying() {
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            this.delegate.close();
        }
    }

    @Override
    protected void flushBuffer(byte[] b, int offset, int len) throws IOException {
        if (this.bufferedDelegate != null) {
            this.bufferedDelegate.flushBuffer(b, offset, len);
        } else {
            this.delegate.writeBytes(b, offset, len);
        }
        this.digest.update(b, offset, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        try {
            super.flush();
        }
        finally {
            this.delegate.flush();
        }
    }

    @Override
    public void seek(long pos) throws IOException {
        super.seek(pos);
        this.delegate.seek(pos);
    }

    @Override
    public long length() throws IOException {
        return this.delegate.length();
    }

    @Override
    public void setLength(long length) throws IOException {
        this.delegate.setLength(length);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

