/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.memory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.PostingsConsumer;
import org.apache.lucene.codecs.PostingsWriterBase;
import org.apache.lucene.codecs.TermStats;
import org.apache.lucene.codecs.TermsConsumer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.fst.Builder;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.PositiveIntOutputs;
import org.apache.lucene.util.fst.Util;

public class FSTOrdTermsWriter
extends FieldsConsumer {
    static final String TERMS_INDEX_EXTENSION = "tix";
    static final String TERMS_BLOCK_EXTENSION = "tbk";
    static final String TERMS_CODEC_NAME = "FST_ORD_TERMS_DICT";
    public static final int TERMS_VERSION_START = 0;
    public static final int TERMS_VERSION_CHECKSUM = 1;
    public static final int TERMS_VERSION_CURRENT = 1;
    public static final int SKIP_INTERVAL = 8;
    final PostingsWriterBase postingsWriter;
    final FieldInfos fieldInfos;
    final List<FieldMetaData> fields = new ArrayList<FieldMetaData>();
    IndexOutput blockOut = null;
    IndexOutput indexOut = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FSTOrdTermsWriter(SegmentWriteState state, PostingsWriterBase postingsWriter) throws IOException {
        String termsIndexFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, TERMS_INDEX_EXTENSION);
        String termsBlockFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, TERMS_BLOCK_EXTENSION);
        this.postingsWriter = postingsWriter;
        this.fieldInfos = state.fieldInfos;
        boolean success = false;
        try {
            this.indexOut = state.directory.createOutput(termsIndexFileName, state.context);
            this.blockOut = state.directory.createOutput(termsBlockFileName, state.context);
            this.writeHeader(this.indexOut);
            this.writeHeader(this.blockOut);
            this.postingsWriter.init(this.blockOut);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this.indexOut, this.blockOut);
            throw throwable;
        }
    }

    @Override
    public TermsConsumer addField(FieldInfo field) throws IOException {
        return new TermsWriter(field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        block7: {
            block8: {
                block6: {
                    if (this.blockOut == null) break block7;
                    boolean success = false;
                    try {
                        long blockDirStart = this.blockOut.getFilePointer();
                        this.blockOut.writeVInt(this.fields.size());
                        for (FieldMetaData field : this.fields) {
                            this.blockOut.writeVInt(field.fieldInfo.number);
                            this.blockOut.writeVLong(field.numTerms);
                            if (field.fieldInfo.getIndexOptions() != FieldInfo.IndexOptions.DOCS_ONLY) {
                                this.blockOut.writeVLong(field.sumTotalTermFreq);
                            }
                            this.blockOut.writeVLong(field.sumDocFreq);
                            this.blockOut.writeVInt(field.docCount);
                            this.blockOut.writeVInt(field.longsSize);
                            this.blockOut.writeVLong(field.statsOut.getFilePointer());
                            this.blockOut.writeVLong(field.metaLongsOut.getFilePointer());
                            this.blockOut.writeVLong(field.metaBytesOut.getFilePointer());
                            field.skipOut.writeTo(this.blockOut);
                            field.statsOut.writeTo(this.blockOut);
                            field.metaLongsOut.writeTo(this.blockOut);
                            field.metaBytesOut.writeTo(this.blockOut);
                            field.dict.save(this.indexOut);
                        }
                        this.writeTrailer(this.blockOut, blockDirStart);
                        CodecUtil.writeFooter(this.indexOut);
                        CodecUtil.writeFooter(this.blockOut);
                        success = true;
                        if (!success) break block6;
                    }
                    catch (Throwable throwable) {
                        if (success) {
                            IOUtils.close(this.blockOut, this.indexOut, this.postingsWriter);
                        } else {
                            IOUtils.closeWhileHandlingException(this.blockOut, this.indexOut, this.postingsWriter);
                        }
                        this.blockOut = null;
                        throw throwable;
                    }
                    IOUtils.close(this.blockOut, this.indexOut, this.postingsWriter);
                    break block8;
                }
                IOUtils.closeWhileHandlingException(this.blockOut, this.indexOut, this.postingsWriter);
            }
            this.blockOut = null;
        }
    }

    private void writeHeader(IndexOutput out) throws IOException {
        CodecUtil.writeHeader(out, TERMS_CODEC_NAME, 1);
    }

    private void writeTrailer(IndexOutput out, long dirStart) throws IOException {
        out.writeLong(dirStart);
    }

    final class TermsWriter
    extends TermsConsumer {
        private final Builder<Long> builder;
        private final PositiveIntOutputs outputs;
        private final FieldInfo fieldInfo;
        private final int longsSize;
        private long numTerms = 0L;
        private final IntsRef scratchTerm = new IntsRef();
        private final RAMOutputStream statsOut = new RAMOutputStream();
        private final RAMOutputStream metaLongsOut = new RAMOutputStream();
        private final RAMOutputStream metaBytesOut = new RAMOutputStream();
        private final RAMOutputStream skipOut = new RAMOutputStream();
        private long lastBlockStatsFP;
        private long lastBlockMetaLongsFP;
        private long lastBlockMetaBytesFP;
        private long[] lastBlockLongs;
        private long[] lastLongs;
        private long lastMetaBytesFP;

        TermsWriter(FieldInfo fieldInfo) {
            this.fieldInfo = fieldInfo;
            this.longsSize = FSTOrdTermsWriter.this.postingsWriter.setField(fieldInfo);
            this.outputs = PositiveIntOutputs.getSingleton();
            this.builder = new Builder<Long>(FST.INPUT_TYPE.BYTE1, this.outputs);
            this.lastBlockStatsFP = 0L;
            this.lastBlockMetaLongsFP = 0L;
            this.lastBlockMetaBytesFP = 0L;
            this.lastBlockLongs = new long[this.longsSize];
            this.lastLongs = new long[this.longsSize];
            this.lastMetaBytesFP = 0L;
        }

        @Override
        public Comparator<BytesRef> getComparator() {
            return BytesRef.getUTF8SortedAsUnicodeComparator();
        }

        @Override
        public PostingsConsumer startTerm(BytesRef text) throws IOException {
            FSTOrdTermsWriter.this.postingsWriter.startTerm();
            return FSTOrdTermsWriter.this.postingsWriter;
        }

        @Override
        public void finishTerm(BytesRef text, TermStats stats) throws IOException {
            if (this.numTerms > 0L && this.numTerms % 8L == 0L) {
                this.bufferSkip();
            }
            long[] longs = new long[this.longsSize];
            long delta = stats.totalTermFreq - (long)stats.docFreq;
            if (stats.totalTermFreq > 0L) {
                if (delta == 0L) {
                    this.statsOut.writeVInt(stats.docFreq << 1 | 1);
                } else {
                    this.statsOut.writeVInt(stats.docFreq << 1 | 0);
                    this.statsOut.writeVLong(stats.totalTermFreq - (long)stats.docFreq);
                }
            } else {
                this.statsOut.writeVInt(stats.docFreq);
            }
            BlockTermState state = FSTOrdTermsWriter.this.postingsWriter.newTermState();
            state.docFreq = stats.docFreq;
            state.totalTermFreq = stats.totalTermFreq;
            FSTOrdTermsWriter.this.postingsWriter.finishTerm(state);
            FSTOrdTermsWriter.this.postingsWriter.encodeTerm(longs, this.metaBytesOut, this.fieldInfo, state, true);
            for (int i = 0; i < this.longsSize; ++i) {
                this.metaLongsOut.writeVLong(longs[i] - this.lastLongs[i]);
                this.lastLongs[i] = longs[i];
            }
            this.metaLongsOut.writeVLong(this.metaBytesOut.getFilePointer() - this.lastMetaBytesFP);
            this.builder.add(Util.toIntsRef(text, this.scratchTerm), this.numTerms);
            ++this.numTerms;
            this.lastMetaBytesFP = this.metaBytesOut.getFilePointer();
        }

        @Override
        public void finish(long sumTotalTermFreq, long sumDocFreq, int docCount) throws IOException {
            if (this.numTerms > 0L) {
                FieldMetaData metadata = new FieldMetaData();
                metadata.fieldInfo = this.fieldInfo;
                metadata.numTerms = this.numTerms;
                metadata.sumTotalTermFreq = sumTotalTermFreq;
                metadata.sumDocFreq = sumDocFreq;
                metadata.docCount = docCount;
                metadata.longsSize = this.longsSize;
                metadata.skipOut = this.skipOut;
                metadata.statsOut = this.statsOut;
                metadata.metaLongsOut = this.metaLongsOut;
                metadata.metaBytesOut = this.metaBytesOut;
                metadata.dict = this.builder.finish();
                FSTOrdTermsWriter.this.fields.add(metadata);
            }
        }

        private void bufferSkip() throws IOException {
            this.skipOut.writeVLong(this.statsOut.getFilePointer() - this.lastBlockStatsFP);
            this.skipOut.writeVLong(this.metaLongsOut.getFilePointer() - this.lastBlockMetaLongsFP);
            this.skipOut.writeVLong(this.metaBytesOut.getFilePointer() - this.lastBlockMetaBytesFP);
            for (int i = 0; i < this.longsSize; ++i) {
                this.skipOut.writeVLong(this.lastLongs[i] - this.lastBlockLongs[i]);
            }
            this.lastBlockStatsFP = this.statsOut.getFilePointer();
            this.lastBlockMetaLongsFP = this.metaLongsOut.getFilePointer();
            this.lastBlockMetaBytesFP = this.metaBytesOut.getFilePointer();
            System.arraycopy(this.lastLongs, 0, this.lastBlockLongs, 0, this.longsSize);
        }
    }

    private static class FieldMetaData {
        public FieldInfo fieldInfo;
        public long numTerms;
        public long sumTotalTermFreq;
        public long sumDocFreq;
        public int docCount;
        public int longsSize;
        public FST<Long> dict;
        public RAMOutputStream skipOut;
        public RAMOutputStream statsOut;
        public RAMOutputStream metaLongsOut;
        public RAMOutputStream metaBytesOut;

        private FieldMetaData() {
        }
    }
}

