/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.diskdv;

import java.io.IOException;
import org.apache.lucene.codecs.lucene45.Lucene45DocValuesProducer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.packed.MonotonicBlockPackedReader;

class DiskDocValuesProducer
extends Lucene45DocValuesProducer {
    DiskDocValuesProducer(SegmentReadState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        super(state, dataCodec, dataExtension, metaCodec, metaExtension);
    }

    @Override
    protected MonotonicBlockPackedReader getAddressInstance(IndexInput data, FieldInfo field, Lucene45DocValuesProducer.BinaryEntry bytes) throws IOException {
        data.seek(bytes.addressesOffset);
        return new MonotonicBlockPackedReader(data.clone(), bytes.packedIntsVersion, bytes.blockSize, bytes.count, true);
    }

    @Override
    protected MonotonicBlockPackedReader getIntervalInstance(IndexInput data, FieldInfo field, Lucene45DocValuesProducer.BinaryEntry bytes) throws IOException {
        throw new AssertionError();
    }

    @Override
    protected MonotonicBlockPackedReader getOrdIndexInstance(IndexInput data, FieldInfo field, Lucene45DocValuesProducer.NumericEntry entry) throws IOException {
        data.seek(entry.offset);
        return new MonotonicBlockPackedReader(data.clone(), entry.packedIntsVersion, entry.blockSize, entry.count, true);
    }
}

