/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.sort;

import java.util.Map;
import org.apache.lucene.search.SortField;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.function.sort.DoubleFieldsFunctionDataComparator;
import org.elasticsearch.index.field.function.sort.StringFieldsFunctionDataComparator;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.sort.SortParser;

public class ScriptSortParser
implements SortParser {
    @Override
    public String[] names() {
        return new String[]{"_script"};
    }

    @Override
    public SortField parse(XContentParser parser, SearchContext context) throws Exception {
        FieldDataType.ExtendedFieldComparatorSource fieldComparatorSource;
        XContentParser.Token token;
        String script = null;
        String scriptLang = null;
        String type = null;
        Map<String, Object> params = null;
        boolean reverse = false;
        String currentName = parser.currentName();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (!"params".equals(currentName)) continue;
                params = parser.map();
                continue;
            }
            if (!token.isValue()) continue;
            if ("reverse".equals(currentName)) {
                reverse = parser.booleanValue();
                continue;
            }
            if ("order".equals(currentName)) {
                reverse = "desc".equals(parser.text());
                continue;
            }
            if ("script".equals(currentName)) {
                script = parser.text();
                continue;
            }
            if ("type".equals(currentName)) {
                type = parser.text();
                continue;
            }
            if (!"lang".equals(currentName)) continue;
            scriptLang = parser.text();
        }
        if (script == null) {
            throw new SearchParseException(context, "_script sorting requires setting the script to sort by");
        }
        if (type == null) {
            throw new SearchParseException(context, "_script sorting requires setting the type of the script");
        }
        SearchScript searchScript = context.scriptService().search(context.lookup(), scriptLang, script, params);
        if ("string".equals(type)) {
            fieldComparatorSource = StringFieldsFunctionDataComparator.comparatorSource(searchScript);
        } else if ("number".equals(type)) {
            fieldComparatorSource = DoubleFieldsFunctionDataComparator.comparatorSource(searchScript);
        } else {
            throw new SearchParseException(context, "custom script sort type [" + type + "] not supported");
        }
        return new SortField("_script", fieldComparatorSource, reverse);
    }
}

