/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.DeletionAwareConstantScoreQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.lucene.search.function.BoostScoreFunction;
import org.elasticsearch.common.lucene.search.function.FunctionScoreQuery;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.cache.filter.FilterCache;
import org.elasticsearch.index.cache.id.IdCache;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldMappers;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.IndexQueryParserService;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.search.nested.BlockJoinQuery;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.facet.SearchContextFacets;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.partial.PartialFieldsContext;
import org.elasticsearch.search.fetch.script.ScriptFieldsContext;
import org.elasticsearch.search.highlight.SearchContextHighlight;
import org.elasticsearch.search.internal.ContextIndexSearcher;
import org.elasticsearch.search.internal.ScopePhase;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.scan.ScanContext;

public class SearchContext
implements Releasable {
    private static ThreadLocal<SearchContext> current = new ThreadLocal();
    private final long id;
    private final ShardSearchRequest request;
    private final SearchShardTarget shardTarget;
    private SearchType searchType;
    private final Engine.Searcher engineSearcher;
    private final ScriptService scriptService;
    private final IndexShard indexShard;
    private final IndexService indexService;
    private final ContextIndexSearcher searcher;
    private final DfsSearchResult dfsResult;
    private final QuerySearchResult queryResult;
    private final FetchSearchResult fetchResult;
    private ScanContext scanContext;
    private float queryBoost = 1.0f;
    private long timeoutInMillis = -1L;
    private List<String> groupStats;
    private Scroll scroll;
    private boolean explain;
    private boolean version = false;
    private List<String> fieldNames;
    private ScriptFieldsContext scriptFields;
    private PartialFieldsContext partialFields;
    private int from = -1;
    private int size = -1;
    private Sort sort;
    private Float minimumScore;
    private boolean trackScores = false;
    private ParsedQuery originalQuery;
    private Query query;
    private Filter filter;
    private Filter aliasFilter;
    private int[] docIdsToLoad;
    private int docsIdsToLoadFrom;
    private int docsIdsToLoadSize;
    private SearchContextFacets facets;
    private SearchContextHighlight highlight;
    private SearchLookup searchLookup;
    private boolean queryRewritten;
    private volatile long keepAlive;
    private volatile long lastAccessTime;
    private List<ScopePhase> scopePhases = null;
    private Map<String, BlockJoinQuery> nestedQueries;

    public static void setCurrent(SearchContext value) {
        current.set(value);
        QueryParseContext.setTypes(value.types());
    }

    public static void removeCurrent() {
        current.remove();
        QueryParseContext.removeTypes();
    }

    public static SearchContext current() {
        return current.get();
    }

    public SearchContext(long id, ShardSearchRequest request, SearchShardTarget shardTarget, Engine.Searcher engineSearcher, IndexService indexService, IndexShard indexShard, ScriptService scriptService) {
        this.id = id;
        this.request = request;
        this.searchType = request.searchType();
        this.shardTarget = shardTarget;
        this.engineSearcher = engineSearcher;
        this.scriptService = scriptService;
        this.dfsResult = new DfsSearchResult(id, shardTarget);
        this.queryResult = new QuerySearchResult(id, shardTarget);
        this.fetchResult = new FetchSearchResult(id, shardTarget);
        this.indexShard = indexShard;
        this.indexService = indexService;
        this.searcher = new ContextIndexSearcher(this, engineSearcher);
        this.aliasFilter = indexService.aliasesService().aliasFilter(request.filteringAliases());
    }

    @Override
    public boolean release() throws ElasticSearchException {
        if (this.scanContext != null) {
            this.scanContext.clear();
        }
        if (this.scopePhases != null) {
            for (ScopePhase scopePhase : this.scopePhases) {
                scopePhase.clear();
            }
        }
        try {
            this.searcher.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.engineSearcher.release();
        return true;
    }

    public void preProcess() {
        Filter searchFilter;
        if (this.query() == null) {
            this.parsedQuery(ParsedQuery.MATCH_ALL_PARSED_QUERY);
        }
        if (this.queryBoost() != 1.0f) {
            this.parsedQuery(new ParsedQuery((Query)new FunctionScoreQuery(this.query(), new BoostScoreFunction(this.queryBoost)), this.parsedQuery()));
        }
        if ((searchFilter = this.mapperService().searchFilter(this.types())) != null) {
            if (Queries.isConstantMatchAllQuery(this.query())) {
                DeletionAwareConstantScoreQuery q = new DeletionAwareConstantScoreQuery(this.filterCache().cache(searchFilter));
                q.setBoost(this.query().getBoost());
                this.parsedQuery(new ParsedQuery((Query)q, this.parsedQuery()));
            } else {
                this.parsedQuery(new ParsedQuery((Query)new FilteredQuery(this.query(), this.filterCache().cache(searchFilter)), this.parsedQuery()));
            }
        }
    }

    public long id() {
        return this.id;
    }

    public ShardSearchRequest request() {
        return this.request;
    }

    public SearchType searchType() {
        return this.searchType;
    }

    public SearchContext searchType(SearchType searchType) {
        this.searchType = searchType;
        return this;
    }

    public SearchShardTarget shardTarget() {
        return this.shardTarget;
    }

    public int numberOfShards() {
        return this.request.numberOfShards();
    }

    public boolean hasTypes() {
        return this.request.types() != null && this.request.types().length > 0;
    }

    public String[] types() {
        return this.request.types();
    }

    public float queryBoost() {
        return this.queryBoost;
    }

    public SearchContext queryBoost(float queryBoost) {
        this.queryBoost = queryBoost;
        return this;
    }

    public long nowInMillis() {
        return this.request.nowInMillis();
    }

    public Scroll scroll() {
        return this.scroll;
    }

    public SearchContext scroll(Scroll scroll) {
        this.scroll = scroll;
        return this;
    }

    public SearchContextFacets facets() {
        return this.facets;
    }

    public SearchContext facets(SearchContextFacets facets) {
        this.facets = facets;
        return this;
    }

    public SearchContextHighlight highlight() {
        return this.highlight;
    }

    public void highlight(SearchContextHighlight highlight) {
        this.highlight = highlight;
    }

    public boolean hasScriptFields() {
        return this.scriptFields != null;
    }

    public ScriptFieldsContext scriptFields() {
        if (this.scriptFields == null) {
            this.scriptFields = new ScriptFieldsContext();
        }
        return this.scriptFields;
    }

    public boolean hasPartialFields() {
        return this.partialFields != null;
    }

    public PartialFieldsContext partialFields() {
        if (this.partialFields == null) {
            this.partialFields = new PartialFieldsContext();
        }
        return this.partialFields;
    }

    public ContextIndexSearcher searcher() {
        return this.searcher;
    }

    public IndexShard indexShard() {
        return this.indexShard;
    }

    public MapperService mapperService() {
        return this.indexService.mapperService();
    }

    public AnalysisService analysisService() {
        return this.indexService.analysisService();
    }

    public IndexQueryParserService queryParserService() {
        return this.indexService.queryParserService();
    }

    public SimilarityService similarityService() {
        return this.indexService.similarityService();
    }

    public ScriptService scriptService() {
        return this.scriptService;
    }

    public FilterCache filterCache() {
        return this.indexService.cache().filter();
    }

    public FieldDataCache fieldDataCache() {
        return this.indexService.cache().fieldData();
    }

    public IdCache idCache() {
        return this.indexService.cache().idCache();
    }

    public long timeoutInMillis() {
        return this.timeoutInMillis;
    }

    public void timeoutInMillis(long timeoutInMillis) {
        this.timeoutInMillis = timeoutInMillis;
    }

    public SearchContext minimumScore(float minimumScore) {
        this.minimumScore = Float.valueOf(minimumScore);
        return this;
    }

    public Float minimumScore() {
        return this.minimumScore;
    }

    public SearchContext sort(Sort sort) {
        this.sort = sort;
        return this;
    }

    public Sort sort() {
        return this.sort;
    }

    public SearchContext trackScores(boolean trackScores) {
        this.trackScores = trackScores;
        return this;
    }

    public boolean trackScores() {
        return this.trackScores;
    }

    public SearchContext parsedFilter(Filter filter) {
        this.filter = filter;
        return this;
    }

    public Filter parsedFilter() {
        return this.filter;
    }

    public Filter aliasFilter() {
        return this.aliasFilter;
    }

    public SearchContext parsedQuery(ParsedQuery query) {
        this.queryRewritten = false;
        this.originalQuery = query;
        this.query = query.query();
        return this;
    }

    public ParsedQuery parsedQuery() {
        return this.originalQuery;
    }

    public Query query() {
        return this.query;
    }

    public boolean queryRewritten() {
        return this.queryRewritten;
    }

    public SearchContext updateRewriteQuery(Query rewriteQuery) {
        this.query = rewriteQuery;
        this.queryRewritten = true;
        return this;
    }

    public int from() {
        return this.from;
    }

    public SearchContext from(int from) {
        this.from = from;
        return this;
    }

    public int size() {
        return this.size;
    }

    public SearchContext size(int size) {
        this.size = size;
        return this;
    }

    public boolean hasFieldNames() {
        return this.fieldNames != null;
    }

    public List<String> fieldNames() {
        if (this.fieldNames == null) {
            this.fieldNames = Lists.newArrayList();
        }
        return this.fieldNames;
    }

    public void emptyFieldNames() {
        this.fieldNames = ImmutableList.of();
    }

    public boolean explain() {
        return this.explain;
    }

    public void explain(boolean explain) {
        this.explain = explain;
    }

    @Nullable
    public List<String> groupStats() {
        return this.groupStats;
    }

    public void groupStats(List<String> groupStats) {
        this.groupStats = groupStats;
    }

    public boolean version() {
        return this.version;
    }

    public void version(boolean version) {
        this.version = version;
    }

    public int[] docIdsToLoad() {
        return this.docIdsToLoad;
    }

    public int docIdsToLoadFrom() {
        return this.docsIdsToLoadFrom;
    }

    public int docIdsToLoadSize() {
        return this.docsIdsToLoadSize;
    }

    public SearchContext docIdsToLoad(int[] docIdsToLoad, int docsIdsToLoadFrom, int docsIdsToLoadSize) {
        this.docIdsToLoad = docIdsToLoad;
        this.docsIdsToLoadFrom = docsIdsToLoadFrom;
        this.docsIdsToLoadSize = docsIdsToLoadSize;
        return this;
    }

    public void accessed(long accessTime) {
        this.lastAccessTime = accessTime;
    }

    public long lastAccessTime() {
        return this.lastAccessTime;
    }

    public long keepAlive() {
        return this.keepAlive;
    }

    public void keepAlive(long keepAlive) {
        this.keepAlive = keepAlive;
    }

    public SearchLookup lookup() {
        if (this.searchLookup == null) {
            this.searchLookup = new SearchLookup(this.mapperService(), this.fieldDataCache(), this.request.types());
        }
        return this.searchLookup;
    }

    public DfsSearchResult dfsResult() {
        return this.dfsResult;
    }

    public QuerySearchResult queryResult() {
        return this.queryResult;
    }

    public FetchSearchResult fetchResult() {
        return this.fetchResult;
    }

    public List<ScopePhase> scopePhases() {
        return this.scopePhases;
    }

    public void addScopePhase(ScopePhase scopePhase) {
        if (this.scopePhases == null) {
            this.scopePhases = new ArrayList<ScopePhase>();
        }
        this.scopePhases.add(scopePhase);
    }

    public Map<String, BlockJoinQuery> nestedQueries() {
        return this.nestedQueries;
    }

    public void addNestedQuery(String scope, BlockJoinQuery query) {
        if (this.nestedQueries == null) {
            this.nestedQueries = new HashMap<String, BlockJoinQuery>();
        }
        this.nestedQueries.put(scope, query);
    }

    public ScanContext scanContext() {
        if (this.scanContext == null) {
            this.scanContext = new ScanContext();
        }
        return this.scanContext;
    }

    public MapperService.SmartNameFieldMappers smartFieldMappers(String name) {
        return this.mapperService().smartName(name, this.request.types());
    }

    public FieldMappers smartNameFieldMappers(String name) {
        return this.mapperService().smartNameFieldMappers(name, this.request.types());
    }

    public FieldMapper smartNameFieldMapper(String name) {
        return this.mapperService().smartNameFieldMapper(name, this.request.types());
    }

    public MapperService.SmartNameObjectMapper smartNameObjectMapper(String name) {
        return this.mapperService().smartNameObjectMapper(name, this.request.types());
    }
}

