/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.histogram.bounded;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.NumericFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.facet.AbstractFacetCollector;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.FacetPhaseExecutionException;
import org.elasticsearch.search.facet.histogram.HistogramFacet;
import org.elasticsearch.search.facet.histogram.bounded.InternalBoundedFullHistogramFacet;
import org.elasticsearch.search.internal.SearchContext;

public class BoundedValueScriptHistogramFacetCollector
extends AbstractFacetCollector {
    private final String indexFieldName;
    private final HistogramFacet.ComparatorType comparatorType;
    private final FieldDataCache fieldDataCache;
    private final FieldDataType fieldDataType;
    private NumericFieldData fieldData;
    private final SearchScript valueScript;
    private final HistogramProc histoProc;

    public BoundedValueScriptHistogramFacetCollector(String facetName, String fieldName, String scriptLang, String valueScript, Map<String, Object> params, long interval, long from, long to, HistogramFacet.ComparatorType comparatorType, SearchContext context) {
        super(facetName);
        this.comparatorType = comparatorType;
        this.fieldDataCache = context.fieldDataCache();
        MapperService.SmartNameFieldMappers smartMappers = context.smartFieldMappers(fieldName);
        if (smartMappers == null || !smartMappers.hasMapper()) {
            throw new FacetPhaseExecutionException(facetName, "No mapping found for field [" + fieldName + "]");
        }
        if (smartMappers.explicitTypeInNameWithDocMapper()) {
            this.setFilter(context.filterCache().cache(smartMappers.docMapper().typeFilter()));
        }
        this.valueScript = context.scriptService().search(context.lookup(), scriptLang, valueScript, params);
        FieldMapper mapper = smartMappers.mapper();
        this.indexFieldName = mapper.names().indexName();
        this.fieldDataType = mapper.fieldDataType();
        long normalizedFrom = (long)((double)from / (double)interval) * interval;
        long normalizedTo = (long)((double)to / (double)interval) * interval;
        if (to % interval != 0L) {
            normalizedTo += interval;
        }
        long offset = -normalizedFrom;
        int size = (int)((normalizedTo - normalizedFrom) / interval);
        this.histoProc = new HistogramProc(from, to, interval, offset, size, this.valueScript);
    }

    @Override
    protected void doCollect(int doc) throws IOException {
        this.fieldData.forEachValueInDoc(doc, this.histoProc);
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        this.valueScript.setScorer(scorer);
    }

    @Override
    protected void doSetNextReader(IndexReader reader, int docBase) throws IOException {
        this.fieldData = (NumericFieldData)this.fieldDataCache.cache(this.fieldDataType, reader, this.indexFieldName);
        this.valueScript.setNextReader(reader);
    }

    @Override
    public Facet facet() {
        return new InternalBoundedFullHistogramFacet(this.facetName, this.comparatorType, this.histoProc.interval, -this.histoProc.offset, this.histoProc.size, this.histoProc.entries, true);
    }

    public static long bucket(double value, long interval) {
        return (long)(value / (double)interval) * interval;
    }

    public static class HistogramProc
    implements NumericFieldData.LongValueInDocProc {
        final long from;
        final long to;
        final long interval;
        final long offset;
        final int size;
        final Object[] entries;
        private final SearchScript valueScript;

        public HistogramProc(long from, long to, long interval, long offset, int size, SearchScript valueScript) {
            this.from = from;
            this.to = to;
            this.interval = interval;
            this.offset = offset;
            this.size = size;
            this.entries = CacheRecycler.popObjectArray(size);
            this.valueScript = valueScript;
        }

        @Override
        public void onValue(int docId, long value) {
            if (value <= this.from || value > this.to) {
                return;
            }
            int index = (int)((value + this.offset) / this.interval);
            this.valueScript.setNextDocId(docId);
            double scriptValue = this.valueScript.runAsDouble();
            InternalBoundedFullHistogramFacet.FullEntry entry = (InternalBoundedFullHistogramFacet.FullEntry)this.entries[index];
            if (entry == null) {
                this.entries[index] = new InternalBoundedFullHistogramFacet.FullEntry(index, 1L, scriptValue, scriptValue, 1L, scriptValue);
            } else {
                ++entry.count;
                ++entry.totalCount;
                entry.total += scriptValue;
                if (scriptValue < entry.min) {
                    entry.min = scriptValue;
                }
                if (scriptValue > entry.max) {
                    entry.max = scriptValue;
                }
            }
        }
    }
}

