/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.SpawnModules;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.TransportSearchModule;
import org.elasticsearch.search.action.SearchServiceTransportAction;
import org.elasticsearch.search.controller.SearchPhaseController;
import org.elasticsearch.search.dfs.DfsPhase;
import org.elasticsearch.search.facet.FacetModule;
import org.elasticsearch.search.fetch.FetchPhase;
import org.elasticsearch.search.fetch.explain.ExplainFetchSubPhase;
import org.elasticsearch.search.fetch.matchedfilters.MatchedFiltersFetchSubPhase;
import org.elasticsearch.search.fetch.partial.PartialFieldsFetchSubPhase;
import org.elasticsearch.search.fetch.script.ScriptFieldsFetchSubPhase;
import org.elasticsearch.search.fetch.version.VersionFetchSubPhase;
import org.elasticsearch.search.highlight.HighlightPhase;
import org.elasticsearch.search.query.QueryPhase;

public class SearchModule
extends AbstractModule
implements SpawnModules {
    @Override
    public Iterable<? extends Module> spawnModules() {
        return ImmutableList.of(new TransportSearchModule(), new FacetModule());
    }

    @Override
    protected void configure() {
        this.bind(DfsPhase.class).asEagerSingleton();
        this.bind(QueryPhase.class).asEagerSingleton();
        this.bind(SearchService.class).asEagerSingleton();
        this.bind(SearchPhaseController.class).asEagerSingleton();
        this.bind(FetchPhase.class).asEagerSingleton();
        this.bind(ExplainFetchSubPhase.class).asEagerSingleton();
        this.bind(ScriptFieldsFetchSubPhase.class).asEagerSingleton();
        this.bind(PartialFieldsFetchSubPhase.class).asEagerSingleton();
        this.bind(VersionFetchSubPhase.class).asEagerSingleton();
        this.bind(MatchedFiltersFetchSubPhase.class).asEagerSingleton();
        this.bind(HighlightPhase.class).asEagerSingleton();
        this.bind(SearchServiceTransportAction.class).asEagerSingleton();
    }
}

