/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.jvm;

import java.io.IOException;
import java.io.Serializable;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.monitor.jvm.JvmInfo;

public class JvmStats
implements Streamable,
Serializable,
ToXContent {
    private static boolean enableLastGc;
    private static final RuntimeMXBean runtimeMXBean;
    private static final MemoryMXBean memoryMXBean;
    private static final ThreadMXBean threadMXBean;
    private static Method managementFactoryPlatformMXBeansMethod;
    private static Method getLastGcInfoMethod;
    private static Method getMemoryUsageBeforeGcMethod;
    private static Method getMemoryUsageAfterGcMethod;
    private static Method getStartTimeMethod;
    private static Method getEndTimeMethod;
    private static Method getDurationMethod;
    private static boolean bufferPoolsEnabled;
    private static Class bufferPoolMXBeanClass;
    private static Method bufferPoolMXBeanNameMethod;
    private static Method bufferPoolMXBeanCountMethod;
    private static Method bufferPoolMXBeanTotalCapacityMethod;
    private static Method bufferPoolMXBeanMemoryUsedMethod;
    long timestamp = -1L;
    long uptime;
    Mem mem;
    Threads threads;
    GarbageCollectors gc;
    List<BufferPool> bufferPools;

    public static boolean isLastGcEnabled() {
        return enableLastGc;
    }

    public static JvmStats jvmStats() {
        JvmStats stats = new JvmStats(System.currentTimeMillis(), runtimeMXBean.getUptime());
        stats.mem = new Mem();
        MemoryUsage memUsage = memoryMXBean.getHeapMemoryUsage();
        stats.mem.heapUsed = memUsage.getUsed() < 0L ? 0L : memUsage.getUsed();
        stats.mem.heapCommitted = memUsage.getCommitted() < 0L ? 0L : memUsage.getCommitted();
        memUsage = memoryMXBean.getNonHeapMemoryUsage();
        stats.mem.nonHeapUsed = memUsage.getUsed() < 0L ? 0L : memUsage.getUsed();
        stats.mem.nonHeapCommitted = memUsage.getCommitted() < 0L ? 0L : memUsage.getCommitted();
        List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
        stats.mem.pools = new MemoryPool[memoryPoolMXBeans.size()];
        for (int i = 0; i < memoryPoolMXBeans.size(); ++i) {
            MemoryPoolMXBean memoryPoolMXBean = memoryPoolMXBeans.get(i);
            MemoryUsage usage = memoryPoolMXBean.getUsage();
            MemoryUsage peakUsage = memoryPoolMXBean.getPeakUsage();
            stats.mem.pools[i] = new MemoryPool(memoryPoolMXBean.getName(), usage.getUsed() < 0L ? 0L : usage.getUsed(), usage.getMax() < 0L ? 0L : usage.getMax(), peakUsage.getUsed() < 0L ? 0L : peakUsage.getUsed(), peakUsage.getMax() < 0L ? 0L : peakUsage.getMax());
        }
        stats.threads = new Threads();
        stats.threads.count = threadMXBean.getThreadCount();
        stats.threads.peakCount = threadMXBean.getPeakThreadCount();
        List<GarbageCollectorMXBean> gcMxBeans = ManagementFactory.getGarbageCollectorMXBeans();
        stats.gc = new GarbageCollectors();
        stats.gc.collectors = new GarbageCollector[gcMxBeans.size()];
        for (int i = 0; i < stats.gc.collectors.length; ++i) {
            GarbageCollectorMXBean gcMxBean = gcMxBeans.get(i);
            stats.gc.collectors[i] = new GarbageCollector();
            stats.gc.collectors[i].name = gcMxBean.getName();
            stats.gc.collectors[i].collectionCount = gcMxBean.getCollectionCount();
            stats.gc.collectors[i].collectionTime = gcMxBean.getCollectionTime();
            if (!enableLastGc) continue;
            try {
                Object lastGcInfo = getLastGcInfoMethod.invoke((Object)gcMxBean, new Object[0]);
                if (lastGcInfo == null) continue;
                Map usageBeforeGc = (Map)getMemoryUsageBeforeGcMethod.invoke(lastGcInfo, new Object[0]);
                Map usageAfterGc = (Map)getMemoryUsageAfterGcMethod.invoke(lastGcInfo, new Object[0]);
                long startTime = (Long)getStartTimeMethod.invoke(lastGcInfo, new Object[0]);
                long endTime = (Long)getEndTimeMethod.invoke(lastGcInfo, new Object[0]);
                long duration = (Long)getDurationMethod.invoke(lastGcInfo, new Object[0]);
                long previousMemoryUsed = 0L;
                long memoryUsed = 0L;
                long memoryMax = 0L;
                for (Map.Entry entry : usageBeforeGc.entrySet()) {
                    previousMemoryUsed += ((MemoryUsage)entry.getValue()).getUsed();
                }
                for (Map.Entry entry : usageAfterGc.entrySet()) {
                    MemoryUsage mu = (MemoryUsage)entry.getValue();
                    memoryUsed += mu.getUsed();
                    memoryMax += mu.getMax();
                }
                stats.gc.collectors[i].lastGc = new GarbageCollector.LastGc(startTime, endTime, memoryMax, previousMemoryUsed, memoryUsed, duration);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (bufferPoolsEnabled) {
            try {
                List bufferPools = (List)managementFactoryPlatformMXBeansMethod.invoke(null, bufferPoolMXBeanClass);
                stats.bufferPools = new ArrayList<BufferPool>(bufferPools.size());
                for (Object bufferPool : bufferPools) {
                    String name = (String)bufferPoolMXBeanNameMethod.invoke(bufferPool, new Object[0]);
                    Long count = (Long)bufferPoolMXBeanCountMethod.invoke(bufferPool, new Object[0]);
                    Long totalCapacity = (Long)bufferPoolMXBeanTotalCapacityMethod.invoke(bufferPool, new Object[0]);
                    Long memoryUsed = (Long)bufferPoolMXBeanMemoryUsedMethod.invoke(bufferPool, new Object[0]);
                    stats.bufferPools.add(new BufferPool(name, count, totalCapacity, memoryUsed));
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return stats;
    }

    private JvmStats() {
    }

    public JvmStats(long timestamp, long uptime) {
        this.timestamp = timestamp;
        this.uptime = uptime;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public TimeValue uptime() {
        return new TimeValue(this.uptime);
    }

    public TimeValue getUptime() {
        return this.uptime();
    }

    public Mem mem() {
        return this.mem;
    }

    public Mem getMem() {
        return this.mem();
    }

    public Threads threads() {
        return this.threads;
    }

    public Threads getThreads() {
        return this.threads();
    }

    public GarbageCollectors gc() {
        return this.gc;
    }

    public GarbageCollectors getGc() {
        return this.gc();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.JVM);
        builder.field(Fields.TIMESTAMP, this.timestamp);
        builder.field(Fields.UPTIME, this.uptime().format());
        builder.field(Fields.UPTIME_IN_MILLIS, this.uptime().millis());
        if (this.mem != null) {
            builder.startObject(Fields.MEM);
            builder.field(Fields.HEAP_USED, this.mem.heapUsed().toString());
            builder.field(Fields.HEAP_USED_IN_BYTES, this.mem.heapUsed().bytes());
            builder.field(Fields.HEAP_COMMITTED, this.mem.heapCommitted().toString());
            builder.field(Fields.HEAP_COMMITTED_IN_BYTES, this.mem.heapCommitted().bytes());
            builder.field(Fields.NON_HEAP_USED, this.mem.nonHeapUsed().toString());
            builder.field(Fields.NON_HEAP_USED_IN_BYTES, this.mem.nonHeapUsed);
            builder.field(Fields.NON_HEAP_COMMITTED, this.mem.nonHeapCommitted().toString());
            builder.field(Fields.NON_HEAP_COMMITTED_IN_BYTES, this.mem.nonHeapCommitted);
            builder.startObject(Fields.POOLS);
            for (MemoryPool pool : this.mem) {
                builder.startObject(pool.name(), XContentBuilder.FieldCaseConversion.NONE);
                builder.field(Fields.USED, pool.used().toString());
                builder.field(Fields.USED_IN_BYTES, pool.used);
                builder.field(Fields.MAX, pool.max().toString());
                builder.field(Fields.MAX_IN_BYTES, pool.max);
                builder.field(Fields.PEAK_USED, pool.peakUsed().toString());
                builder.field(Fields.PEAK_USED_IN_BYTES, pool.peakUsed);
                builder.field(Fields.PEAK_MAX, pool.peakMax().toString());
                builder.field(Fields.PEAK_MAX_IN_BYTES, pool.peakMax);
                builder.endObject();
            }
            builder.endObject();
            builder.endObject();
        }
        if (this.threads != null) {
            builder.startObject(Fields.THREADS);
            builder.field(Fields.COUNT, this.threads.count());
            builder.field(Fields.PEAK_COUNT, this.threads.peakCount());
            builder.endObject();
        }
        if (this.gc != null) {
            builder.startObject(Fields.GC);
            builder.field(Fields.COLLECTION_COUNT, this.gc.collectionCount());
            builder.field(Fields.COLLECTION_TIME, this.gc.collectionTime().format());
            builder.field(Fields.COLLECTION_TIME_IN_MILLIS, this.gc.collectionTime().millis());
            builder.startObject(Fields.COLLECTORS);
            for (GarbageCollector collector : this.gc) {
                builder.startObject(collector.name(), XContentBuilder.FieldCaseConversion.NONE);
                builder.field(Fields.COLLECTION_COUNT, collector.collectionCount());
                builder.field(Fields.COLLECTION_TIME, collector.collectionTime().format());
                builder.field(Fields.COLLECTION_TIME_IN_MILLIS, collector.collectionTime().millis());
                builder.endObject();
            }
            builder.endObject();
            builder.endObject();
        }
        if (this.bufferPools != null) {
            builder.startObject(Fields.BUFFER_POOLS);
            for (BufferPool bufferPool : this.bufferPools) {
                builder.startObject(bufferPool.name(), XContentBuilder.FieldCaseConversion.NONE);
                builder.field(Fields.COUNT, bufferPool.count());
                builder.field(Fields.USED, bufferPool.used().toString());
                builder.field(Fields.USED_IN_BYTES, bufferPool.used);
                builder.field(Fields.TOTAL_CAPACITY, bufferPool.totalCapacity().toString());
                builder.field(Fields.TOTAL_CAPACITY_IN_BYTES, bufferPool.totalCapacity);
                builder.endObject();
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public static JvmStats readJvmStats(StreamInput in) throws IOException {
        JvmStats jvmStats = new JvmStats();
        jvmStats.readFrom(in);
        return jvmStats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.timestamp = in.readVLong();
        this.uptime = in.readVLong();
        this.mem = Mem.readMem(in);
        this.threads = Threads.readThreads(in);
        this.gc = GarbageCollectors.readGarbageCollectors(in);
        if (in.readBoolean()) {
            int size = in.readVInt();
            this.bufferPools = new ArrayList<BufferPool>(size);
            for (int i = 0; i < size; ++i) {
                BufferPool bufferPool = new BufferPool();
                bufferPool.readFrom(in);
                this.bufferPools.add(bufferPool);
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.timestamp);
        out.writeVLong(this.uptime);
        this.mem.writeTo(out);
        this.threads.writeTo(out);
        this.gc.writeTo(out);
        if (this.bufferPools == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeVInt(this.bufferPools.size());
            for (BufferPool bufferPool : this.bufferPools) {
                bufferPool.writeTo(out);
            }
        }
    }

    static {
        runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        memoryMXBean = ManagementFactory.getMemoryMXBean();
        threadMXBean = ManagementFactory.getThreadMXBean();
        try {
            managementFactoryPlatformMXBeansMethod = ManagementFactory.class.getMethod("getPlatformMXBeans", Class.class);
        }
        catch (Throwable e) {
            managementFactoryPlatformMXBeansMethod = null;
        }
        try {
            bufferPoolMXBeanClass = Class.forName("java.lang.management.BufferPoolMXBean");
            bufferPoolMXBeanNameMethod = bufferPoolMXBeanClass.getMethod("getName", new Class[0]);
            bufferPoolMXBeanCountMethod = bufferPoolMXBeanClass.getMethod("getCount", new Class[0]);
            bufferPoolMXBeanTotalCapacityMethod = bufferPoolMXBeanClass.getMethod("getTotalCapacity", new Class[0]);
            bufferPoolMXBeanMemoryUsedMethod = bufferPoolMXBeanClass.getMethod("getMemoryUsed", new Class[0]);
            bufferPoolsEnabled = true;
        }
        catch (Throwable t) {
            bufferPoolsEnabled = false;
        }
        JvmInfo info = JvmInfo.jvmInfo();
        boolean defaultEnableLastGc = false;
        if (info.versionAsInteger() == 170) {
            defaultEnableLastGc = info.versionUpdatePack() >= 4;
        } else if (info.versionAsInteger() > 170) {
            defaultEnableLastGc = true;
        }
        defaultEnableLastGc = false;
        boolean enableLastGc = Booleans.parseBoolean(System.getProperty("monitor.jvm.enable_last_gc"), defaultEnableLastGc);
        if (enableLastGc) {
            try {
                Class<?> sunGcClass = Class.forName("com.sun.management.GarbageCollectorMXBean");
                Class<?> gcInfoClass = Class.forName("com.sun.management.GcInfo");
                getLastGcInfoMethod = sunGcClass.getDeclaredMethod("getLastGcInfo", new Class[0]);
                getLastGcInfoMethod.setAccessible(true);
                getMemoryUsageBeforeGcMethod = gcInfoClass.getDeclaredMethod("getMemoryUsageBeforeGc", new Class[0]);
                getMemoryUsageBeforeGcMethod.setAccessible(true);
                getMemoryUsageAfterGcMethod = gcInfoClass.getDeclaredMethod("getMemoryUsageAfterGc", new Class[0]);
                getMemoryUsageAfterGcMethod.setAccessible(true);
                getStartTimeMethod = gcInfoClass.getDeclaredMethod("getStartTime", new Class[0]);
                getStartTimeMethod.setAccessible(true);
                getEndTimeMethod = gcInfoClass.getDeclaredMethod("getEndTime", new Class[0]);
                getEndTimeMethod.setAccessible(true);
                getDurationMethod = gcInfoClass.getDeclaredMethod("getDuration", new Class[0]);
                getDurationMethod.setAccessible(true);
            }
            catch (Throwable ex) {
                enableLastGc = false;
            }
        }
        JvmStats.enableLastGc = enableLastGc;
    }

    public static class BufferPool
    implements Streamable {
        String name;
        long count;
        long totalCapacity;
        long used;

        BufferPool() {
        }

        public BufferPool(String name, long count, long totalCapacity, long used) {
            this.name = name;
            this.count = count;
            this.totalCapacity = totalCapacity;
            this.used = used;
        }

        public String name() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public long count() {
            return this.count;
        }

        public long getCount() {
            return this.count;
        }

        public ByteSizeValue totalCapacity() {
            return new ByteSizeValue(this.totalCapacity);
        }

        public ByteSizeValue getTotalCapacity() {
            return this.totalCapacity();
        }

        public ByteSizeValue used() {
            return new ByteSizeValue(this.used);
        }

        public ByteSizeValue getUsed() {
            return this.used();
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.name = in.readString();
            this.count = in.readLong();
            this.totalCapacity = in.readLong();
            this.used = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.name);
            out.writeLong(this.count);
            out.writeLong(this.totalCapacity);
            out.writeLong(this.used);
        }
    }

    public static class Mem
    implements Streamable,
    Serializable,
    Iterable<MemoryPool> {
        long heapCommitted;
        long heapUsed;
        long nonHeapCommitted;
        long nonHeapUsed;
        MemoryPool[] pools = new MemoryPool[0];

        Mem() {
        }

        public static Mem readMem(StreamInput in) throws IOException {
            Mem mem = new Mem();
            mem.readFrom(in);
            return mem;
        }

        @Override
        public Iterator<MemoryPool> iterator() {
            return Iterators.forArray(this.pools);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.heapCommitted = in.readVLong();
            this.heapUsed = in.readVLong();
            this.nonHeapCommitted = in.readVLong();
            this.nonHeapUsed = in.readVLong();
            this.pools = new MemoryPool[in.readVInt()];
            for (int i = 0; i < this.pools.length; ++i) {
                this.pools[i] = MemoryPool.readMemoryPool(in);
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.heapCommitted);
            out.writeVLong(this.heapUsed);
            out.writeVLong(this.nonHeapCommitted);
            out.writeVLong(this.nonHeapUsed);
            out.writeVInt(this.pools.length);
            for (MemoryPool pool : this.pools) {
                pool.writeTo(out);
            }
        }

        public ByteSizeValue heapCommitted() {
            return new ByteSizeValue(this.heapCommitted);
        }

        public ByteSizeValue getHeapCommitted() {
            return this.heapCommitted();
        }

        public ByteSizeValue heapUsed() {
            return new ByteSizeValue(this.heapUsed);
        }

        public ByteSizeValue getHeapUsed() {
            return this.heapUsed();
        }

        public ByteSizeValue nonHeapCommitted() {
            return new ByteSizeValue(this.nonHeapCommitted);
        }

        public ByteSizeValue getNonHeapCommitted() {
            return this.nonHeapCommitted();
        }

        public ByteSizeValue nonHeapUsed() {
            return new ByteSizeValue(this.nonHeapUsed);
        }

        public ByteSizeValue getNonHeapUsed() {
            return this.nonHeapUsed();
        }
    }

    public static class MemoryPool
    implements Streamable,
    Serializable {
        String name;
        long used;
        long max;
        long peakUsed;
        long peakMax;

        MemoryPool() {
        }

        public MemoryPool(String name, long used, long max, long peakUsed, long peakMax) {
            this.name = name;
            this.used = used;
            this.max = max;
            this.peakUsed = peakUsed;
            this.peakMax = peakMax;
        }

        public static MemoryPool readMemoryPool(StreamInput in) throws IOException {
            MemoryPool pool = new MemoryPool();
            pool.readFrom(in);
            return pool;
        }

        public String name() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public ByteSizeValue used() {
            return new ByteSizeValue(this.used);
        }

        public ByteSizeValue getUsed() {
            return this.used();
        }

        public ByteSizeValue max() {
            return new ByteSizeValue(this.max);
        }

        public ByteSizeValue getMax() {
            return this.max();
        }

        public ByteSizeValue peakUsed() {
            return new ByteSizeValue(this.peakUsed);
        }

        public ByteSizeValue getPeakUsed() {
            return this.peakUsed();
        }

        public ByteSizeValue peakMax() {
            return new ByteSizeValue(this.peakMax);
        }

        public ByteSizeValue getPeakMax() {
            return this.peakMax();
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.name = in.readUTF();
            this.used = in.readVLong();
            this.max = in.readVLong();
            this.peakUsed = in.readVLong();
            this.peakMax = in.readVLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeUTF(this.name);
            out.writeVLong(this.used);
            out.writeVLong(this.max);
            out.writeVLong(this.peakUsed);
            out.writeVLong(this.peakMax);
        }
    }

    public static class Threads
    implements Streamable,
    Serializable {
        int count;
        int peakCount;

        Threads() {
        }

        public int count() {
            return this.count;
        }

        public int getCount() {
            return this.count();
        }

        public int peakCount() {
            return this.peakCount;
        }

        public int getPeakCount() {
            return this.peakCount();
        }

        public static Threads readThreads(StreamInput in) throws IOException {
            Threads threads = new Threads();
            threads.readFrom(in);
            return threads;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.count = in.readVInt();
            this.peakCount = in.readVInt();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.count);
            out.writeVInt(this.peakCount);
        }
    }

    public static class GarbageCollector
    implements Streamable,
    Serializable {
        String name;
        long collectionCount;
        long collectionTime;
        LastGc lastGc;

        GarbageCollector() {
        }

        public static GarbageCollector readGarbageCollector(StreamInput in) throws IOException {
            GarbageCollector gc = new GarbageCollector();
            gc.readFrom(in);
            return gc;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.name = in.readUTF();
            this.collectionCount = in.readVLong();
            this.collectionTime = in.readVLong();
            if (in.readBoolean()) {
                this.lastGc = LastGc.readLastGc(in);
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeUTF(this.name);
            out.writeVLong(this.collectionCount);
            out.writeVLong(this.collectionTime);
            if (this.lastGc == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                this.lastGc.writeTo(out);
            }
        }

        public String name() {
            return this.name;
        }

        public String getName() {
            return this.name();
        }

        public long collectionCount() {
            return this.collectionCount;
        }

        public long getCollectionCount() {
            return this.collectionCount();
        }

        public TimeValue collectionTime() {
            return new TimeValue(this.collectionTime, TimeUnit.MILLISECONDS);
        }

        public TimeValue getCollectionTime() {
            return this.collectionTime();
        }

        public LastGc lastGc() {
            return this.lastGc;
        }

        public LastGc getLastGc() {
            return this.lastGc();
        }

        public static class LastGc
        implements Streamable {
            long startTime;
            long endTime;
            long max;
            long beforeUsed;
            long afterUsed;
            long duration;

            LastGc() {
            }

            public LastGc(long startTime, long endTime, long max, long beforeUsed, long afterUsed, long duration) {
                this.startTime = startTime;
                this.endTime = endTime;
                this.max = max;
                this.beforeUsed = beforeUsed;
                this.afterUsed = afterUsed;
                this.duration = duration;
            }

            public long startTime() {
                return this.startTime;
            }

            public long getStartTime() {
                return this.startTime();
            }

            public long endTime() {
                return this.endTime;
            }

            public long getEndTime() {
                return this.endTime();
            }

            public ByteSizeValue max() {
                return new ByteSizeValue(this.max);
            }

            public ByteSizeValue getMax() {
                return this.max();
            }

            public ByteSizeValue afterUsed() {
                return new ByteSizeValue(this.afterUsed);
            }

            public ByteSizeValue getAfterUsed() {
                return this.afterUsed();
            }

            public ByteSizeValue beforeUsed() {
                return new ByteSizeValue(this.beforeUsed);
            }

            public ByteSizeValue getBeforeUsed() {
                return this.beforeUsed();
            }

            public ByteSizeValue reclaimed() {
                return new ByteSizeValue(this.beforeUsed - this.afterUsed);
            }

            public ByteSizeValue getReclaimed() {
                return this.reclaimed();
            }

            public TimeValue duration() {
                return new TimeValue(this.duration);
            }

            public TimeValue getDuration() {
                return this.duration();
            }

            public static LastGc readLastGc(StreamInput in) throws IOException {
                LastGc lastGc = new LastGc();
                lastGc.readFrom(in);
                return lastGc;
            }

            @Override
            public void readFrom(StreamInput in) throws IOException {
                this.startTime = in.readVLong();
                this.endTime = in.readVLong();
                this.max = in.readVLong();
                this.beforeUsed = in.readVLong();
                this.afterUsed = in.readVLong();
                this.duration = in.readVLong();
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                out.writeVLong(this.startTime);
                out.writeVLong(this.endTime);
                out.writeVLong(this.max);
                out.writeVLong(this.beforeUsed);
                out.writeVLong(this.afterUsed);
                out.writeVLong(this.duration);
            }
        }
    }

    public static class GarbageCollectors
    implements Streamable,
    Serializable,
    Iterable<GarbageCollector> {
        GarbageCollector[] collectors;

        GarbageCollectors() {
        }

        public static GarbageCollectors readGarbageCollectors(StreamInput in) throws IOException {
            GarbageCollectors collectors = new GarbageCollectors();
            collectors.readFrom(in);
            return collectors;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.collectors = new GarbageCollector[in.readVInt()];
            for (int i = 0; i < this.collectors.length; ++i) {
                this.collectors[i] = GarbageCollector.readGarbageCollector(in);
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.collectors.length);
            for (GarbageCollector gc : this.collectors) {
                gc.writeTo(out);
            }
        }

        public GarbageCollector[] collectors() {
            return this.collectors;
        }

        @Override
        public Iterator<GarbageCollector> iterator() {
            return Iterators.forArray(this.collectors);
        }

        public long collectionCount() {
            long collectionCount = 0L;
            for (GarbageCollector gc : this.collectors) {
                collectionCount += gc.collectionCount();
            }
            return collectionCount;
        }

        public TimeValue collectionTime() {
            long collectionTime = 0L;
            for (GarbageCollector gc : this.collectors) {
                collectionTime += gc.collectionTime;
            }
            return new TimeValue(collectionTime, TimeUnit.MILLISECONDS);
        }
    }

    static final class Fields {
        static final XContentBuilderString JVM = new XContentBuilderString("jvm");
        static final XContentBuilderString TIMESTAMP = new XContentBuilderString("timestamp");
        static final XContentBuilderString UPTIME = new XContentBuilderString("uptime");
        static final XContentBuilderString UPTIME_IN_MILLIS = new XContentBuilderString("uptime_in_millis");
        static final XContentBuilderString MEM = new XContentBuilderString("mem");
        static final XContentBuilderString HEAP_USED = new XContentBuilderString("heap_used");
        static final XContentBuilderString HEAP_USED_IN_BYTES = new XContentBuilderString("heap_used_in_bytes");
        static final XContentBuilderString HEAP_COMMITTED = new XContentBuilderString("heap_committed");
        static final XContentBuilderString HEAP_COMMITTED_IN_BYTES = new XContentBuilderString("heap_committed_in_bytes");
        static final XContentBuilderString NON_HEAP_USED = new XContentBuilderString("non_heap_used");
        static final XContentBuilderString NON_HEAP_USED_IN_BYTES = new XContentBuilderString("non_heap_used_in_bytes");
        static final XContentBuilderString NON_HEAP_COMMITTED = new XContentBuilderString("non_heap_committed");
        static final XContentBuilderString NON_HEAP_COMMITTED_IN_BYTES = new XContentBuilderString("non_heap_committed_in_bytes");
        static final XContentBuilderString POOLS = new XContentBuilderString("pools");
        static final XContentBuilderString USED = new XContentBuilderString("used");
        static final XContentBuilderString USED_IN_BYTES = new XContentBuilderString("used_in_bytes");
        static final XContentBuilderString MAX = new XContentBuilderString("max");
        static final XContentBuilderString MAX_IN_BYTES = new XContentBuilderString("max_in_bytes");
        static final XContentBuilderString PEAK_USED = new XContentBuilderString("peak_used");
        static final XContentBuilderString PEAK_USED_IN_BYTES = new XContentBuilderString("peak_used_in_bytes");
        static final XContentBuilderString PEAK_MAX = new XContentBuilderString("peak_max");
        static final XContentBuilderString PEAK_MAX_IN_BYTES = new XContentBuilderString("peak_max_in_bytes");
        static final XContentBuilderString THREADS = new XContentBuilderString("threads");
        static final XContentBuilderString COUNT = new XContentBuilderString("count");
        static final XContentBuilderString PEAK_COUNT = new XContentBuilderString("peak_count");
        static final XContentBuilderString GC = new XContentBuilderString("gc");
        static final XContentBuilderString COLLECTORS = new XContentBuilderString("collectors");
        static final XContentBuilderString COLLECTION_COUNT = new XContentBuilderString("collection_count");
        static final XContentBuilderString COLLECTION_TIME = new XContentBuilderString("collection_time");
        static final XContentBuilderString COLLECTION_TIME_IN_MILLIS = new XContentBuilderString("collection_time_in_millis");
        static final XContentBuilderString BUFFER_POOLS = new XContentBuilderString("buffer_pools");
        static final XContentBuilderString NAME = new XContentBuilderString("name");
        static final XContentBuilderString TOTAL_CAPACITY = new XContentBuilderString("total_capacity");
        static final XContentBuilderString TOTAL_CAPACITY_IN_BYTES = new XContentBuilderString("total_capacity_in_bytes");

        Fields() {
        }
    }
}

