/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.jmx.action;

import java.io.IOException;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.jmx.JmxService;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.FutureTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class GetJmxServiceUrlAction
extends AbstractComponent {
    private final JmxService jmxService;
    private final TransportService transportService;
    private final ClusterService clusterService;

    @Inject
    public GetJmxServiceUrlAction(Settings settings, JmxService jmxService, TransportService transportService, ClusterService clusterService) {
        super(settings);
        this.jmxService = jmxService;
        this.transportService = transportService;
        this.clusterService = clusterService;
        transportService.registerHandler("jmx/publishUrl", new GetJmxServiceUrlTransportHandler());
    }

    public String obtainPublishUrl(DiscoveryNode node) throws ElasticSearchException {
        if (this.clusterService.state().nodes().localNodeId().equals(node.id())) {
            return this.jmxService.publishUrl();
        }
        return this.transportService.submitRequest(node, "jmx/publishUrl", TransportRequest.Empty.INSTANCE, new FutureTransportResponseHandler<GetJmxServiceUrlResponse>(){

            @Override
            public GetJmxServiceUrlResponse newInstance() {
                return new GetJmxServiceUrlResponse();
            }
        }).txGet().url();
    }

    static class GetJmxServiceUrlResponse
    extends TransportResponse {
        private String url;

        GetJmxServiceUrlResponse() {
        }

        GetJmxServiceUrlResponse(String url) {
            this.url = url;
        }

        public String url() {
            return this.url;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.url = in.readString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.url);
        }
    }

    private class GetJmxServiceUrlTransportHandler
    extends BaseTransportRequestHandler<TransportRequest.Empty> {
        static final String ACTION = "jmx/publishUrl";

        private GetJmxServiceUrlTransportHandler() {
        }

        @Override
        public TransportRequest.Empty newInstance() {
            return TransportRequest.Empty.INSTANCE;
        }

        @Override
        public String executor() {
            return "same";
        }

        @Override
        public void messageReceived(TransportRequest.Empty request, TransportChannel channel) throws Exception {
            channel.sendResponse(new GetJmxServiceUrlResponse(GetJmxServiceUrlAction.this.jmxService.publishUrl()));
        }
    }
}

