/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.jmx;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;
import javax.management.ServiceNotFoundException;
import org.elasticsearch.common.Classes;
import org.elasticsearch.common.Preconditions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.jmx.MBean;
import org.elasticsearch.jmx.ManagedAttribute;
import org.elasticsearch.jmx.ManagedGroupName;
import org.elasticsearch.jmx.ManagedOperation;

public class ResourceDMBean
implements DynamicMBean {
    private static final Class<?>[] primitives = new Class[]{Integer.TYPE, Byte.TYPE, Short.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Boolean.TYPE, Character.TYPE};
    private final ESLogger logger;
    private final Object obj;
    private final String objectName;
    private final String groupName;
    private final String fullObjectName;
    private final String description;
    private final MBeanAttributeInfo[] attributesInfo;
    private final MBeanOperationInfo[] operationsInfo;
    private final MBeanInfo mBeanInfo;
    private final ImmutableMap<String, AttributeEntry> attributes;
    private final ImmutableList<MBeanOperationInfo> operations;

    public ResourceDMBean(Object instance, ESLogger logger) {
        Preconditions.checkNotNull(instance, "Cannot make an MBean wrapper for null instance");
        this.obj = instance;
        this.logger = logger;
        MapBuilder<String, AttributeEntry> attributesBuilder = MapBuilder.newMapBuilder();
        ArrayList<MBeanOperationInfo> operationsBuilder = new ArrayList<MBeanOperationInfo>();
        MBean mBean = this.obj.getClass().getAnnotation(MBean.class);
        this.groupName = this.findGroupName();
        this.objectName = mBean != null && Strings.hasLength(mBean.objectName()) ? mBean.objectName() : (Strings.hasLength(this.groupName) ? "" : this.obj.getClass().getSimpleName());
        StringBuilder sb = new StringBuilder(this.groupName);
        if (Strings.hasLength(this.groupName) && Strings.hasLength(this.objectName)) {
            sb.append(",");
        }
        sb.append(this.objectName);
        this.fullObjectName = sb.toString();
        this.description = this.findDescription();
        this.findFields(attributesBuilder);
        this.findMethods(attributesBuilder, operationsBuilder);
        this.attributes = attributesBuilder.immutableMap();
        this.operations = ImmutableList.copyOf(operationsBuilder);
        this.attributesInfo = new MBeanAttributeInfo[this.attributes.size()];
        int i = 0;
        for (AttributeEntry entry : this.attributes.values()) {
            MBeanAttributeInfo info = entry.getInfo();
            this.attributesInfo[i++] = info;
            if (!logger.isInfoEnabled()) continue;
            logger.trace("Attribute " + info.getName() + "[r=" + info.isReadable() + ",w=" + info.isWritable() + ",is=" + info.isIs() + ",type=" + info.getType() + "]", new Object[0]);
        }
        this.operationsInfo = new MBeanOperationInfo[this.operations.size()];
        this.operations.toArray(this.operationsInfo);
        if (logger.isTraceEnabled()) {
            if (this.operations.size() > 0) {
                logger.trace("Operations are:", new Object[0]);
            }
            for (MBeanOperationInfo op : this.operationsInfo) {
                logger.trace("Operation " + op.getReturnType() + " " + op.getName(), new Object[0]);
            }
        }
        this.mBeanInfo = new MBeanInfo(this.getObject().getClass().getCanonicalName(), this.description, this.attributesInfo, null, this.operationsInfo, null);
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.mBeanInfo;
    }

    @Override
    public synchronized Object getAttribute(String name) throws AttributeNotFoundException {
        if (name == null || name.length() == 0) {
            throw new NullPointerException("Invalid attribute requested " + name);
        }
        Attribute attr = this.getNamedAttribute(name);
        if (attr == null) {
            throw new AttributeNotFoundException("Unknown attribute '" + name + "'. Known attributes names are: " + this.attributes.keySet());
        }
        return attr.getValue();
    }

    @Override
    public synchronized void setAttribute(Attribute attribute) {
        if (attribute == null || attribute.getName() == null) {
            throw new NullPointerException("Invalid attribute requested " + attribute);
        }
        this.setNamedAttribute(attribute);
    }

    @Override
    public synchronized AttributeList getAttributes(String[] names) {
        AttributeList al = new AttributeList();
        for (String name : names) {
            Attribute attr = this.getNamedAttribute(name);
            if (attr != null) {
                al.add(attr);
                continue;
            }
            this.logger.warn("Did not find attribute " + name, new Object[0]);
        }
        return al;
    }

    @Override
    public synchronized AttributeList setAttributes(AttributeList list) {
        AttributeList results = new AttributeList();
        for (Object aList : list) {
            Attribute attr = (Attribute)aList;
            if (this.setNamedAttribute(attr)) {
                results.add(attr);
                continue;
            }
            if (!this.logger.isWarnEnabled()) continue;
            this.logger.warn("Failed to update attribute name " + attr.getName() + " with value " + attr.getValue(), new Object[0]);
        }
        return results;
    }

    @Override
    public Object invoke(String name, Object[] args, String[] sig) throws MBeanException, ReflectionException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Invoke method called on " + name, new Object[0]);
        }
        MBeanOperationInfo opInfo = null;
        for (MBeanOperationInfo op : this.operationsInfo) {
            if (!op.getName().equals(name)) continue;
            opInfo = op;
            break;
        }
        if (opInfo == null) {
            String msg = "Operation " + name + " not in ModelMBeanInfo";
            throw new MBeanException(new ServiceNotFoundException(msg), msg);
        }
        try {
            Class[] classes = new Class[sig.length];
            for (int i = 0; i < classes.length; ++i) {
                classes[i] = this.getClassForName(sig[i]);
            }
            Method method = this.getObject().getClass().getMethod(name, classes);
            return method.invoke(this.getObject(), args);
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    Object getObject() {
        return this.obj;
    }

    private Class<?> getClassForName(String name) throws ClassNotFoundException {
        try {
            return Classes.getDefaultClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException cnfe) {
            for (Class<?> primitive : primitives) {
                if (!name.equals(primitive.getName())) continue;
                return primitive;
            }
            throw new ClassNotFoundException("Class " + name + " cannot be found");
        }
    }

    private String findGroupName() {
        for (Class<?> objClass = this.getObject().getClass(); objClass != Object.class; objClass = objClass.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = objClass.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(ManagedGroupName.class)) continue;
                try {
                    method.setAccessible(true);
                    return (String)method.invoke(this.getObject(), new Object[0]);
                }
                catch (Exception e) {
                    this.logger.warn("Failed to get group name for [" + this.getObject() + "]", e, new Object[0]);
                }
            }
        }
        return "";
    }

    private String findDescription() {
        MBean mbean = this.getObject().getClass().getAnnotation(MBean.class);
        if (mbean != null && mbean.description() != null && mbean.description().trim().length() > 0) {
            return mbean.description();
        }
        return "";
    }

    private void findMethods(MapBuilder<String, AttributeEntry> attributesBuilder, List<MBeanOperationInfo> ops) {
        ArrayList<Method> methods = new ArrayList<Method>(Arrays.asList(this.getObject().getClass().getMethods()));
        ArrayList<Method> objectMethods = new ArrayList<Method>(Arrays.asList(Object.class.getMethods()));
        methods.removeAll(objectMethods);
        for (Method method : methods) {
            boolean isAlreadyExposed;
            ManagedAttribute attr = method.getAnnotation(ManagedAttribute.class);
            if (attr != null) {
                MethodAttributeEntry mae;
                MBeanAttributeInfo info;
                String methodName = method.getName();
                if (!(methodName.startsWith("get") || methodName.startsWith("set") || methodName.startsWith("is"))) {
                    if (!this.logger.isWarnEnabled()) continue;
                    this.logger.warn("method name " + methodName + " doesn't start with \"get\", \"set\", or \"is\"" + ", but is annotated with @ManagedAttribute: will be ignored", new Object[0]);
                    continue;
                }
                String attributeName = null;
                boolean writeAttribute = false;
                if (this.isSetMethod(method)) {
                    attributeName = methodName.substring(3);
                    info = new MBeanAttributeInfo(attributeName, method.getParameterTypes()[0].getCanonicalName(), attr.description(), true, true, false);
                    writeAttribute = true;
                } else if (method.getParameterTypes().length == 0 && method.getReturnType() != Void.TYPE) {
                    boolean hasSetter = attributesBuilder.containsKey(attributeName);
                    if (methodName.startsWith("is")) {
                        attributeName = methodName.substring(2);
                        info = new MBeanAttributeInfo(attributeName, method.getReturnType().getCanonicalName(), attr.description(), true, hasSetter, true);
                    } else {
                        attributeName = methodName.substring(3);
                        info = new MBeanAttributeInfo(attributeName, method.getReturnType().getCanonicalName(), attr.description(), true, hasSetter, false);
                    }
                } else {
                    if (!this.logger.isWarnEnabled()) continue;
                    this.logger.warn("Method " + method.getName() + " must have a valid return type and zero parameters", new Object[0]);
                    continue;
                }
                AttributeEntry ae = attributesBuilder.get(attributeName);
                if (!writeAttribute) {
                    if (ae instanceof FieldAttributeEntry && ae.getInfo().isReadable()) {
                        this.logger.warn("not adding annotated method " + method + " since we already have read attribute", new Object[0]);
                        continue;
                    }
                    if (ae instanceof MethodAttributeEntry) {
                        mae = (MethodAttributeEntry)ae;
                        if (!mae.hasSetMethod()) continue;
                        attributesBuilder.put(attributeName, new MethodAttributeEntry(mae.getInfo(), mae.getSetMethod(), method));
                        continue;
                    }
                    attributesBuilder.put(attributeName, new MethodAttributeEntry(info, null, method));
                    continue;
                }
                if (ae instanceof FieldAttributeEntry) {
                    if (ae.getInfo().isWritable()) {
                        this.logger.warn("Not adding annotated method " + methodName + " since we already have writable attribute", new Object[0]);
                        continue;
                    }
                    Field f = ((FieldAttributeEntry)ae).getField();
                    MBeanAttributeInfo i = new MBeanAttributeInfo(ae.getInfo().getName(), f.getType().getCanonicalName(), attr.description(), true, !Modifier.isFinal(f.getModifiers()), false);
                    attributesBuilder.put(attributeName, new FieldAttributeEntry(i, f));
                    continue;
                }
                if (ae instanceof MethodAttributeEntry) {
                    mae = (MethodAttributeEntry)ae;
                    if (!mae.hasIsOrGetMethod()) continue;
                    attributesBuilder.put(attributeName, new MethodAttributeEntry(info, method, mae.getIsOrGetMethod()));
                    continue;
                }
                attributesBuilder.put(attributeName, new MethodAttributeEntry(info, method, null));
                continue;
            }
            if (!method.isAnnotationPresent(ManagedOperation.class)) continue;
            ManagedOperation op = method.getAnnotation(ManagedOperation.class);
            String attName = method.getName();
            if (this.isSetMethod(method) || this.isGetMethod(method)) {
                attName = attName.substring(3);
            } else if (this.isIsMethod(method)) {
                attName = attName.substring(2);
            }
            if (isAlreadyExposed = attributesBuilder.containsKey(attName)) continue;
            ops.add(new MBeanOperationInfo(op != null ? op.description() : "", method));
        }
    }

    private boolean isSetMethod(Method method) {
        return method.getName().startsWith("set") && method.getParameterTypes().length == 1 && method.getReturnType() == Void.TYPE;
    }

    private boolean isGetMethod(Method method) {
        return method.getParameterTypes().length == 0 && method.getReturnType() != Void.TYPE && method.getName().startsWith("get");
    }

    private boolean isIsMethod(Method method) {
        return method.getParameterTypes().length == 0 && (method.getReturnType() == Boolean.TYPE || method.getReturnType() == Boolean.class) && method.getName().startsWith("is");
    }

    private void findFields(MapBuilder<String, AttributeEntry> attributesBuilder) {
        for (Class<?> clazz = this.getObject().getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                ManagedAttribute attr = field.getAnnotation(ManagedAttribute.class);
                if (attr == null) continue;
                String fieldName = this.renameToJavaCodingConvention(field.getName());
                MBeanAttributeInfo info = new MBeanAttributeInfo(fieldName, field.getType().getCanonicalName(), attr.description(), true, !Modifier.isFinal(field.getModifiers()) && attr.writable(), false);
                attributesBuilder.put(fieldName, new FieldAttributeEntry(info, field));
            }
        }
    }

    private Attribute getNamedAttribute(String name) {
        Attribute result = null;
        AttributeEntry entry = this.attributes.get(name);
        if (entry != null) {
            MBeanAttributeInfo i = entry.getInfo();
            try {
                result = new Attribute(name, entry.invoke(null));
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Attribute " + name + " has r=" + i.isReadable() + ",w=" + i.isWritable() + ",is=" + i.isIs() + " and value " + result.getValue(), new Object[0]);
                }
            }
            catch (Exception e) {
                this.logger.debug("Exception while reading value of attribute " + name, e, new Object[0]);
            }
        } else {
            this.logger.warn("Did not find queried attribute with name " + name, new Object[0]);
        }
        return result;
    }

    private boolean setNamedAttribute(Attribute attribute) {
        AttributeEntry entry;
        boolean result = false;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Invoking set on attribute " + attribute.getName() + " with value " + attribute.getValue(), new Object[0]);
        }
        if ((entry = this.attributes.get(attribute.getName())) != null) {
            try {
                entry.invoke(attribute);
                result = true;
            }
            catch (Exception e) {
                this.logger.warn("Exception while writing value for attribute " + attribute.getName(), e, new Object[0]);
            }
        } else {
            this.logger.warn("Could not invoke set on attribute " + attribute.getName() + " with value " + attribute.getValue(), new Object[0]);
        }
        return result;
    }

    private String renameToJavaCodingConvention(String fieldName) {
        if (fieldName.contains("_")) {
            Pattern p = Pattern.compile("_.");
            Matcher m = p.matcher(fieldName);
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                m.appendReplacement(sb, fieldName.substring(m.end() - 1, m.end()).toUpperCase());
            }
            m.appendTail(sb);
            char first = sb.charAt(0);
            if (Character.isLowerCase(first)) {
                sb.setCharAt(0, Character.toUpperCase(first));
            }
            return sb.toString();
        }
        if (Character.isLowerCase(fieldName.charAt(0))) {
            return fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        }
        return fieldName;
    }

    public boolean isManagedResource() {
        return !this.attributes.isEmpty() || !this.operations.isEmpty();
    }

    public String getFullObjectName() {
        return this.fullObjectName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    private static interface AttributeEntry {
        public Object invoke(Attribute var1) throws Exception;

        public MBeanAttributeInfo getInfo();
    }

    private class FieldAttributeEntry
    implements AttributeEntry {
        private final MBeanAttributeInfo info;
        private final Field field;

        public FieldAttributeEntry(MBeanAttributeInfo info, Field field) {
            this.info = info;
            this.field = field;
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
        }

        public Field getField() {
            return this.field;
        }

        @Override
        public Object invoke(Attribute a) throws Exception {
            if (a == null) {
                return this.field.get(ResourceDMBean.this.getObject());
            }
            this.field.set(ResourceDMBean.this.getObject(), a.getValue());
            return null;
        }

        @Override
        public MBeanAttributeInfo getInfo() {
            return this.info;
        }
    }

    private class MethodAttributeEntry
    implements AttributeEntry {
        final MBeanAttributeInfo info;
        final Method isOrGetmethod;
        final Method setMethod;

        public MethodAttributeEntry(MBeanAttributeInfo info, Method setMethod, Method isOrGetMethod) {
            this.info = info;
            this.setMethod = setMethod;
            this.isOrGetmethod = isOrGetMethod;
        }

        @Override
        public Object invoke(Attribute a) throws Exception {
            if (a == null && this.isOrGetmethod != null) {
                return this.isOrGetmethod.invoke(ResourceDMBean.this.getObject(), new Object[0]);
            }
            if (a != null && this.setMethod != null) {
                return this.setMethod.invoke(ResourceDMBean.this.getObject(), a.getValue());
            }
            return null;
        }

        @Override
        public MBeanAttributeInfo getInfo() {
            return this.info;
        }

        public boolean hasIsOrGetMethod() {
            return this.isOrGetmethod != null;
        }

        public boolean hasSetMethod() {
            return this.setMethod != null;
        }

        public Method getIsOrGetMethod() {
            return this.isOrGetmethod;
        }

        public Method getSetMethod() {
            return this.setMethod;
        }
    }
}

