/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.cache.filter;

import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.common.base.Objects;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.cache.RemovalListener;
import org.elasticsearch.common.cache.RemovalNotification;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.docset.DocSet;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.trove.set.hash.THashSet;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.cache.filter.weighted.WeightedFilterCache;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.node.settings.NodeSettingsService;
import org.elasticsearch.threadpool.ThreadPool;

public class IndicesFilterCache
extends AbstractComponent
implements RemovalListener<WeightedFilterCache.FilterCacheKey, DocSet> {
    private final ThreadPool threadPool;
    private Cache<WeightedFilterCache.FilterCacheKey, DocSet> cache;
    private volatile String size;
    private volatile long sizeInBytes;
    private volatile TimeValue expire;
    private final TimeValue cleanInterval;
    private final Set<Object> readersKeysToClean = ConcurrentCollections.newConcurrentSet();
    private volatile boolean closed;

    @Inject
    public IndicesFilterCache(Settings settings, ThreadPool threadPool, NodeSettingsService nodeSettingsService) {
        super(settings);
        this.threadPool = threadPool;
        this.size = this.componentSettings.get("size", "20%");
        this.expire = this.componentSettings.getAsTime("expire", null);
        this.cleanInterval = this.componentSettings.getAsTime("clean_interval", TimeValue.timeValueSeconds(60L));
        this.computeSizeInBytes();
        this.buildCache();
        this.logger.debug("using [node] weighted filter cache with size [{}], actual_size [{}], expire [{}], clean_interval [{}]", this.size, new ByteSizeValue(this.sizeInBytes), this.expire, this.cleanInterval);
        nodeSettingsService.addListener(new ApplySettings());
        threadPool.schedule(this.cleanInterval, "same", new ReaderCleaner());
    }

    private void buildCache() {
        CacheBuilder<WeightedFilterCache.FilterCacheKey, DocSet> cacheBuilder = CacheBuilder.newBuilder().removalListener(this).maximumWeight(this.sizeInBytes).weigher(new WeightedFilterCache.FilterCacheValueWeigher());
        cacheBuilder.concurrencyLevel(16);
        if (this.expire != null) {
            cacheBuilder.expireAfterAccess(this.expire.millis(), TimeUnit.MILLISECONDS);
        }
        this.cache = cacheBuilder.build();
    }

    private void computeSizeInBytes() {
        if (this.size.endsWith("%")) {
            double percent = Double.parseDouble(this.size.substring(0, this.size.length() - 1));
            this.sizeInBytes = (long)(percent / 100.0 * (double)JvmInfo.jvmInfo().getMem().getHeapMax().bytes());
        } else {
            this.sizeInBytes = ByteSizeValue.parseBytesSizeValue(this.size).bytes();
        }
    }

    public void addReaderKeyToClean(Object readerKey) {
        this.readersKeysToClean.add(readerKey);
    }

    public void close() {
        this.closed = true;
        this.cache.invalidateAll();
    }

    public Cache<WeightedFilterCache.FilterCacheKey, DocSet> cache() {
        return this.cache;
    }

    @Override
    public void onRemoval(RemovalNotification<WeightedFilterCache.FilterCacheKey, DocSet> removalNotification) {
        WeightedFilterCache.FilterCacheKey key = removalNotification.getKey();
        if (key == null) {
            return;
        }
        key.removalListener().onRemoval(removalNotification);
    }

    static {
        MetaData.addDynamicSettings("indices.cache.filter.size", "indices.cache.filter.expire");
    }

    class ReaderCleaner
    implements Runnable {
        ReaderCleaner() {
        }

        @Override
        public void run() {
            if (IndicesFilterCache.this.closed) {
                return;
            }
            if (IndicesFilterCache.this.readersKeysToClean.isEmpty()) {
                IndicesFilterCache.this.threadPool.schedule(IndicesFilterCache.this.cleanInterval, "same", this);
                return;
            }
            IndicesFilterCache.this.threadPool.executor("generic").execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    THashSet keys = CacheRecycler.popHashSet();
                    try {
                        Iterator<Object> it = IndicesFilterCache.this.readersKeysToClean.iterator();
                        while (it.hasNext()) {
                            keys.add(it.next());
                            it.remove();
                        }
                        IndicesFilterCache.this.cache.cleanUp();
                        if (!keys.isEmpty()) {
                            it = IndicesFilterCache.this.cache.asMap().keySet().iterator();
                            while (it.hasNext()) {
                                WeightedFilterCache.FilterCacheKey filterCacheKey = (WeightedFilterCache.FilterCacheKey)it.next();
                                if (!keys.contains(filterCacheKey.readerKey())) continue;
                                it.remove();
                            }
                        }
                        IndicesFilterCache.this.threadPool.schedule(IndicesFilterCache.this.cleanInterval, "same", ReaderCleaner.this);
                    }
                    finally {
                        CacheRecycler.pushHashSet(keys);
                    }
                }
            });
        }
    }

    class ApplySettings
    implements NodeSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            TimeValue expire;
            boolean replace = false;
            String size = settings.get("indices.cache.filter.size", IndicesFilterCache.this.size);
            if (!size.equals(IndicesFilterCache.this.size)) {
                IndicesFilterCache.this.logger.info("updating [indices.cache.filter.size] from [{}] to [{}]", IndicesFilterCache.this.size, size);
                IndicesFilterCache.this.size = size;
                replace = true;
            }
            if (!Objects.equal(expire = settings.getAsTime("indices.cache.filter.expire", IndicesFilterCache.this.expire), IndicesFilterCache.this.expire)) {
                IndicesFilterCache.this.logger.info("updating [indices.cache.filter.expire] from [{}] to [{}]", IndicesFilterCache.this.expire, expire);
                IndicesFilterCache.this.expire = expire;
                replace = true;
            }
            if (replace) {
                Cache oldCache = IndicesFilterCache.this.cache;
                IndicesFilterCache.this.computeSizeInBytes();
                IndicesFilterCache.this.buildCache();
                oldCache.invalidateAll();
            }
        }
    }
}

