/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.child;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.common.bytes.HashedBytesArray;
import org.elasticsearch.common.lucene.docset.GetDocSet;
import org.elasticsearch.common.lucene.search.NoopCollector;
import org.elasticsearch.common.trove.set.hash.THashSet;
import org.elasticsearch.index.cache.id.IdReaderTypeCache;
import org.elasticsearch.index.search.child.ChildCollector;
import org.elasticsearch.search.internal.ScopePhase;
import org.elasticsearch.search.internal.SearchContext;

public abstract class HasChildFilter
extends Filter
implements ScopePhase.CollectorPhase {
    final Query childQuery;
    final String scope;
    final String parentType;
    final String childType;
    final SearchContext searchContext;

    protected HasChildFilter(Query childQuery, String scope, String parentType, String childType, SearchContext searchContext) {
        this.searchContext = searchContext;
        this.parentType = parentType;
        this.childType = childType;
        this.scope = scope;
        this.childQuery = childQuery;
    }

    @Override
    public Query query() {
        return this.childQuery;
    }

    @Override
    public String scope() {
        return this.scope;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("child_filter[").append(this.childType).append("/").append(this.parentType).append("](").append(this.childQuery).append(')');
        return sb.toString();
    }

    public static HasChildFilter create(Query childQuery, String scope, String parentType, String childType, SearchContext searchContext, String executionType) {
        if ("bitset".equals(executionType)) {
            return new Bitset(childQuery, scope, parentType, childType, searchContext);
        }
        if ("uid".endsWith(executionType)) {
            return new Uid(childQuery, scope, parentType, childType, searchContext);
        }
        throw new ElasticSearchIllegalStateException("Illegal has_child execution type: " + executionType);
    }

    static class Uid
    extends HasChildFilter {
        THashSet<HashedBytesArray> collectedUids;

        Uid(Query childQuery, String scope, String parentType, String childType, SearchContext searchContext) {
            super(childQuery, scope, parentType, childType, searchContext);
        }

        @Override
        public boolean requiresProcessing() {
            return this.collectedUids == null;
        }

        @Override
        public Collector collector() {
            this.collectedUids = CacheRecycler.popHashSet();
            return new UidCollector(this.parentType, this.searchContext, this.collectedUids);
        }

        @Override
        public void processCollector(Collector collector) {
            this.collectedUids = ((UidCollector)collector).collectedUids;
        }

        @Override
        public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
            if (this.collectedUids == null) {
                throw new ElasticSearchIllegalStateException("has_child filter hasn't executed properly");
            }
            IdReaderTypeCache idReaderTypeCache = this.searchContext.idCache().reader(reader).type(this.parentType);
            if (idReaderTypeCache != null) {
                return new ParentDocSet(reader, this.collectedUids, idReaderTypeCache);
            }
            return null;
        }

        @Override
        public void clear() {
            if (this.collectedUids != null) {
                CacheRecycler.pushHashSet(this.collectedUids);
            }
            this.collectedUids = null;
        }

        static class UidCollector
        extends NoopCollector {
            final String parentType;
            final SearchContext context;
            final THashSet<HashedBytesArray> collectedUids;
            private IdReaderTypeCache typeCache;

            UidCollector(String parentType, SearchContext context, THashSet<HashedBytesArray> collectedUids) {
                this.parentType = parentType;
                this.context = context;
                this.collectedUids = collectedUids;
            }

            @Override
            public void collect(int doc) throws IOException {
                if (this.typeCache != null) {
                    this.collectedUids.add(this.typeCache.parentIdByDoc(doc));
                }
            }

            @Override
            public void setNextReader(IndexReader reader, int docBase) throws IOException {
                this.typeCache = this.context.idCache().reader(reader).type(this.parentType);
            }
        }

        static class ParentDocSet
        extends GetDocSet {
            final IndexReader reader;
            final THashSet<HashedBytesArray> parents;
            final IdReaderTypeCache typeCache;

            ParentDocSet(IndexReader reader, THashSet<HashedBytesArray> parents, IdReaderTypeCache typeCache) {
                super(reader.maxDoc());
                this.reader = reader;
                this.parents = parents;
                this.typeCache = typeCache;
            }

            @Override
            public boolean get(int doc) {
                return !this.reader.isDeleted(doc) && this.parents.contains(this.typeCache.idByDoc(doc));
            }
        }
    }

    static class Bitset
    extends HasChildFilter {
        private Map<Object, FixedBitSet> parentDocs;

        public Bitset(Query childQuery, String scope, String parentType, String childType, SearchContext searchContext) {
            super(childQuery, scope, parentType, childType, searchContext);
        }

        @Override
        public boolean requiresProcessing() {
            return this.parentDocs == null;
        }

        @Override
        public Collector collector() {
            return new ChildCollector(this.parentType, this.searchContext);
        }

        @Override
        public void processCollector(Collector collector) {
            this.parentDocs = ((ChildCollector)collector).parentDocs();
        }

        @Override
        public void clear() {
            this.parentDocs = null;
        }

        @Override
        public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
            if (this.parentDocs == null) {
                throw new ElasticSearchIllegalStateException("has_child filter hasn't executed properly");
            }
            return this.parentDocs.get(reader.getCoreCacheKey());
        }
    }
}

