/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.field.data.bytes;

import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.support.NumericFieldDataComparator;

public class ByteFieldDataMissingComparator
extends NumericFieldDataComparator {
    private final byte[] values;
    private short bottom;
    private final byte missingValue;

    public ByteFieldDataMissingComparator(int numHits, String fieldName, FieldDataCache fieldDataCache, byte missingValue) {
        super(fieldName, fieldDataCache);
        this.values = new byte[numHits];
        this.missingValue = missingValue;
    }

    @Override
    public FieldDataType fieldDataType() {
        return FieldDataType.DefaultTypes.BYTE;
    }

    @Override
    public int compare(int slot1, int slot2) {
        return this.values[slot1] - this.values[slot2];
    }

    @Override
    public int compareBottom(int doc) {
        byte value = this.missingValue;
        if (this.currentFieldData.hasValue(doc)) {
            value = this.currentFieldData.byteValue(doc);
        }
        return this.bottom - value;
    }

    @Override
    public void copy(int slot, int doc) {
        byte value = this.missingValue;
        if (this.currentFieldData.hasValue(doc)) {
            value = this.currentFieldData.byteValue(doc);
        }
        this.values[slot] = value;
    }

    @Override
    public void setBottom(int bottom) {
        this.bottom = this.values[bottom];
    }

    public Comparable value(int slot) {
        return Byte.valueOf(this.values[slot]);
    }
}

