/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.ByteSizeValue;

public class Segment
implements Streamable {
    private String name;
    private long generation;
    public boolean committed;
    public boolean search;
    public long sizeInBytes = -1L;
    public int docCount = -1;
    public int delDocCount = -1;

    Segment() {
    }

    public Segment(String name) {
        this.name = name;
        this.generation = Long.parseLong(name.substring(1), 36);
    }

    public String name() {
        return this.name;
    }

    public String getName() {
        return this.name();
    }

    public long generation() {
        return this.generation;
    }

    public long getGeneration() {
        return this.generation;
    }

    public boolean committed() {
        return this.committed;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public boolean search() {
        return this.search;
    }

    public boolean isSearch() {
        return this.search;
    }

    public int numDocs() {
        return this.docCount;
    }

    public int getNumDocs() {
        return this.docCount;
    }

    public int deletedDocs() {
        return this.delDocCount;
    }

    public int getDeletedDocs() {
        return this.delDocCount;
    }

    public ByteSizeValue size() {
        return new ByteSizeValue(this.sizeInBytes);
    }

    public ByteSizeValue getSize() {
        return this.size();
    }

    public long sizeInBytes() {
        return this.sizeInBytes;
    }

    public long getSizeInBytes() {
        return this.sizeInBytes();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Segment segment = (Segment)o;
        return !(this.name != null ? !this.name.equals(segment.name) : segment.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public static Segment readSegment(StreamInput in) throws IOException {
        Segment segment = new Segment();
        segment.readFrom(in);
        return segment;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readUTF();
        this.generation = Long.parseLong(this.name.substring(1), 36);
        this.committed = in.readBoolean();
        this.search = in.readBoolean();
        this.docCount = in.readInt();
        this.delDocCount = in.readInt();
        this.sizeInBytes = in.readLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeBoolean(this.committed);
        out.writeBoolean(this.search);
        out.writeInt(this.docCount);
        out.writeInt(this.delDocCount);
        out.writeLong(this.sizeInBytes);
    }
}

