/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search.vectorhighlight;

import org.apache.lucene.search.vectorhighlight.BoundaryScanner;
import org.elasticsearch.common.trove.set.hash.TCharHashSet;

public class SimpleBoundaryScanner2
implements BoundaryScanner {
    public static final int DEFAULT_MAX_SCAN = 20;
    public static final char[] DEFAULT_BOUNDARY_CHARS = new char[]{'.', ',', '!', '?', ' ', '\t', '\n'};
    public static final SimpleBoundaryScanner2 DEFAULT = new SimpleBoundaryScanner2();
    public int maxScan;
    public TCharHashSet boundaryChars;

    public SimpleBoundaryScanner2() {
        this(20, DEFAULT_BOUNDARY_CHARS);
    }

    public SimpleBoundaryScanner2(int maxScan, char[] boundaryChars) {
        this.maxScan = maxScan;
        this.boundaryChars = new TCharHashSet(boundaryChars);
    }

    @Override
    public int findStartOffset(StringBuilder buffer, int start) {
        int offset;
        if (start > buffer.length() || start < 1) {
            return start;
        }
        int count = this.maxScan;
        for (offset = start; offset > 0 && count > 0; --offset, --count) {
            if (!this.boundaryChars.contains(buffer.charAt(offset - 1))) continue;
            return offset;
        }
        if (offset == 0) {
            return 0;
        }
        return start;
    }

    @Override
    public int findEndOffset(StringBuilder buffer, int start) {
        if (start > buffer.length() || start < 0) {
            return start;
        }
        int count = this.maxScan;
        for (int offset = start; offset < buffer.length() && count > 0; ++offset, --count) {
            if (!this.boundaryChars.contains(buffer.charAt(offset))) continue;
            return offset;
        }
        return start;
    }
}

