/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.joda.time;

import java.lang.reflect.Method;
import java.text.DateFormatSymbols;
import java.util.Locale;
import org.elasticsearch.common.joda.time.Chronology;
import org.elasticsearch.common.joda.time.DateTimeField;
import org.elasticsearch.common.joda.time.DateTimeZone;
import org.elasticsearch.common.joda.time.DurationFieldType;
import org.elasticsearch.common.joda.time.Interval;
import org.elasticsearch.common.joda.time.JodaTimePermission;
import org.elasticsearch.common.joda.time.PeriodType;
import org.elasticsearch.common.joda.time.ReadableDuration;
import org.elasticsearch.common.joda.time.ReadableInstant;
import org.elasticsearch.common.joda.time.ReadableInterval;
import org.elasticsearch.common.joda.time.ReadablePartial;
import org.elasticsearch.common.joda.time.chrono.ISOChronology;

public class DateTimeUtils {
    private static final SystemMillisProvider SYSTEM_MILLIS_PROVIDER = new SystemMillisProvider();
    private static volatile MillisProvider cMillisProvider = SYSTEM_MILLIS_PROVIDER;

    protected DateTimeUtils() {
    }

    public static final long currentTimeMillis() {
        return cMillisProvider.getMillis();
    }

    public static final void setCurrentMillisSystem() throws SecurityException {
        DateTimeUtils.checkPermission();
        cMillisProvider = SYSTEM_MILLIS_PROVIDER;
    }

    public static final void setCurrentMillisFixed(long l) throws SecurityException {
        DateTimeUtils.checkPermission();
        cMillisProvider = new FixedMillisProvider(l);
    }

    public static final void setCurrentMillisOffset(long l) throws SecurityException {
        DateTimeUtils.checkPermission();
        cMillisProvider = l == 0L ? SYSTEM_MILLIS_PROVIDER : new OffsetMillisProvider(l);
    }

    public static final void setCurrentMillisProvider(MillisProvider millisProvider) throws SecurityException {
        if (millisProvider == null) {
            throw new IllegalArgumentException("The MillisProvider must not be null");
        }
        DateTimeUtils.checkPermission();
        cMillisProvider = millisProvider;
    }

    private static void checkPermission() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new JodaTimePermission("CurrentTime.setProvider"));
        }
    }

    public static final long getInstantMillis(ReadableInstant readableInstant) {
        if (readableInstant == null) {
            return DateTimeUtils.currentTimeMillis();
        }
        return readableInstant.getMillis();
    }

    public static final Chronology getInstantChronology(ReadableInstant readableInstant) {
        if (readableInstant == null) {
            return ISOChronology.getInstance();
        }
        Chronology chronology = readableInstant.getChronology();
        if (chronology == null) {
            return ISOChronology.getInstance();
        }
        return chronology;
    }

    public static final Chronology getIntervalChronology(ReadableInstant readableInstant, ReadableInstant readableInstant2) {
        Chronology chronology = null;
        if (readableInstant != null) {
            chronology = readableInstant.getChronology();
        } else if (readableInstant2 != null) {
            chronology = readableInstant2.getChronology();
        }
        if (chronology == null) {
            chronology = ISOChronology.getInstance();
        }
        return chronology;
    }

    public static final Chronology getIntervalChronology(ReadableInterval readableInterval) {
        if (readableInterval == null) {
            return ISOChronology.getInstance();
        }
        Chronology chronology = readableInterval.getChronology();
        if (chronology == null) {
            return ISOChronology.getInstance();
        }
        return chronology;
    }

    public static final ReadableInterval getReadableInterval(ReadableInterval readableInterval) {
        if (readableInterval == null) {
            long l = DateTimeUtils.currentTimeMillis();
            readableInterval = new Interval(l, l);
        }
        return readableInterval;
    }

    public static final Chronology getChronology(Chronology chronology) {
        if (chronology == null) {
            return ISOChronology.getInstance();
        }
        return chronology;
    }

    public static final DateTimeZone getZone(DateTimeZone dateTimeZone) {
        if (dateTimeZone == null) {
            return DateTimeZone.getDefault();
        }
        return dateTimeZone;
    }

    public static final PeriodType getPeriodType(PeriodType periodType) {
        if (periodType == null) {
            return PeriodType.standard();
        }
        return periodType;
    }

    public static final long getDurationMillis(ReadableDuration readableDuration) {
        if (readableDuration == null) {
            return 0L;
        }
        return readableDuration.getMillis();
    }

    public static final boolean isContiguous(ReadablePartial readablePartial) {
        if (readablePartial == null) {
            throw new IllegalArgumentException("Partial must not be null");
        }
        DurationFieldType durationFieldType = null;
        for (int i = 0; i < readablePartial.size(); ++i) {
            DateTimeField dateTimeField = readablePartial.getField(i);
            if (i > 0 && dateTimeField.getRangeDurationField().getType() != durationFieldType) {
                return false;
            }
            durationFieldType = dateTimeField.getDurationField().getType();
        }
        return true;
    }

    public static final DateFormatSymbols getDateFormatSymbols(Locale locale) {
        try {
            Method method = DateFormatSymbols.class.getMethod("getInstance", Locale.class);
            return (DateFormatSymbols)method.invoke(null, locale);
        }
        catch (Exception exception) {
            return new DateFormatSymbols(locale);
        }
    }

    static class OffsetMillisProvider
    implements MillisProvider {
        private final long iMillis;

        OffsetMillisProvider(long l) {
            this.iMillis = l;
        }

        public long getMillis() {
            return System.currentTimeMillis() + this.iMillis;
        }
    }

    static class FixedMillisProvider
    implements MillisProvider {
        private final long iMillis;

        FixedMillisProvider(long l) {
            this.iMillis = l;
        }

        public long getMillis() {
            return this.iMillis;
        }
    }

    static class SystemMillisProvider
    implements MillisProvider {
        SystemMillisProvider() {
        }

        public long getMillis() {
            return System.currentTimeMillis();
        }
    }

    public static interface MillisProvider {
        public long getMillis();
    }
}

