/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress.snappy.xerial;

import java.io.IOException;
import org.apache.lucene.store.IndexInput;
import org.elasticsearch.common.compress.snappy.SnappyCompressedIndexInput;
import org.elasticsearch.common.compress.snappy.SnappyCompressorContext;
import org.xerial.snappy.Snappy;

public class XerialSnappyCompressedIndexInput
extends SnappyCompressedIndexInput {
    public XerialSnappyCompressedIndexInput(IndexInput in, SnappyCompressorContext context) throws IOException {
        super(in, context);
    }

    @Override
    protected int uncompress(IndexInput in, byte[] out) throws IOException {
        boolean compressed = in.readByte() != 0;
        int length = in.readVInt();
        if (!compressed) {
            in.readBytes(out, 0, length);
            return length;
        }
        in.readBytes(this.inputBuffer, 0, length);
        return Snappy.rawUncompress((byte[])this.inputBuffer, (int)0, (int)length, (Object)out, (int)0);
    }
}

