/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.blobstore.fs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobMetaData;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.fs.FsBlobStore;
import org.elasticsearch.common.blobstore.support.AbstractBlobContainer;
import org.elasticsearch.common.blobstore.support.PlainBlobMetaData;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.io.Closeables;

public abstract class AbstractFsBlobContainer
extends AbstractBlobContainer {
    protected final FsBlobStore blobStore;
    protected final File path;

    public AbstractFsBlobContainer(FsBlobStore blobStore, BlobPath blobPath, File path) {
        super(blobPath);
        this.blobStore = blobStore;
        this.path = path;
    }

    public File filePath() {
        return this.path;
    }

    @Override
    public ImmutableMap<String, BlobMetaData> listBlobs() throws IOException {
        File[] files = this.path.listFiles();
        if (files == null || files.length == 0) {
            return ImmutableMap.of();
        }
        MapBuilder<String, PlainBlobMetaData> builder = MapBuilder.newMapBuilder();
        for (File file : files) {
            if (!file.isFile()) continue;
            builder.put(file.getName(), new PlainBlobMetaData(file.getName(), file.length()));
        }
        return builder.immutableMap();
    }

    @Override
    public boolean deleteBlob(String blobName) throws IOException {
        return new File(this.path, blobName).delete();
    }

    @Override
    public boolean blobExists(String blobName) {
        return new File(this.path, blobName).exists();
    }

    @Override
    public void readBlob(final String blobName, final BlobContainer.ReadBlobListener listener) {
        this.blobStore.executor().execute(new Runnable(){

            @Override
            public void run() {
                byte[] buffer = new byte[AbstractFsBlobContainer.this.blobStore.bufferSizeInBytes()];
                FileInputStream is = null;
                try {
                    is = new FileInputStream(new File(AbstractFsBlobContainer.this.path, blobName));
                }
                catch (FileNotFoundException e) {
                    Closeables.closeQuietly(is);
                    listener.onFailure(e);
                    return;
                }
                try {
                    int bytesRead;
                    while ((bytesRead = is.read(buffer)) != -1) {
                        listener.onPartial(buffer, 0, bytesRead);
                    }
                    listener.onCompleted();
                }
                catch (Exception e) {
                    Closeables.closeQuietly(is);
                    listener.onFailure(e);
                }
            }
        });
    }
}

