/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.transport.support;

import java.util.Map;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.action.TransportActionNodeProxy;
import org.elasticsearch.action.admin.cluster.ClusterAction;
import org.elasticsearch.client.internal.InternalClusterAdminClient;
import org.elasticsearch.client.support.AbstractClusterAdminClient;
import org.elasticsearch.client.transport.TransportClientNodesService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class InternalTransportClusterAdminClient
extends AbstractClusterAdminClient
implements InternalClusterAdminClient {
    private final TransportClientNodesService nodesService;
    private final ThreadPool threadPool;
    private final ImmutableMap<ClusterAction, TransportActionNodeProxy> actions;

    @Inject
    public InternalTransportClusterAdminClient(Settings settings, TransportClientNodesService nodesService, ThreadPool threadPool, TransportService transportService, Map<String, GenericAction> actions) {
        this.nodesService = nodesService;
        this.threadPool = threadPool;
        MapBuilder actionsBuilder = new MapBuilder();
        for (GenericAction action : actions.values()) {
            if (!(action instanceof ClusterAction)) continue;
            actionsBuilder.put((ClusterAction)action, new TransportActionNodeProxy(settings, action, transportService));
        }
        this.actions = actionsBuilder.immutableMap();
    }

    @Override
    public ThreadPool threadPool() {
        return this.threadPool;
    }

    @Override
    public <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder>> ActionFuture<Response> execute(ClusterAction<Request, Response, RequestBuilder> action, final Request request) {
        final TransportActionNodeProxy proxy = this.actions.get(action);
        return (ActionFuture)this.nodesService.execute(new TransportClientNodesService.NodeCallback<ActionFuture<Response>>(){

            @Override
            public ActionFuture<Response> doWithNode(DiscoveryNode node) throws ElasticSearchException {
                return proxy.execute(node, request);
            }
        });
    }

    @Override
    public <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder>> void execute(ClusterAction<Request, Response, RequestBuilder> action, final Request request, ActionListener<Response> listener) {
        final TransportActionNodeProxy proxy = this.actions.get(action);
        this.nodesService.execute(new TransportClientNodesService.NodeListenerCallback<Response>(){

            @Override
            public void doWithNode(DiscoveryNode node, ActionListener<Response> listener) throws ElasticSearchException {
                proxy.execute(node, request, listener);
            }
        }, listener);
    }
}

