/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.update;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.create.TransportCreateIndexAction;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.delete.TransportDeleteAction;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.index.TransportIndexAction;
import org.elasticsearch.action.support.AutoCreateIndex;
import org.elasticsearch.action.support.single.instance.TransportInstanceSingleOperationAction;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Requests;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.routing.PlainShardIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.engine.DocumentAlreadyExistsException;
import org.elasticsearch.index.engine.DocumentMissingException;
import org.elasticsearch.index.engine.DocumentSourceMissingException;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.get.GetField;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.shard.IllegalIndexShardStateException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.indices.IndexAlreadyExistsException;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.lookup.SourceLookup;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportUpdateAction
extends TransportInstanceSingleOperationAction<UpdateRequest, UpdateResponse> {
    private final IndicesService indicesService;
    private final TransportDeleteAction deleteAction;
    private final TransportIndexAction indexAction;
    private final ScriptService scriptService;
    private final AutoCreateIndex autoCreateIndex;
    private final TransportCreateIndexAction createIndexAction;

    @Inject
    public TransportUpdateAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, IndicesService indicesService, TransportIndexAction indexAction, TransportDeleteAction deleteAction, ScriptService scriptService, TransportCreateIndexAction createIndexAction) {
        super(settings, threadPool, clusterService, transportService);
        this.indicesService = indicesService;
        this.indexAction = indexAction;
        this.deleteAction = deleteAction;
        this.scriptService = scriptService;
        this.createIndexAction = createIndexAction;
        this.autoCreateIndex = new AutoCreateIndex(settings);
    }

    @Override
    protected String transportAction() {
        return "update";
    }

    @Override
    protected String executor() {
        return "index";
    }

    @Override
    protected UpdateRequest newRequest() {
        return new UpdateRequest();
    }

    @Override
    protected UpdateResponse newResponse() {
        return new UpdateResponse();
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, UpdateRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.WRITE);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, UpdateRequest request) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.WRITE, request.index());
    }

    @Override
    protected boolean retryOnFailure(Throwable e) {
        return (e = ExceptionsHelper.unwrapCause(e)) instanceof IllegalIndexShardStateException;
    }

    @Override
    protected boolean resolveRequest(ClusterState state, UpdateRequest request, ActionListener<UpdateResponse> listener) {
        MetaData metaData = this.clusterService.state().metaData();
        String aliasOrIndex = request.index();
        request.routing(metaData.resolveIndexRouting(request.routing(), aliasOrIndex));
        request.index(metaData.concreteIndex(request.index()));
        return true;
    }

    @Override
    protected void doExecute(final UpdateRequest request, final ActionListener<UpdateResponse> listener) {
        if (this.autoCreateIndex.shouldAutoCreate(request.index(), this.clusterService.state())) {
            request.beforeLocalFork();
            this.createIndexAction.execute(new CreateIndexRequest(request.index()).cause("auto(update api)").masterNodeTimeout(request.timeout()), new ActionListener<CreateIndexResponse>(){

                @Override
                public void onResponse(CreateIndexResponse result) {
                    TransportUpdateAction.this.innerExecute(request, listener);
                }

                @Override
                public void onFailure(Throwable e) {
                    if (ExceptionsHelper.unwrapCause(e) instanceof IndexAlreadyExistsException) {
                        try {
                            TransportUpdateAction.this.innerExecute(request, listener);
                        }
                        catch (Exception e1) {
                            listener.onFailure(e1);
                        }
                    } else {
                        listener.onFailure(e);
                    }
                }
            });
        } else {
            this.innerExecute(request, listener);
        }
    }

    private void innerExecute(UpdateRequest request, ActionListener<UpdateResponse> listener) {
        super.doExecute(request, listener);
    }

    @Override
    protected ShardIterator shards(ClusterState clusterState, UpdateRequest request) throws ElasticSearchException {
        ShardRouting shard;
        if (request.shardId() != -1) {
            return clusterState.routingTable().index(request.index()).shard(request.shardId()).primaryShardIt();
        }
        ShardIterator shardIterator = this.clusterService.operationRouting().indexShards(this.clusterService.state(), request.index(), request.type(), request.id(), request.routing());
        while ((shard = shardIterator.nextOrNull()) != null) {
            if (!shard.primary()) continue;
            return new PlainShardIterator(shardIterator.shardId(), ImmutableList.of(shard));
        }
        return new PlainShardIterator(shardIterator.shardId(), ImmutableList.<ShardRouting>of());
    }

    @Override
    protected void shardOperation(UpdateRequest request, ActionListener<UpdateResponse> listener) throws ElasticSearchException {
        this.shardOperation(request, listener, 0);
    }

    protected void shardOperation(final UpdateRequest request, final ActionListener<UpdateResponse> listener, final int retryCount) throws ElasticSearchException {
        Map updatedSourceAsMap;
        IndexRequest indexRequest;
        String parent;
        IndexService indexService = this.indicesService.indexServiceSafe(request.index());
        IndexShard indexShard = indexService.shardSafe(request.shardId());
        long getDate = System.currentTimeMillis();
        GetResult getResult = indexShard.getService().get(request.type(), request.id(), new String[]{"_source", "_routing", "_parent", "_ttl"}, true);
        if (!getResult.exists()) {
            if (request.upsertRequest() == null) {
                listener.onFailure(new DocumentMissingException(new ShardId(request.index(), request.shardId()), request.type(), request.id()));
                return;
            }
            IndexRequest indexRequest2 = request.upsertRequest();
            ((IndexRequest)((IndexRequest)indexRequest2.index(request.index())).type(request.type()).id(request.id()).create(true).routing(request.routing()).percolate(request.percolate()).refresh(request.refresh()).replicationType(request.replicationType())).consistencyLevel(request.consistencyLevel());
            indexRequest2.operationThreaded(false);
            final BytesReference updateSourceBytes = indexRequest2.source();
            this.indexAction.execute(indexRequest2, new ActionListener<IndexResponse>(){

                @Override
                public void onResponse(IndexResponse response) {
                    UpdateResponse update = new UpdateResponse(response.index(), response.type(), response.id(), response.version());
                    update.matches(response.matches());
                    if (request.fields() != null && request.fields().length > 0) {
                        Tuple<XContentType, Map<String, Object>> sourceAndContent = XContentHelper.convertToMap(updateSourceBytes, true);
                        update.getResult(TransportUpdateAction.this.extractGetResult(request, response.version(), sourceAndContent.v2(), sourceAndContent.v1(), updateSourceBytes));
                    } else {
                        update.getResult(null);
                    }
                    listener.onResponse(update);
                }

                @Override
                public void onFailure(Throwable e) {
                    if (((e = ExceptionsHelper.unwrapCause(e)) instanceof VersionConflictEngineException || e instanceof DocumentAlreadyExistsException) && retryCount < request.retryOnConflict()) {
                        TransportUpdateAction.this.threadPool.executor(TransportUpdateAction.this.executor()).execute(new Runnable(){

                            @Override
                            public void run() {
                                TransportUpdateAction.this.shardOperation(request, listener, retryCount + 1);
                            }
                        });
                        return;
                    }
                    listener.onFailure(e);
                }
            });
            return;
        }
        if (getResult.internalSourceRef() == null) {
            listener.onFailure(new DocumentSourceMissingException(new ShardId(request.index(), request.shardId()), request.type(), request.id()));
            return;
        }
        Tuple<XContentType, Map<String, Object>> sourceAndContent = XContentHelper.convertToMap(getResult.internalSourceRef(), true);
        String operation = null;
        String timestamp = null;
        Long ttl = null;
        Object fetchedTTL = null;
        final XContentType updateSourceContentType = sourceAndContent.v1();
        String routing = getResult.fields().containsKey("_routing") ? getResult.field("_routing").value().toString() : null;
        String string = parent = getResult.fields().containsKey("_parent") ? getResult.field("_parent").value().toString() : null;
        if (request.script() == null && request.doc() != null) {
            indexRequest = request.doc();
            updatedSourceAsMap = sourceAndContent.v2();
            if (indexRequest.ttl() > 0L) {
                ttl = indexRequest.ttl();
            }
            timestamp = indexRequest.timestamp();
            if (indexRequest.routing() != null) {
                routing = indexRequest.routing();
            }
            if (indexRequest.parent() != null) {
                parent = indexRequest.parent();
            }
            XContentHelper.update(updatedSourceAsMap, indexRequest.sourceAsMap());
        } else {
            Map ctx = new HashMap<String, Map<String, Object>>(2);
            ctx.put("_source", sourceAndContent.v2());
            try {
                ExecutableScript script = this.scriptService.executable(request.scriptLang, request.script, request.scriptParams);
                script.setNextVar("ctx", ctx);
                script.run();
                ctx = (Map)script.unwrap(ctx);
            }
            catch (Exception e) {
                throw new ElasticSearchIllegalArgumentException("failed to execute script", e);
            }
            operation = (String)ctx.get("op");
            timestamp = (String)ctx.get("_timestamp");
            fetchedTTL = ctx.get("_ttl");
            if (fetchedTTL != null) {
                ttl = fetchedTTL instanceof Number ? Long.valueOf(((Number)fetchedTTL).longValue()) : Long.valueOf(TimeValue.parseTimeValue(fetchedTTL, null).millis());
            }
            updatedSourceAsMap = (Map)ctx.get("_source");
        }
        if (ttl == null) {
            Long l = ttl = getResult.fields().containsKey("_ttl") ? (Long)getResult.field("_ttl").value() : null;
            if (ttl != null) {
                ttl = ttl - (System.currentTimeMillis() - getDate);
            }
        }
        if (operation == null || "index".equals(operation)) {
            indexRequest = ((IndexRequest)((IndexRequest)Requests.indexRequest(request.index()).type(request.type()).id(request.id()).routing(routing).parent(parent).source(updatedSourceAsMap, updateSourceContentType).version(getResult.version()).replicationType(request.replicationType())).consistencyLevel(request.consistencyLevel())).timestamp(timestamp).ttl(ttl).percolate(request.percolate()).refresh(request.refresh());
            indexRequest.operationThreaded(false);
            final BytesReference updateSourceBytes = indexRequest.source();
            this.indexAction.execute(indexRequest, new ActionListener<IndexResponse>(){

                @Override
                public void onResponse(IndexResponse response) {
                    UpdateResponse update = new UpdateResponse(response.index(), response.type(), response.id(), response.version());
                    update.matches(response.matches());
                    update.getResult(TransportUpdateAction.this.extractGetResult(request, response.version(), updatedSourceAsMap, updateSourceContentType, updateSourceBytes));
                    listener.onResponse(update);
                }

                @Override
                public void onFailure(Throwable e) {
                    if ((e = ExceptionsHelper.unwrapCause(e)) instanceof VersionConflictEngineException && retryCount < request.retryOnConflict()) {
                        TransportUpdateAction.this.threadPool.executor(TransportUpdateAction.this.executor()).execute(new Runnable(){

                            @Override
                            public void run() {
                                TransportUpdateAction.this.shardOperation(request, listener, retryCount + 1);
                            }
                        });
                        return;
                    }
                    listener.onFailure(e);
                }
            });
        } else if ("delete".equals(operation)) {
            DeleteRequest deleteRequest = (DeleteRequest)((DeleteRequest)Requests.deleteRequest(request.index()).type(request.type()).id(request.id()).routing(routing).parent(parent).version(getResult.version()).replicationType(request.replicationType())).consistencyLevel(request.consistencyLevel());
            deleteRequest.operationThreaded(false);
            this.deleteAction.execute(deleteRequest, new ActionListener<DeleteResponse>(){

                @Override
                public void onResponse(DeleteResponse response) {
                    UpdateResponse update = new UpdateResponse(response.index(), response.type(), response.id(), response.version());
                    update.getResult(TransportUpdateAction.this.extractGetResult(request, response.version(), updatedSourceAsMap, updateSourceContentType, null));
                    listener.onResponse(update);
                }

                @Override
                public void onFailure(Throwable e) {
                    if ((e = ExceptionsHelper.unwrapCause(e)) instanceof VersionConflictEngineException && retryCount < request.retryOnConflict()) {
                        TransportUpdateAction.this.threadPool.executor(TransportUpdateAction.this.executor()).execute(new Runnable(){

                            @Override
                            public void run() {
                                TransportUpdateAction.this.shardOperation(request, listener, retryCount + 1);
                            }
                        });
                        return;
                    }
                    listener.onFailure(e);
                }
            });
        } else if ("none".equals(operation)) {
            UpdateResponse update = new UpdateResponse(getResult.index(), getResult.type(), getResult.id(), getResult.version());
            update.getResult(this.extractGetResult(request, getResult.version(), updatedSourceAsMap, updateSourceContentType, null));
            listener.onResponse(update);
        } else {
            this.logger.warn("Used update operation [{}] for script [{}], doing nothing...", operation, request.script);
            listener.onResponse(new UpdateResponse(getResult.index(), getResult.type(), getResult.id(), getResult.version()));
        }
    }

    @Nullable
    protected GetResult extractGetResult(UpdateRequest request, long version, Map<String, Object> source, XContentType sourceContentType, @Nullable BytesReference sourceAsBytes) {
        if (request.fields() == null || request.fields().length == 0) {
            return null;
        }
        boolean sourceRequested = false;
        HashMap<String, GetField> fields = null;
        if (request.fields() != null && request.fields().length > 0) {
            SourceLookup sourceLookup = new SourceLookup();
            sourceLookup.setNextSource(source);
            for (String field : request.fields()) {
                GetField getField;
                if (field.equals("_source")) {
                    sourceRequested = true;
                    continue;
                }
                Object value = sourceLookup.extractValue(field);
                if (value == null) continue;
                if (fields == null) {
                    fields = Maps.newHashMapWithExpectedSize(2);
                }
                if ((getField = (GetField)fields.get(field)) == null) {
                    getField = new GetField(field, new ArrayList<Object>(2));
                    fields.put(field, getField);
                }
                getField.values().add(value);
            }
        }
        return new GetResult(request.index(), request.type(), request.id(), version, true, sourceRequested ? sourceAsBytes : null, fields);
    }
}

